/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.webhooks;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProhibitedNetworkAddressException;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.NetworkAddressRulesAdheringDnsResolver;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.wiremock.webhooks.WebhookDefinition;
import org.wiremock.webhooks.WebhookTransformer;
import wiremock.webhooks.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.webhooks.org.apache.hc.client5.http.DnsResolver;
import wiremock.webhooks.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import wiremock.webhooks.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import wiremock.webhooks.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import wiremock.webhooks.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import wiremock.webhooks.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.webhooks.org.apache.hc.core5.http.ContentType;
import wiremock.webhooks.org.apache.hc.core5.http.io.SocketConfig;
import wiremock.webhooks.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import wiremock.webhooks.org.apache.hc.core5.http.io.entity.EntityUtils;
import wiremock.webhooks.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import wiremock.webhooks.org.apache.hc.core5.util.TimeValue;
import wiremock.webhooks.org.apache.hc.core5.util.Timeout;

public class Webhooks
extends PostServeAction {
    private final ScheduledExecutorService scheduler;
    private final CloseableHttpClient httpClient;
    private final List<WebhookTransformer> transformers;
    private final TemplateEngine templateEngine;

    private Webhooks(ScheduledExecutorService scheduler, CloseableHttpClient httpClient, List<WebhookTransformer> transformers) {
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.transformers = transformers;
        this.templateEngine = TemplateEngine.defaultTemplateEngine();
    }

    private Webhooks(List<WebhookTransformer> transformers, NetworkAddressRules targetAddressRules) {
        this(Executors.newScheduledThreadPool(10), Webhooks.createHttpClient(targetAddressRules), transformers);
    }

    public Webhooks(NetworkAddressRules targetAddressRules) {
        this(new ArrayList<WebhookTransformer>(), targetAddressRules);
    }

    @JsonCreator
    public Webhooks() {
        this(NetworkAddressRules.ALLOW_ALL);
    }

    public Webhooks(WebhookTransformer ... transformers) {
        this(Arrays.asList(transformers), NetworkAddressRules.ALLOW_ALL);
    }

    private static CloseableHttpClient createHttpClient(NetworkAddressRules targetAddressRules) {
        return HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().setDnsResolver((DnsResolver)new NetworkAddressRulesAdheringDnsResolver(targetAddressRules)).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds(30000L)).build()).setMaxConnPerRoute(1000).setMaxConnTotal(1000).setValidateAfterInactivity(TimeValue.ofSeconds(5L)).build()).setConnectionReuseStrategy((request, response, context) -> false).setKeepAliveStrategy((response, context) -> TimeValue.ZERO_MILLISECONDS).build();
    }

    public String getName() {
        return "webhook";
    }

    public void doAction(ServeEvent serveEvent, Admin admin, Parameters parameters) {
        ClassicHttpRequest request;
        WebhookDefinition definition;
        Notifier notifier = LocalNotifier.notifier();
        try {
            definition = WebhookDefinition.from(parameters);
            for (WebhookTransformer transformer : this.transformers) {
                definition = transformer.transform(serveEvent, definition);
            }
            definition = this.applyTemplating(definition, serveEvent);
            request = Webhooks.buildRequest(definition);
        }
        catch (Exception e) {
            LocalNotifier.notifier().error("Exception thrown while configuring webhook", (Throwable)e);
            return;
        }
        WebhookDefinition finalDefinition = definition;
        this.scheduler.schedule(() -> {
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                notifier.info(String.format("Webhook %s request to %s returned status %s\n\n%s", finalDefinition.getMethod(), finalDefinition.getUrl(), response.getCode(), EntityUtils.toString(response.getEntity())));
            }
            catch (ProhibitedNetworkAddressException e) {
                notifier.error("The target webhook address is denied in WireMock's configuration.");
            }
            catch (Exception e) {
                notifier.error(String.format("Failed to fire webhook %s %s", finalDefinition.getMethod(), finalDefinition.getUrl()), (Throwable)e);
            }
        }, finalDefinition.getDelaySampleMillis(), TimeUnit.MILLISECONDS);
    }

    private WebhookDefinition applyTemplating(WebhookDefinition webhookDefinition, ServeEvent serveEvent) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("parameters", webhookDefinition.getExtraParameters() != null ? webhookDefinition.getExtraParameters() : Collections.emptyMap());
        model.put("originalRequest", RequestTemplateModel.from((Request)serveEvent.getRequest()));
        WebhookDefinition renderedWebhookDefinition = webhookDefinition.withUrl(this.renderTemplate(model, webhookDefinition.getUrl())).withMethod(this.renderTemplate(model, webhookDefinition.getMethod())).withHeaders(webhookDefinition.getHeaders().all().stream().map(header -> new HttpHeader(header.key(), (Collection)header.values().stream().map(value -> this.renderTemplate(model, (String)value)).collect(Collectors.toList()))).collect(Collectors.toList()));
        if (webhookDefinition.getBody() != null) {
            renderedWebhookDefinition = webhookDefinition.withBody(this.renderTemplate(model, webhookDefinition.getBody()));
        }
        return renderedWebhookDefinition;
    }

    private String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }

    private static ClassicHttpRequest buildRequest(WebhookDefinition definition) {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create(definition.getMethod()).setUri(definition.getUrl());
        for (HttpHeader header : definition.getHeaders().all()) {
            for (String value : header.values()) {
                requestBuilder.addHeader(header.key(), value);
            }
        }
        if (definition.getRequestMethod().hasEntity() && definition.hasBody()) {
            requestBuilder.setEntity(new ByteArrayEntity(definition.getBinaryBody(), ContentType.DEFAULT_BINARY));
        }
        return requestBuilder.build();
    }

    public static WebhookDefinition webhook() {
        return new WebhookDefinition();
    }
}

