/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import wiremock.webhooks.com.github.jknack.handlebars.Context;
import wiremock.webhooks.com.github.jknack.handlebars.Handlebars;
import wiremock.webhooks.com.github.jknack.handlebars.Helper;
import wiremock.webhooks.com.github.jknack.handlebars.Lambda;
import wiremock.webhooks.com.github.jknack.handlebars.Options;
import wiremock.webhooks.com.github.jknack.handlebars.PathCompiler;
import wiremock.webhooks.com.github.jknack.handlebars.PathExpression;
import wiremock.webhooks.com.github.jknack.handlebars.TagType;
import wiremock.webhooks.com.github.jknack.handlebars.Template;
import wiremock.webhooks.com.github.jknack.handlebars.internal.BaseTemplate;
import wiremock.webhooks.com.github.jknack.handlebars.internal.HelperResolver;
import wiremock.webhooks.com.github.jknack.handlebars.internal.Lambdas;
import wiremock.webhooks.com.github.jknack.handlebars.internal.Param;
import wiremock.webhooks.com.github.jknack.handlebars.internal.lang3.Validate;

class Block
extends HelperResolver {
    protected Template body;
    protected final String name;
    private final boolean inverted;
    private final String type;
    private String startDelimiter;
    private String endDelimiter;
    protected Template inverse = Template.EMPTY;
    private String inverseLabel;
    protected Helper<Object> helper;
    protected final List<String> blockParams;
    protected TagType tagType;
    protected final List<PathExpression> path;
    private boolean decorate;

    Block(Handlebars handlebars, String name, boolean inverted, String type, List<Param> params, Map<String, Param> hash, List<String> blockParams) {
        super(handlebars);
        this.name = Validate.notNull(name, "The name is required.", new Object[0]);
        this.path = PathCompiler.compile(name, handlebars.parentScopeResolution());
        this.inverted = inverted;
        this.type = type;
        this.params(params);
        this.hash(hash);
        this.blockParams = blockParams;
        this.tagType = TagType.SECTION;
        this.postInit();
    }

    protected void postInit() {
        this.helper = this.helper(this.name);
    }

    @Override
    public void before(Context context, Writer writer) throws IOException {
        if (this.body instanceof BaseTemplate) {
            LinkedList partials = (LinkedList)context.data("__inline_partials_");
            partials.addLast(new HashMap((Map)partials.getLast()));
            ((BaseTemplate)this.body).before(context, writer);
        }
    }

    @Override
    public void after(Context context, Writer writer) throws IOException {
        if (this.body instanceof BaseTemplate) {
            ((BaseTemplate)this.body).after(context, writer);
            LinkedList partials = (LinkedList)context.data("__inline_partials_");
            partials.removeLast();
        }
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        String helperName;
        Object it;
        Template template = this.body;
        Context itCtx = context;
        Helper<Object> helper = this.helper;
        if (helper == null) {
            Helper<Object> missing;
            it = Block.transform(itCtx.get(this.path));
            if (this.inverted) {
                helperName = "unless";
            } else if (it instanceof Iterable) {
                helperName = "each";
            } else if (it instanceof Boolean) {
                helperName = "if";
            } else if (it instanceof Lambda) {
                helperName = "with";
                template = Lambdas.compile(this.handlebars, (Lambda)it, context, template, this.startDelimiter, this.endDelimiter);
            } else {
                helperName = "with";
                itCtx = Context.newContext(context, it);
            }
            helper = this.handlebars.helper(helperName);
            if (it == null && (missing = this.helper("helperMissing")) != null) {
                helper = missing;
            }
        } else {
            helperName = this.name;
            it = Block.transform(this.determineContext(context));
        }
        Options options = new Options(this.handlebars, helperName, this.tagType, itCtx, template, this.inverse, this.params(itCtx), this.hash(itCtx), this.blockParams, writer);
        options.data(Context.PARAM_SIZE, this.params.size());
        Object result = helper.apply(it, options);
        if (result != null) {
            writer.append(result.toString());
        }
    }

    public String name() {
        return this.name;
    }

    public boolean inverted() {
        return this.inverted;
    }

    public Block body(Template body) {
        this.body = Validate.notNull(body, "The template's body is required.", new Object[0]);
        if (body instanceof BaseTemplate) {
            this.decorate = ((BaseTemplate)body).decorate();
        }
        return this;
    }

    @Override
    public boolean decorate() {
        return this.decorate;
    }

    public Template inverse(String inverseLabel, Template inverse) {
        Validate.notNull(inverseLabel, "The inverseLabel can't be null.", new Object[0]);
        Validate.isTrue(inverseLabel.equals("^") || inverseLabel.equals("else"), "The inverseLabel must be one of '^' or 'else'. Found: " + inverseLabel, new Object[0]);
        this.inverseLabel = inverseLabel;
        this.inverse = Validate.notNull(inverse, "The inverse's template is required.", new Object[0]);
        return this;
    }

    public Template inverse() {
        return this.inverse;
    }

    public Block endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Block startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public Template body() {
        return this.body;
    }

    @Override
    public String text() {
        return this.text(true, true);
    }

    private String text(boolean complete, boolean close) {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.type).append(this.name);
        String params = this.paramsToString(this.params);
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        if (this.blockParams.size() > 0) {
            buffer.append(" as |").append(this.paramsToString(this.blockParams)).append("|");
        }
        buffer.append(this.endDelimiter);
        if (complete) {
            buffer.append(this.body == null ? "" : this.body.text());
            if (this.inverse != EMPTY) {
                if (this.inverse instanceof Block) {
                    String elseif = ((Block)this.inverse).text(true, false);
                    buffer.append(elseif);
                } else {
                    buffer.append(this.startDelimiter).append(this.inverseLabel).append(this.endDelimiter).append(this.inverse.text());
                }
            }
        } else {
            buffer.append("\n...\n");
        }
        if (close) {
            buffer.append(this.startDelimiter);
            if (this.type.equals("{{")) {
                buffer.append("{{");
            }
            buffer.append('/').append(this.name).append(this.endDelimiter);
        }
        return buffer.toString();
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        if (this.body != null) {
            tagNames.addAll(this.body.collect(tagType));
        }
        tagNames.addAll(this.inverse.collect(tagType));
        tagNames.addAll(super.collect(tagType));
        return new ArrayList<String>(tagNames);
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (tagType == this.tagType) {
            result.add(this.name);
        }
        super.collect(result, tagType);
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        if (this.body != null) {
            paramNames.addAll(this.body.collectReferenceParameters());
        }
        paramNames.addAll(this.inverse.collectReferenceParameters());
        paramNames.addAll(super.collectReferenceParameters());
        return new ArrayList<String>(paramNames);
    }
}

