/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.com.github.jknack.handlebars.internal;

import java.util.List;
import wiremock.webhooks.com.github.jknack.handlebars.Formatter;
import wiremock.webhooks.com.github.jknack.handlebars.internal.lang3.Validate;

public class FormatterChain
implements Formatter.Chain {
    private List<Formatter> chain;
    private int index;

    public FormatterChain(List<Formatter> formatter) {
        this.chain = formatter;
    }

    private FormatterChain(List<Formatter> formatter, int index) {
        this.chain = formatter;
        this.index = index;
    }

    private Formatter.Chain next() {
        if (this.index + 1 < this.chain.size()) {
            return new FormatterChain(this.chain, this.index + 1);
        }
        return Formatter.NOOP;
    }

    @Override
    public Object format(Object value) {
        Object output;
        Formatter formatter = this.chain.get(this.index);
        if (formatter != null) {
            output = formatter.format(value, this.next());
            Validate.notNull(output, "Formatter " + formatter.getClass() + " returned a null result for " + value, new Object[0]);
        } else {
            output = value.toString();
        }
        return output;
    }
}

