/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import wiremock.webhooks.com.github.jknack.handlebars.Context;
import wiremock.webhooks.com.github.jknack.handlebars.Handlebars;
import wiremock.webhooks.com.github.jknack.handlebars.TagType;
import wiremock.webhooks.com.github.jknack.handlebars.Template;
import wiremock.webhooks.com.github.jknack.handlebars.internal.BaseTemplate;
import wiremock.webhooks.com.github.jknack.handlebars.internal.BlockDecorator;
import wiremock.webhooks.com.github.jknack.handlebars.internal.Partial;
import wiremock.webhooks.com.github.jknack.handlebars.internal.VarDecorator;

class TemplateList
extends BaseTemplate
implements Iterable<Template> {
    private final List<Template> nodes = new ArrayList<Template>();
    private final List<BaseTemplate> decorators = new ArrayList<BaseTemplate>();
    private boolean decorate;

    TemplateList(Handlebars handlebars) {
        super(handlebars);
    }

    public boolean add(Template child) {
        this.nodes.add(child);
        if (child instanceof VarDecorator || child instanceof BlockDecorator || child instanceof Partial) {
            this.decorators.add((BaseTemplate)child);
            this.decorate = true;
        }
        return true;
    }

    @Override
    public void before(Context context, Writer writer) throws IOException {
        for (BaseTemplate node : this.decorators) {
            node.before(context, writer);
        }
    }

    @Override
    public void after(Context context, Writer writer) throws IOException {
        for (BaseTemplate node : this.decorators) {
            node.after(context, writer);
        }
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        for (Template node : this.nodes) {
            node.apply(context, writer);
        }
    }

    @Override
    public final boolean decorate() {
        return this.decorate;
    }

    @Override
    public String text() {
        StringBuilder buffer = new StringBuilder();
        for (Template node : this.nodes) {
            buffer.append(node.text());
        }
        return buffer.toString();
    }

    @Override
    public Iterator<Template> iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.nodes.size();
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        for (Template node : this.nodes) {
            tagNames.addAll(node.collect(tagType));
        }
        return new ArrayList<String>(tagNames);
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        for (Template node : this.nodes) {
            paramNames.addAll(node.collectReferenceParameters());
        }
        return new ArrayList<String>(paramNames);
    }

    @Override
    public String toString() {
        return this.nodes.toString();
    }
}

