/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import wiremock.webhooks.com.github.jknack.handlebars.Context;
import wiremock.webhooks.com.github.jknack.handlebars.EscapingStrategy;
import wiremock.webhooks.com.github.jknack.handlebars.Formatter;
import wiremock.webhooks.com.github.jknack.handlebars.Handlebars;
import wiremock.webhooks.com.github.jknack.handlebars.Helper;
import wiremock.webhooks.com.github.jknack.handlebars.Lambda;
import wiremock.webhooks.com.github.jknack.handlebars.Options;
import wiremock.webhooks.com.github.jknack.handlebars.PathCompiler;
import wiremock.webhooks.com.github.jknack.handlebars.PathExpression;
import wiremock.webhooks.com.github.jknack.handlebars.TagType;
import wiremock.webhooks.com.github.jknack.handlebars.Template;
import wiremock.webhooks.com.github.jknack.handlebars.internal.ForwardingTemplate;
import wiremock.webhooks.com.github.jknack.handlebars.internal.HelperResolver;
import wiremock.webhooks.com.github.jknack.handlebars.internal.Lambdas;
import wiremock.webhooks.com.github.jknack.handlebars.internal.Param;

class Variable
extends HelperResolver {
    protected final String name;
    protected final TagType type;
    private String startDelimiter;
    private String endDelimiter;
    private EscapingStrategy escapingStrategy;
    private Helper<Object> helper;
    private Formatter.Chain formatter;
    private Helper<Object> missing;
    private List<PathExpression> path;
    private static final List<String> BPARAMS = Collections.emptyList();
    private boolean noArg;
    private Template emptyVar;

    Variable(Handlebars handlebars, String name, TagType type, List<Param> params, Map<String, Param> hash) {
        super(handlebars);
        this.name = name.trim();
        this.path = PathCompiler.compile(name, handlebars.parentScopeResolution());
        this.type = type;
        this.emptyVar = Variable.empty(this);
        this.params(params);
        this.hash(hash);
        this.escapingStrategy = type == TagType.VAR ? handlebars.getEscapingStrategy() : EscapingStrategy.NOOP;
        this.formatter = handlebars.getFormatter();
        this.noArg = params.size() == 0 && hash.size() == 0;
        this.postInit();
    }

    protected void postInit() {
        this.helper = this.helper(this.name);
        this.missing = this.handlebars.helper("helperMissing");
    }

    public String name() {
        return this.name;
    }

    @Override
    protected void merge(Context scope, Writer writer) throws IOException {
        Object value = this.value(scope, writer);
        if (value != null) {
            writer.append(this.formatAndEscape(value, this.formatter));
        }
    }

    public Object value(Context scope, Writer writer) throws IOException {
        boolean blockParam;
        boolean bl = blockParam = scope.isBlockParams() && this.noArg;
        if (this.helper != null && !blockParam) {
            Options options = new Options(this.handlebars, this.name, this.type, scope, this.emptyVar, Template.EMPTY, this.params(scope), this.hash(scope), BPARAMS, writer);
            options.data(Context.PARAM_SIZE, this.params.size());
            return this.helper.apply(this.determineContext(scope), options);
        }
        Object value = scope.get(this.path);
        if (value == null && this.missing != null) {
            Options options = new Options(this.handlebars, this.name, this.type, scope, this.emptyVar, Template.EMPTY, this.params(scope), this.hash(scope), BPARAMS, writer);
            options.data(Context.PARAM_SIZE, this.params.size());
            value = this.missing.apply(this.determineContext(scope), options);
        }
        if (value instanceof Lambda) {
            value = Lambdas.merge(this.handlebars, (Lambda)value, scope, this);
        }
        return value;
    }

    private static Template empty(Variable variable) {
        return new ForwardingTemplate(variable){

            @Override
            public String apply(Context context) throws IOException {
                return "";
            }

            @Override
            public void apply(Context context, Writer writer) throws IOException {
            }

            @Override
            public String apply(Object context) throws IOException {
                return "";
            }

            @Override
            public void apply(Object context, Writer writer) throws IOException {
            }
        };
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (this.type == tagType) {
            result.add(this.name);
        }
        super.collect(result, tagType);
    }

    protected CharSequence formatAndEscape(Object value, Formatter.Chain formatter) {
        Object formatted = formatter.format(value);
        String formattedString = formatted.toString();
        if (formatted instanceof Handlebars.SafeString) {
            return formattedString;
        }
        CharSequence escapedString = this.escapingStrategy.escape(formattedString);
        return escapedString;
    }

    @Override
    public String text() {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.suffix()).append(this.name);
        String params = this.paramsToString(this.params);
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        return buffer.append(this.endDelimiter).toString();
    }

    protected String suffix() {
        return "";
    }

    public Variable endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Variable startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }
}

