/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.com.github.jknack.handlebars.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import wiremock.webhooks.com.github.jknack.handlebars.internal.lang3.Validate;
import wiremock.webhooks.com.github.jknack.handlebars.io.URLTemplateLoader;

public class FileTemplateLoader
extends URLTemplateLoader {
    public FileTemplateLoader(File basedir, String suffix) {
        Validate.notNull(basedir, "The base dir is required.", new Object[0]);
        Validate.isTrue(basedir.exists(), "File not found: %s", basedir);
        Validate.isTrue(basedir.isDirectory(), "A directory is required: %s", basedir);
        this.setPrefix(basedir.toString());
        this.setSuffix(suffix);
    }

    public FileTemplateLoader(File basedir) {
        this(basedir, ".hbs");
    }

    public FileTemplateLoader(String basedir, String suffix) {
        this.setPrefix(basedir);
        this.setSuffix(suffix);
    }

    public FileTemplateLoader(String basedir) {
        this(basedir, ".hbs");
    }

    @Override
    protected URL getResource(String location) throws IOException {
        File file = new File(location);
        return file.exists() ? file.toURI().toURL() : null;
    }
}

