/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.client5.http.impl;

import wiremock.webhooks.org.apache.hc.client5.http.SchemePortResolver;
import wiremock.webhooks.org.apache.hc.core5.annotation.Contract;
import wiremock.webhooks.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.hc.core5.http.HttpHost;
import wiremock.webhooks.org.apache.hc.core5.http.URIScheme;
import wiremock.webhooks.org.apache.hc.core5.net.NamedEndpoint;
import wiremock.webhooks.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) {
        Args.notNull(host, "HTTP host");
        return this.resolve(host.getSchemeName(), host);
    }

    @Override
    public int resolve(String scheme, NamedEndpoint endpoint) {
        Args.notNull(endpoint, "Endpoint");
        int port = endpoint.getPort();
        if (port > 0) {
            return port;
        }
        if (URIScheme.HTTP.same(scheme)) {
            return 80;
        }
        if (URIScheme.HTTPS.same(scheme)) {
            return 443;
        }
        return -1;
    }
}

