/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.client5.http.impl.async;

import wiremock.webhooks.org.apache.hc.client5.http.impl.async.LoggingIOSession;
import wiremock.webhooks.org.apache.hc.core5.function.Decorator;
import wiremock.webhooks.org.apache.hc.core5.reactor.IOSession;
import wiremock.webhooks.org.slf4j.Logger;
import wiremock.webhooks.org.slf4j.LoggerFactory;

final class LoggingIOSessionDecorator
implements Decorator<IOSession> {
    public static final LoggingIOSessionDecorator INSTANCE = new LoggingIOSessionDecorator();
    private static final Logger WIRE_LOG = LoggerFactory.getLogger("wiremock.webhooks.org.apache.hc.client5.http.wire");

    private LoggingIOSessionDecorator() {
    }

    @Override
    public IOSession decorate(IOSession ioSession) {
        Logger sessionLog = LoggerFactory.getLogger(ioSession.getClass());
        if (sessionLog.isDebugEnabled() || WIRE_LOG.isDebugEnabled()) {
            return new LoggingIOSession(ioSession, sessionLog, WIRE_LOG);
        }
        return ioSession;
    }
}

