/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.client5.http.impl.auth;

import java.util.concurrent.ConcurrentHashMap;
import wiremock.webhooks.org.apache.hc.client5.http.auth.AuthScope;
import wiremock.webhooks.org.apache.hc.client5.http.auth.Credentials;
import wiremock.webhooks.org.apache.hc.client5.http.auth.CredentialsStore;
import wiremock.webhooks.org.apache.hc.client5.http.impl.auth.CredentialsMatcher;
import wiremock.webhooks.org.apache.hc.core5.annotation.Contract;
import wiremock.webhooks.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.webhooks.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCredentialsProvider
implements CredentialsStore {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Authentication scope");
        this.credMap.put(authScope, credentials);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope, HttpContext context) {
        return CredentialsMatcher.matchCredentials(this.credMap, authScope);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.credMap.keySet())).toString();
    }
}

