/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import wiremock.webhooks.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import wiremock.webhooks.org.apache.hc.client5.http.HttpRoute;
import wiremock.webhooks.org.apache.hc.client5.http.UserTokenHandler;
import wiremock.webhooks.org.apache.hc.client5.http.classic.ExecChain;
import wiremock.webhooks.org.apache.hc.client5.http.classic.ExecChainHandler;
import wiremock.webhooks.org.apache.hc.client5.http.classic.ExecRuntime;
import wiremock.webhooks.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import wiremock.webhooks.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import wiremock.webhooks.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import wiremock.webhooks.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.webhooks.org.apache.hc.core5.annotation.Contract;
import wiremock.webhooks.org.apache.hc.core5.annotation.Internal;
import wiremock.webhooks.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.webhooks.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.webhooks.org.apache.hc.core5.http.ConnectionReuseStrategy;
import wiremock.webhooks.org.apache.hc.core5.http.EntityDetails;
import wiremock.webhooks.org.apache.hc.core5.http.HttpEntity;
import wiremock.webhooks.org.apache.hc.core5.http.HttpException;
import wiremock.webhooks.org.apache.hc.core5.http.message.RequestLine;
import wiremock.webhooks.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.webhooks.org.apache.hc.core5.http.protocol.HttpProcessor;
import wiremock.webhooks.org.apache.hc.core5.io.CloseMode;
import wiremock.webhooks.org.apache.hc.core5.util.Args;
import wiremock.webhooks.org.apache.hc.core5.util.TimeValue;
import wiremock.webhooks.org.slf4j.Logger;
import wiremock.webhooks.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;

    public MainClientExec(HttpClientConnectionManager connectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        try {
            context.setAttribute("http.route", route);
            context.setAttribute("http.request", request);
            this.httpProcessor.process(request, (EntityDetails)request.getEntity(), (HttpContext)context);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, context);
            context.setAttribute("http.response", response);
            this.httpProcessor.process(response, (EntityDetails)response.getEntity(), (HttpContext)context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, request, context);
                context.setAttribute("http.user-token", userToken);
            }
            if (this.reuseStrategy.keepAlive(request, response, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                if (LOG.isDebugEnabled()) {
                    String s2 = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", (Object)exchangeId, (Object)s2);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response, null);
            }
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

