/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jdbc.driver.helpers;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;
import org.wisdom.jdbc.driver.helpers.BeanUtils;

public abstract class AbstractDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties props) throws SQLException {
        if (props == null) {
            props = new Properties();
        }
        DataSource dataSource = this.newDataSource();
        AbstractDataSourceFactory.setBeanProperties(dataSource, props);
        return dataSource;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        if (props == null) {
            props = new Properties();
        }
        ConnectionPoolDataSource dataSource = this.newConnectionPoolDataSource();
        AbstractDataSourceFactory.setBeanProperties(dataSource, props);
        return dataSource;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        if (props == null) {
            props = new Properties();
        }
        XADataSource dataSource = this.newXADataSource();
        AbstractDataSourceFactory.setBeanProperties(dataSource, props);
        return dataSource;
    }

    public Driver createDriver(Properties props) throws SQLException {
        Driver driver = this.newJdbcDriver();
        AbstractDataSourceFactory.setBeanProperties(driver, props);
        return driver;
    }

    static void setBeanProperties(Object object, Properties props) throws SQLException {
        if (props != null) {
            Enumeration<Object> enumeration = props.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                BeanUtils.setProperty(object, name, props.getProperty(name));
            }
        }
    }

    public abstract Driver newJdbcDriver() throws SQLException;

    public abstract DataSource newDataSource() throws SQLException;

    public abstract ConnectionPoolDataSource newConnectionPoolDataSource() throws SQLException;

    public abstract XADataSource newXADataSource() throws SQLException;
}

