/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtCompile;
import org.wisepersist.gradle.plugins.gwt.GwtDraftCompile;

public class GwtCompilerPlugin
implements Plugin<Project> {
    public static final String OUT_DIR = "out";
    public static final String DRAFT_OUT_DIR = "draftOut";
    public static final String TASK_COMPILE_GWT = "compileGwt";
    public static final String TASK_DRAFT_COMPILE_GWT = "draftCompileGwt";
    public static final String TASK_CHECK = "checkGwt";

    public void apply(Project project) {
        project.getPlugins().apply(GwtBasePlugin.class);
        File gwtBuildDir = new File(project.getBuildDir(), "gwt");
        project.getTasks().register(TASK_COMPILE_GWT, GwtCompile.class, task -> {
            task.setWar(new File(gwtBuildDir, OUT_DIR));
            task.setDescription("Runs the GWT compiler to translate Java sources to JavaScript for production ready output");
            task.dependsOn(new Object[]{project.getTasks().named("compileJava"), project.getTasks().named("processResources")});
        });
        project.getTasks().register(TASK_DRAFT_COMPILE_GWT, GwtDraftCompile.class, task -> {
            task.setWar(new File(gwtBuildDir, DRAFT_OUT_DIR));
            task.setDescription("Runs the GWT compiler to produce draft quality output used for development");
            task.dependsOn(new Object[]{project.getTasks().named("compileJava"), project.getTasks().named("processResources")});
        });
        project.getTasks().register(TASK_CHECK, task -> {
            task.setDescription("Runs the GWT compiler to validate the relevant sources");
            task.dependsOn(new Object[]{project.getTasks().named("compileJava"), project.getTasks().named("processResources")});
            task.setGroup("verification");
        });
    }
}

