/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.wiztools.commons.StreamUtil;

public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentAsString(File f, Charset charset) throws IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(f);
            String string = StreamUtil.inputStream2String(is, charset);
            return string;
        }
    }

    public static List<String> getContentAsStringList(File f, Charset charset) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset));){
            String line;
            ArrayList<String> out = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                out.add(line);
            }
            ArrayList<String> arrayList = out;
            return arrayList;
        }
    }

    public static byte[] getContentAsBytes(File f) throws IOException {
        return StreamUtil.inputStream2Bytes(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(File f) {
        String type = null;
        URLConnection uc = null;
        try {
            URL u = f.toURI().toURL();
            uc = u.openConnection();
            type = uc.getContentType();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (uc != null) {
                // empty if block
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File f, String content, Charset charset) throws IOException {
        try (PrintWriter w = null;){
            w = new PrintWriter(f, charset.name());
            w.print(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File f, byte[] bytes) throws IOException {
        try (FileOutputStream os = null;){
            os = new FileOutputStream(f);
            ((OutputStream)os).write(bytes, 0, bytes.length);
        }
    }

    public static void copy(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String name : files = source.list()) {
                FileUtil.copy(new File(source, name), new File(dest, name));
            }
        } else {
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileChannel fcSource = new FileInputStream(source).getChannel();
            FileChannel fcDest = new FileOutputStream(dest).getChannel();
            fcDest.transferFrom(fcSource, 0L, fcSource.size());
            if (fcSource != null) {
                fcSource.close();
            }
            if (fcDest != null) {
                fcDest.close();
            }
        }
    }
}

