/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.wiztools.commons.MultiValueMap;

public class MultiValueMapLinkedHashSet<K, V>
implements MultiValueMap<K, V> {
    private Map<K, Set<V>> map = new LinkedHashMap<K, Set<V>>();

    @Override
    public Collection<V> put(K key, V value) {
        Set<V> l = this.map.get(key);
        if (l == null) {
            l = new LinkedHashSet<V>();
        }
        l.add(value);
        return this.map.put(key, l);
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        for (K key : this.map.keySet()) {
            Set<V> values = this.map.get(key);
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (K key : this.map.keySet()) {
            Set<V> v = this.map.get(key);
            values.addAll(v);
        }
        return values;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiValueMap)) {
            return false;
        }
        MultiValueMap other = (MultiValueMap)obj;
        if (!(this.keySet() == other.keySet() || this.keySet() != null && this.keySet().equals(other.keySet()))) {
            return false;
        }
        return this.values() == other.values() || this.values() != null && this.values().equals(other.values());
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.map != null ? this.map.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.map.toString();
    }
}

