/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.HashMap;
import java.util.Map;

public final class RotN {
    private static final char[] lookup = "abcdefghijklmnopqrstuvwxyz".toCharArray();

    private RotN() {
    }

    private static void map(int n, Emitter emitter) {
        if (n < 1 || n > 25) {
            throw new IllegalArgumentException("Value of N should be between 1 and 26");
        }
        int i = 0;
        int j = n;
        while (i < lookup.length) {
            if (j == lookup.length) {
                j = 0;
            }
            emitter.emit(lookup[i], lookup[j]);
            ++i;
            ++j;
        }
    }

    private static Map<Character, Character> getCipherMap(int n) {
        final HashMap<Character, Character> out = new HashMap<Character, Character>();
        Emitter emitter = new Emitter(){

            @Override
            public void emit(char c1, char c2) {
                out.put(Character.valueOf(c1), Character.valueOf(c2));
            }
        };
        RotN.map(n, emitter);
        return out;
    }

    private static Map<Character, Character> getDeCipherMap(int n) {
        final HashMap<Character, Character> out = new HashMap<Character, Character>();
        Emitter emitter = new Emitter(){

            @Override
            public void emit(char c1, char c2) {
                out.put(Character.valueOf(c2), Character.valueOf(c1));
            }
        };
        RotN.map(n, emitter);
        return out;
    }

    private static String process(String inString, Map<Character, Character> map) throws IllegalArgumentException {
        char[] arr = inString.toCharArray();
        StringBuilder sb = new StringBuilder(arr.length);
        for (char c : arr) {
            Character out = map.get(Character.valueOf(c));
            if (out == null) {
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(Character.toUpperCase(out.charValue()));
                continue;
            }
            sb.append(out);
        }
        return sb.toString();
    }

    public static String cipher(int n, String inString) throws IllegalArgumentException {
        return RotN.process(inString, RotN.getCipherMap(n));
    }

    public static String deCipher(int n, String inString) throws IllegalArgumentException {
        return RotN.process(inString, RotN.getDeCipherMap(n));
    }

    private static interface Emitter {
        public void emit(char var1, char var2);
    }
}

