/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipUtil {
    private ZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File input, File outputDir) throws IOException {
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("Output directory does not exist; or, is not a directory.");
        }
        try (ZipInputStream zis = null;){
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(input)));
            while ((entry = zis.getNextEntry()) != null) {
                File f;
                String name = entry.getName();
                if (entry.isDirectory()) {
                    f = new File(outputDir, name);
                    if (!f.mkdirs()) {
                        throw new IOException("Unable to create directory: " + f.getAbsolutePath());
                    }
                } else {
                    f = new File(outputDir, name);
                    try (OutputStream os = null;){
                        os = new BufferedOutputStream(new FileOutputStream(f));
                        byte[] buf = new byte[8192];
                        int count = -1;
                        while ((count = zis.read(buf)) != -1) {
                            os.write(buf, 0, count);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }
}

