/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.locationtech.jts.geom.Envelope;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.NodeItem;

public class PackedRTree {
    private static int NODE_ITEM_LEN = 40;
    static final int HILBERT_MAX = 65535;
    private int numItems;
    private int nodeSize;
    public NodeItem[] nodeItems;
    private long numNodes;
    private List<Pair<Integer, Integer>> levelBounds;

    public PackedRTree(List<? extends Item> items, short nodeSize) {
        this.numItems = items.size();
        this.init(nodeSize);
        int k = (int)(this.numNodes - (long)this.numItems);
        Iterator<? extends Item> it = items.iterator();
        for (int i = 0; i < this.numItems; ++i) {
            this.nodeItems[k++] = it.next().nodeItem;
        }
        this.generateNodes();
    }

    public void init(int nodeSize) {
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (this.numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        this.nodeSize = Math.min(Math.max(2, nodeSize), 65535);
        this.levelBounds = PackedRTree.generateLevelBounds(this.numItems, this.nodeSize);
        this.numNodes = ((Integer)this.levelBounds.get((int)0).second).intValue();
        this.nodeItems = new NodeItem[Math.toIntExact(this.numNodes)];
    }

    void generateNodes() {
        long end = 0L;
        for (int i = 0; i < this.levelBounds.size() - 1; i = (int)((short)(i + 1))) {
            long pos = ((Integer)this.levelBounds.get((int)i).first).intValue();
            end = ((Integer)this.levelBounds.get((int)i).second).intValue();
            long newpos = ((Integer)this.levelBounds.get((int)(i + 1)).first).intValue();
            while (pos < end) {
                NodeItem node = new NodeItem(pos);
                for (int j = 0; j < this.nodeSize && pos < end; j = (int)((short)(j + 1))) {
                    node.expand(this.nodeItems[(int)pos++]);
                }
                this.nodeItems[(int)newpos++] = node;
            }
        }
    }

    public static List<? extends Item> hilbertSort(List<? extends Item> items, NodeItem extent) {
        double minX = extent.minX;
        double minY = extent.minY;
        double width = extent.width();
        double height = extent.height();
        Collections.sort(items, (a, b) -> {
            long hb;
            long ha = PackedRTree.hibert(a.nodeItem, 65535, minX, minY, width, height);
            return ha - (hb = PackedRTree.hibert(b.nodeItem, 65535, minX, minY, width, height)) > 0L ? 1 : (ha - hb == 0L ? 0 : -1);
        });
        return items;
    }

    public static long hibert(NodeItem nodeItem, int hilbertMax, double minX, double minY, double width, double height) {
        long x = 0L;
        long y = 0L;
        if (width != 0.0) {
            x = (long)Math.floor((double)hilbertMax * ((nodeItem.minX + nodeItem.maxX) / 2.0 - minX) / width);
        }
        if (height != 0.0) {
            y = (long)Math.floor((double)hilbertMax * ((nodeItem.minY + nodeItem.maxY) / 2.0 - minY) / height);
        }
        return PackedRTree.hibert(x, y);
    }

    private static long hibert(long x, long y) {
        long a = x ^ y;
        long b = 0xFFFFL ^ a;
        long c = 0xFFFFL ^ (x | y);
        long d = x & (y ^ 0xFFFFL);
        long A = a | b >> 1;
        long B = a >> 1 ^ a;
        long C = c >> 1 ^ b & d >> 1 ^ c;
        long D = a & c >> 1 ^ d >> 1 ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 2 ^ b & b >> 2;
        B = a & b >> 2 ^ b & (a ^ b) >> 2;
        C ^= a & c >> 2 ^ b & d >> 2;
        D ^= b & c >> 2 ^ (a ^ b) & d >> 2;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 4 ^ b & b >> 4;
        B = a & b >> 4 ^ b & (a ^ b) >> 4;
        C ^= a & c >> 4 ^ b & d >> 4;
        D ^= b & c >> 4 ^ (a ^ b) & d >> 4;
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= a & c >> 8 ^ b & d >> 8;
        D ^= b & c >> 8 ^ (a ^ b) & d >> 8;
        a = C ^ C >> 1;
        b = D ^ D >> 1;
        long i0 = x ^ y;
        long i1 = b | 0xFFFFL ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FFL;
        i0 = (i0 | i0 << 4) & 0xF0F0F0FL;
        i0 = (i0 | i0 << 2) & 0x33333333L;
        i0 = (i0 | i0 << 1) & 0x55555555L;
        i1 = (i1 | i1 << 8) & 0xFF00FFL;
        i1 = (i1 | i1 << 4) & 0xF0F0F0FL;
        i1 = (i1 | i1 << 2) & 0x33333333L;
        i1 = (i1 | i1 << 1) & 0x55555555L;
        long value = i1 << 1 | i0;
        return value;
    }

    public static NodeItem calcExtent(List<? extends Item> items) {
        return items.stream().map(item -> item.nodeItem).reduce(new NodeItem(0L), (nodeItem, nodeItem2) -> nodeItem.expand((NodeItem)nodeItem2));
    }

    public void write(OutputStream outputStream) {
        ByteBuffer buffer = ByteBuffer.allocate((int)((long)NODE_ITEM_LEN * this.numNodes));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (NodeItem nodeItem : this.nodeItems) {
            buffer.putDouble(nodeItem.minX);
            buffer.putDouble(nodeItem.minY);
            buffer.putDouble(nodeItem.maxX);
            buffer.putDouble(nodeItem.maxY);
            buffer.putLong(nodeItem.offset);
        }
        buffer.flip();
        try {
            if (buffer.hasRemaining()) {
                byte[] arr = new byte[buffer.remaining()];
                buffer.get(arr);
                outputStream.write(arr);
                outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.clear();
            buffer = null;
        }
    }

    public static long calcSize(int numItems, int nodeSize) {
        int n;
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        int nodeSizeMin = Math.min(Math.max(nodeSize, 2), 65535);
        if (numItems > 0x1000000) {
            throw new IndexOutOfBoundsException("Number of items must be less than 2^56");
        }
        int numNodes = n = numItems;
        do {
            n = (n + nodeSizeMin - 1) / nodeSizeMin;
            numNodes += n;
        } while (n != 1);
        return numNodes * NODE_ITEM_LEN;
    }

    static ArrayList<Integer> generateLevelEnds(int numItems, int nodeSize) {
        int n;
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        int numNodes = n = numItems;
        ArrayList<Integer> levelNumNodes = new ArrayList<Integer>();
        levelNumNodes.add(n);
        do {
            n = (n + nodeSize - 1) / nodeSize;
            numNodes += n;
            levelNumNodes.add(n);
        } while (n != 1);
        ArrayList<Integer> levelOffsets = new ArrayList<Integer>();
        n = numNodes;
        Iterator iterator = levelNumNodes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            levelOffsets.add(n - size);
            n -= size;
        }
        ArrayList<Integer> levelEnds = new ArrayList<Integer>();
        for (int i = 0; i < levelNumNodes.size(); ++i) {
            levelEnds.add((Integer)levelOffsets.get(i) + (Integer)levelNumNodes.get(i));
        }
        return levelEnds;
    }

    static List<Pair<Integer, Integer>> generateLevelBounds(int numItems, int nodeSize) {
        int n;
        if (nodeSize < 2) {
            throw new RuntimeException("Node size must be at least 2");
        }
        if (numItems == 0) {
            throw new RuntimeException("Number of items must be greater than 0");
        }
        int numNodes = n = numItems;
        ArrayList<Integer> levelNumNodes = new ArrayList<Integer>();
        levelNumNodes.add(n);
        do {
            n = (n + nodeSize - 1) / nodeSize;
            numNodes += n;
            levelNumNodes.add(n);
        } while (n != 1);
        ArrayList<Integer> levelOffsets = new ArrayList<Integer>();
        n = numNodes;
        Iterator iterator = levelNumNodes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            levelOffsets.add(n - size);
            n -= size;
        }
        LinkedList<Pair<Integer, Integer>> levelBounds = new LinkedList<Pair<Integer, Integer>>();
        for (int i = 0; i < levelNumNodes.size(); ++i) {
            levelBounds.add(new Pair<Integer, Integer>((Integer)levelOffsets.get(i), (Integer)levelOffsets.get(i) + (Integer)levelNumNodes.get(i)));
        }
        return levelBounds;
    }

    public static ArrayList<SearchHit> search(ByteBuffer bb, int start, int numItems, int nodeSize, Envelope rect) {
        ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
        double minX = rect.getMinX();
        double minY = rect.getMinY();
        double maxX = rect.getMaxX();
        double maxY = rect.getMaxY();
        ArrayList<Integer> levelEnds = PackedRTree.generateLevelEnds(numItems, nodeSize);
        int numNodes = levelEnds.get(0);
        LinkedList<QueueItem> queue = new LinkedList<QueueItem>();
        queue.add(new QueueItem(0L, levelEnds.size() - 1));
        while (queue.size() != 0) {
            QueueItem stackItem = (QueueItem)queue.pop();
            int nodeIndex = (int)stackItem.nodeIndex;
            int level = stackItem.level;
            boolean isLeafNode = nodeIndex >= numNodes - numItems;
            int levelEnd = levelEnds.get(level);
            int end = Math.min(nodeIndex + nodeSize, levelEnd);
            int nodeStart = start + nodeIndex * NODE_ITEM_LEN;
            for (int pos = nodeIndex; pos < end; ++pos) {
                int offset = nodeStart + (pos - nodeIndex) * NODE_ITEM_LEN;
                double nodeMinX = bb.getDouble(offset + 0);
                double nodeMinY = bb.getDouble(offset + 8);
                double nodeMaxX = bb.getDouble(offset + 16);
                double nodeMaxY = bb.getDouble(offset + 24);
                if (maxX < nodeMinX || maxY < nodeMinY || minX > nodeMaxX || minY > nodeMaxY) continue;
                long indexOffset = bb.getLong(offset + 32);
                if (isLeafNode) {
                    searchHits.add(new SearchHit(indexOffset, pos - 1));
                    continue;
                }
                queue.add(new QueueItem(indexOffset, level - 1));
            }
        }
        return searchHits;
    }

    public static SearchResult search(InputStream stream, int start, int numItems, int nodeSize, Envelope rect) throws IOException {
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        int dataPos = 0;
        SearchResult searchResult = new SearchResult();
        double minX = rect.getMinX();
        double minY = rect.getMinY();
        double maxX = rect.getMaxX();
        double maxY = rect.getMaxY();
        ArrayList<Integer> levelEnds = PackedRTree.generateLevelEnds(numItems, nodeSize);
        int numNodes = levelEnds.get(0);
        LinkedList<QueueItem> queue = new LinkedList<QueueItem>();
        queue.add(new QueueItem(0L, levelEnds.size() - 1));
        while (queue.size() != 0) {
            QueueItem stackItem = (QueueItem)queue.pop();
            int nodeIndex = (int)stackItem.nodeIndex;
            int level = stackItem.level;
            boolean isLeafNode = nodeIndex >= numNodes - numItems;
            int levelBound = levelEnds.get(level);
            int end = Math.min(nodeIndex + nodeSize, levelBound);
            int nodeStart = nodeIndex * NODE_ITEM_LEN;
            int skip = nodeStart - dataPos;
            if (skip > 0) {
                PackedRTree.skipNBytes((InputStream)data, skip);
                dataPos += skip;
            }
            for (int pos = nodeIndex; pos < end; ++pos) {
                int offset = nodeStart + (pos - nodeIndex) * NODE_ITEM_LEN;
                skip = offset - dataPos;
                if (skip > 0) {
                    PackedRTree.skipNBytes((InputStream)data, skip);
                    dataPos += skip;
                }
                double nodeMinX = data.readDouble();
                dataPos += 8;
                if (maxX < nodeMinX) continue;
                double nodeMinY = data.readDouble();
                dataPos += 8;
                if (maxY < nodeMinY) continue;
                double nodeMaxX = data.readDouble();
                dataPos += 8;
                if (minX > nodeMaxX) continue;
                double nodeMaxY = data.readDouble();
                dataPos += 8;
                if (minY > nodeMaxY) continue;
                long indexOffset = data.readLong();
                dataPos += 8;
                if (isLeafNode) {
                    searchResult.hits.add(new SearchHit(indexOffset, pos - 1));
                    continue;
                }
                queue.add(new QueueItem(indexOffset, level - 1));
            }
        }
        searchResult.pos = dataPos;
        return searchResult;
    }

    public static long[] readFeatureOffsets(LittleEndianDataInputStream data, long[] fids, HeaderMeta headerMeta) throws IOException {
        long treeSize = PackedRTree.calcSize((int)headerMeta.featuresCount, headerMeta.indexNodeSize);
        List<Pair<Integer, Integer>> levelBounds = PackedRTree.generateLevelBounds((int)headerMeta.featuresCount, headerMeta.indexNodeSize);
        long bottomLevelOffset = (Integer)levelBounds.get((int)0).first * 40;
        long pos = 0L;
        long[] featureOffsets = new long[fids.length];
        for (int i = 0; i < fids.length; ++i) {
            if (fids[i] > headerMeta.featuresCount - 1L) {
                throw new NoSuchElementException();
            }
            long nodeItemOffset = bottomLevelOffset + fids[i] * 40L;
            long delta = nodeItemOffset + 32L - pos;
            PackedRTree.skipNBytes((InputStream)data, delta);
            long featureOffset = data.readLong();
            pos += delta + 8L;
            featureOffsets[i] = featureOffset;
        }
        long remainingIndexOffset = treeSize - pos;
        PackedRTree.skipNBytes((InputStream)data, remainingIndexOffset);
        return featureOffsets;
    }

    static void skipNBytes(InputStream stream, long skip) throws IOException {
        long actual = 0L;
        for (long remaining = skip; actual < remaining; remaining -= stream.skip(remaining)) {
        }
    }

    public static class Item {
        public NodeItem nodeItem;
    }

    static class Pair<T, U> {
        public T first;
        public U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }
    }

    private static class QueueItem {
        long nodeIndex;
        int level;

        public QueueItem(long nodeIndex, int level) {
            this.nodeIndex = nodeIndex;
            this.level = level;
        }
    }

    public static class SearchHit {
        public long offset;
        public long index;

        public SearchHit(long offset, long index) {
            this.offset = offset;
            this.index = index;
        }
    }

    public static class SearchResult {
        public ArrayList<SearchHit> hits = new ArrayList();
        public int pos;
    }

    public static class FeatureItem
    extends Item {
        public long size;
        public long offset;
    }
}

