/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.CubieCube;
import cs.min2phase.Util;

class CoordCube {
    static final int N_MOVES = 18;
    static final int N_MOVES2 = 10;
    static final int N_SLICE = 495;
    static final int N_TWIST = 2187;
    static final int N_TWIST_SYM = 324;
    static final int N_FLIP = 2048;
    static final int N_FLIP_SYM = 336;
    static final int N_PERM = 40320;
    static final int N_PERM_SYM = 2768;
    static final int N_MPERM = 24;
    static final int N_COMB = 140;
    static final int P2_PARITY_MOVE = 165;
    static char[][] UDSliceMove = new char[495][18];
    static char[][] TwistMove = new char[324][18];
    static char[][] FlipMove = new char[336][18];
    static char[][] UDSliceConj = new char[495][8];
    static int[] UDSliceTwistPrun = new int[20048];
    static int[] UDSliceFlipPrun = new int[20791];
    static int[] TwistFlipPrun = new int[82945];
    static char[][] CPermMove = new char[2768][10];
    static char[][] EPermMove = new char[2768][10];
    static char[][] MPermMove = new char[24][10];
    static char[][] MPermConj = new char[24][16];
    static char[][] CCombPMove;
    static char[][] CCombPConj;
    static int[] MCPermPrun;
    static int[] EPermCCombPPrun;
    static int initLevel;
    int twist;
    int tsym;
    int flip;
    int fsym;
    int slice;
    int prun;
    int twistc;
    int flipc;

    static synchronized void init(boolean fullInit) {
        if (initLevel == 2 || initLevel == 1 && !fullInit) {
            return;
        }
        if (initLevel == 0) {
            CubieCube.initPermSym2Raw();
            CoordCube.initCPermMove();
            CoordCube.initEPermMove();
            CoordCube.initMPermMoveConj();
            CoordCube.initCombPMoveConj();
            CubieCube.initFlipSym2Raw();
            CubieCube.initTwistSym2Raw();
            CoordCube.initFlipMove();
            CoordCube.initTwistMove();
            CoordCube.initUDSliceMoveConj();
        }
        CoordCube.initMCPermPrun(fullInit);
        CoordCube.initPermCombPPrun(fullInit);
        CoordCube.initSliceTwistPrun(fullInit);
        CoordCube.initSliceFlipPrun(fullInit);
        CoordCube.initTwistFlipPrun(fullInit);
        initLevel = fullInit ? 2 : 1;
    }

    static void setPruning(int[] table, int index, int value) {
        int n = index >> 3;
        table[n] = table[n] ^ value << (index << 2);
    }

    static int getPruning(int[] table, int index) {
        return table[index >> 3] >> (index << 2) & 0xF;
    }

    static void initUDSliceMoveConj() {
        int j;
        int i;
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (i = 0; i < 495; ++i) {
            c.setUDSlice(i);
            for (j = 0; j < 18; j += 3) {
                CubieCube.EdgeMult(c, CubieCube.moveCube[j], d);
                CoordCube.UDSliceMove[i][j] = (char)d.getUDSlice();
            }
            for (j = 0; j < 16; j += 2) {
                CubieCube.EdgeConjugate(c, CubieCube.SymMultInv[0][j], d);
                CoordCube.UDSliceConj[i][j >> 1] = (char)d.getUDSlice();
            }
        }
        for (i = 0; i < 495; ++i) {
            for (j = 0; j < 18; j += 3) {
                char udslice = UDSliceMove[i][j];
                for (int k = 1; k < 3; ++k) {
                    udslice = UDSliceMove[udslice][j];
                    CoordCube.UDSliceMove[i][j + k] = udslice;
                }
            }
        }
    }

    static void initFlipMove() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (int i = 0; i < 336; ++i) {
            c.setFlip(CubieCube.FlipS2R[i]);
            for (int j = 0; j < 18; ++j) {
                CubieCube.EdgeMult(c, CubieCube.moveCube[j], d);
                CoordCube.FlipMove[i][j] = (char)d.getFlipSym();
            }
        }
    }

    static void initTwistMove() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (int i = 0; i < 324; ++i) {
            c.setTwist(CubieCube.TwistS2R[i]);
            for (int j = 0; j < 18; ++j) {
                CubieCube.CornMult(c, CubieCube.moveCube[j], d);
                CoordCube.TwistMove[i][j] = (char)d.getTwistSym();
            }
        }
    }

    static void initCPermMove() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (int i = 0; i < 2768; ++i) {
            c.setCPerm(CubieCube.EPermS2R[i]);
            for (int j = 0; j < 10; ++j) {
                CubieCube.CornMult(c, CubieCube.moveCube[Util.ud2std[j]], d);
                CoordCube.CPermMove[i][j] = (char)d.getCPermSym();
            }
        }
    }

    static void initEPermMove() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (int i = 0; i < 2768; ++i) {
            c.setEPerm(CubieCube.EPermS2R[i]);
            for (int j = 0; j < 10; ++j) {
                CubieCube.EdgeMult(c, CubieCube.moveCube[Util.ud2std[j]], d);
                CoordCube.EPermMove[i][j] = (char)d.getEPermSym();
            }
        }
    }

    static void initMPermMoveConj() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        for (int i = 0; i < 24; ++i) {
            int j;
            c.setMPerm(i);
            for (j = 0; j < 10; ++j) {
                CubieCube.EdgeMult(c, CubieCube.moveCube[Util.ud2std[j]], d);
                CoordCube.MPermMove[i][j] = (char)d.getMPerm();
            }
            for (j = 0; j < 16; ++j) {
                CubieCube.EdgeConjugate(c, CubieCube.SymMultInv[0][j], d);
                CoordCube.MPermConj[i][j] = (char)d.getMPerm();
            }
        }
    }

    static void initCombPMoveConj() {
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        CCombPMove = new char[140][10];
        for (int i = 0; i < 140; ++i) {
            int j;
            c.setCComb(i % 70);
            for (j = 0; j < 10; ++j) {
                CubieCube.CornMult(c, CubieCube.moveCube[Util.ud2std[j]], d);
                CoordCube.CCombPMove[i][j] = (char)(d.getCComb() + 70 * (165 >> j & 1 ^ i / 70));
            }
            for (j = 0; j < 16; ++j) {
                CubieCube.CornConjugate(c, CubieCube.SymMultInv[0][j], d);
                CoordCube.CCombPConj[i][j] = (char)(d.getCComb() + 70 * (i / 70));
            }
        }
    }

    static boolean hasZero(int val) {
        return (val - 0x11111111 & ~val & 0x88888888) != 0;
    }

    static void initRawSymPrun(int[] PrunTable, char[][] RawMove, char[][] RawConj, char[][] SymMove, char[] SymState, int PrunFlag, boolean fullInit) {
        int SYM_SHIFT = PrunFlag & 0xF;
        int SYM_E2C_MAGIC = (PrunFlag >> 4 & 1) == 1 ? 0xDDDD00 : 0;
        boolean IS_PHASE2 = (PrunFlag >> 5 & 1) == 1;
        int INV_DEPTH = PrunFlag >> 8 & 0xF;
        int MAX_DEPTH = PrunFlag >> 12 & 0xF;
        int MIN_DEPTH = PrunFlag >> 16 & 0xF;
        int SEARCH_DEPTH = fullInit ? MAX_DEPTH : MIN_DEPTH;
        int SYM_MASK = (1 << SYM_SHIFT) - 1;
        boolean ISTFP = RawMove == null;
        int N_RAW = ISTFP ? 2048 : RawMove.length;
        int N_SIZE = N_RAW * SymMove.length;
        int N_MOVES = IS_PHASE2 ? 10 : 18;
        int NEXT_AXIS_MAGIC = N_MOVES == 10 ? 66 : 599186;
        int depth = CoordCube.getPruning(PrunTable, N_SIZE) - 1;
        int done = 0;
        if (depth == -1) {
            for (int i = 0; i < N_SIZE / 8 + 1; ++i) {
                PrunTable[i] = 0x11111111;
            }
            CoordCube.setPruning(PrunTable, 0, 1);
            depth = 0;
            done = 1;
        }
        while (depth < SEARCH_DEPTH) {
            int mask = ~((depth + 1) * 0x11111111);
            int i = 0;
            while (i < PrunTable.length) {
                int val = PrunTable[i] ^ mask;
                val &= val >> 1;
                int n = i++;
                PrunTable[n] = PrunTable[n] + (val & val >> 2 & 0x11111111);
            }
            boolean inv = depth > INV_DEPTH;
            int select = inv ? depth + 2 : depth;
            int selArrMask = select * 0x11111111;
            int check = inv ? depth : depth + 2;
            int xorVal = ++depth ^ depth + 1;
            int val = 0;
            int i2 = 0;
            while (i2 < N_SIZE) {
                if ((i2 & 7) == 0 && !CoordCube.hasZero((val = PrunTable[i2 >> 3]) ^ selArrMask)) {
                    i2 += 7;
                } else if ((val & 0xF) == select) {
                    int raw = i2 % N_RAW;
                    int sym = i2 / N_RAW;
                    int flip = 0;
                    int fsym = 0;
                    if (ISTFP) {
                        flip = CubieCube.FlipR2S[raw];
                        fsym = flip & 7;
                        flip >>= 3;
                    }
                    for (int m = 0; m < N_MOVES; ++m) {
                        char rawx;
                        int idx;
                        int prun;
                        int symx = SymMove[sym][m];
                        if ((prun = CoordCube.getPruning(PrunTable, idx = (symx >>= SYM_SHIFT) * N_RAW + (rawx = ISTFP ? CubieCube.FlipS2RF[FlipMove[flip][CubieCube.Sym8Move[m << 3 | fsym]] ^ fsym ^ symx & SYM_MASK] : RawConj[RawMove[raw][m]][symx & SYM_MASK]))) != check) {
                            if (prun >= depth - 1) continue;
                            m += NEXT_AXIS_MAGIC >> m & 3;
                            continue;
                        }
                        ++done;
                        if (inv) {
                            CoordCube.setPruning(PrunTable, i2, xorVal);
                            break;
                        }
                        CoordCube.setPruning(PrunTable, idx, xorVal);
                        int j = 1;
                        int symState = SymState[symx];
                        while ((symState >>= 1) != 0) {
                            if ((symState & 1) == 1) {
                                int idxx = symx * N_RAW;
                                idxx = ISTFP ? (idxx += CubieCube.FlipS2RF[CubieCube.FlipR2S[rawx] ^ j]) : (idxx += RawConj[rawx][j ^ SYM_E2C_MAGIC >> (j << 1) & 3]);
                                if (CoordCube.getPruning(PrunTable, idxx) == check) {
                                    CoordCube.setPruning(PrunTable, idxx, xorVal);
                                    ++done;
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i2;
                val >>= 4;
            }
        }
    }

    static void initTwistFlipPrun(boolean fullInit) {
        CoordCube.initRawSymPrun(TwistFlipPrun, null, null, TwistMove, CubieCube.SymStateTwist, 103939, fullInit);
    }

    static void initSliceTwistPrun(boolean fullInit) {
        CoordCube.initRawSymPrun(UDSliceTwistPrun, UDSliceMove, UDSliceConj, TwistMove, CubieCube.SymStateTwist, 431619, fullInit);
    }

    static void initSliceFlipPrun(boolean fullInit) {
        CoordCube.initRawSymPrun(UDSliceFlipPrun, UDSliceMove, UDSliceConj, FlipMove, CubieCube.SymStateFlip, 431619, fullInit);
    }

    static void initMCPermPrun(boolean fullInit) {
        CoordCube.initRawSymPrun(MCPermPrun, MPermMove, MPermConj, CPermMove, CubieCube.SymStatePerm, 584244, fullInit);
    }

    static void initPermCombPPrun(boolean fullInit) {
        CoordCube.initRawSymPrun(EPermCCombPPrun, CCombPMove, CCombPConj, EPermMove, CubieCube.SymStatePerm, 514084, fullInit);
    }

    CoordCube() {
    }

    void set(CoordCube node) {
        this.twist = node.twist;
        this.tsym = node.tsym;
        this.flip = node.flip;
        this.fsym = node.fsym;
        this.slice = node.slice;
        this.prun = node.prun;
        this.twistc = node.twistc;
        this.flipc = node.flipc;
    }

    void calcPruning(boolean isPhase1) {
        this.prun = Math.max(Math.max(CoordCube.getPruning(UDSliceTwistPrun, this.twist * 495 + UDSliceConj[this.slice][this.tsym]), CoordCube.getPruning(UDSliceFlipPrun, this.flip * 495 + UDSliceConj[this.slice][this.fsym])), Math.max(CoordCube.getPruning(TwistFlipPrun, this.twistc >> 3 << 11 | CubieCube.FlipS2RF[this.flipc ^ this.twistc & 7]), CoordCube.getPruning(TwistFlipPrun, this.twist << 11 | CubieCube.FlipS2RF[this.flip << 3 | this.fsym ^ this.tsym])));
    }

    boolean setWithPrun(CubieCube cc, int depth) {
        this.twist = cc.getTwistSym();
        this.flip = cc.getFlipSym();
        this.tsym = this.twist & 7;
        this.twist >>= 3;
        this.prun = CoordCube.getPruning(TwistFlipPrun, this.twist << 11 | CubieCube.FlipS2RF[this.flip ^ this.tsym]);
        if (this.prun > depth) {
            return false;
        }
        this.fsym = this.flip & 7;
        this.flip >>= 3;
        this.slice = cc.getUDSlice();
        this.prun = Math.max(this.prun, Math.max(CoordCube.getPruning(UDSliceTwistPrun, this.twist * 495 + UDSliceConj[this.slice][this.tsym]), CoordCube.getPruning(UDSliceFlipPrun, this.flip * 495 + UDSliceConj[this.slice][this.fsym])));
        if (this.prun > depth) {
            return false;
        }
        CubieCube pc = new CubieCube();
        CubieCube.CornConjugate(cc, 1, pc);
        CubieCube.EdgeConjugate(cc, 1, pc);
        this.twistc = pc.getTwistSym();
        this.flipc = pc.getFlipSym();
        this.prun = Math.max(this.prun, CoordCube.getPruning(TwistFlipPrun, this.twistc >> 3 << 11 | CubieCube.FlipS2RF[this.flipc ^ this.twistc & 7]));
        return this.prun <= depth;
    }

    int doMovePrun(CoordCube cc, int m, boolean isPhase1) {
        this.slice = UDSliceMove[cc.slice][m];
        this.flip = FlipMove[cc.flip][CubieCube.Sym8Move[m << 3 | cc.fsym]];
        this.fsym = this.flip & 7 ^ cc.fsym;
        this.flip >>= 3;
        this.twist = TwistMove[cc.twist][CubieCube.Sym8Move[m << 3 | cc.tsym]];
        this.tsym = this.twist & 7 ^ cc.tsym;
        this.twist >>= 3;
        this.prun = Math.max(Math.max(CoordCube.getPruning(UDSliceTwistPrun, this.twist * 495 + UDSliceConj[this.slice][this.tsym]), CoordCube.getPruning(UDSliceFlipPrun, this.flip * 495 + UDSliceConj[this.slice][this.fsym])), CoordCube.getPruning(TwistFlipPrun, this.twist << 11 | CubieCube.FlipS2RF[this.flip << 3 | this.fsym ^ this.tsym]));
        return this.prun;
    }

    int doMovePrunConj(CoordCube cc, int m) {
        m = CubieCube.SymMove[3][m];
        this.flipc = FlipMove[cc.flipc >> 3][CubieCube.Sym8Move[m << 3 | cc.flipc & 7]] ^ cc.flipc & 7;
        this.twistc = TwistMove[cc.twistc >> 3][CubieCube.Sym8Move[m << 3 | cc.twistc & 7]] ^ cc.twistc & 7;
        return CoordCube.getPruning(TwistFlipPrun, this.twistc >> 3 << 11 | CubieCube.FlipS2RF[this.flipc ^ this.twistc & 7]);
    }

    static {
        CCombPConj = new char[140][16];
        MCPermPrun = new int[8305];
        EPermCCombPPrun = new int[48441];
        initLevel = 0;
    }
}

