/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.Util;
import java.util.Arrays;

public class CubieCube {
    static CubieCube[] CubeSym = new CubieCube[16];
    static CubieCube[] moveCube = new CubieCube[18];
    static long[] moveCubeSym = new long[18];
    static int[] firstMoveSym = new int[48];
    static int[][] SymMult = new int[16][16];
    static int[][] SymMultInv = new int[16][16];
    static int[][] SymMove = new int[16][18];
    static int[] Sym8Move = new int[144];
    static int[][] SymMoveUD = new int[16][18];
    static char[] FlipS2R = new char[336];
    static char[] TwistS2R = new char[324];
    static char[] EPermS2R = new char[2768];
    static byte[] Perm2CombP = new byte[2768];
    static char[] PermInvEdgeSym = new char[2768];
    static byte[] MPermInv = new byte[24];
    static final int SYM_E2C_MAGIC = 0xDDDD00;
    static char[] FlipR2S = new char[2048];
    static char[] TwistR2S = new char[2187];
    static char[] EPermR2S = new char[40320];
    static char[] FlipS2RF = new char[2688];
    static char[] SymStateTwist;
    static char[] SymStateFlip;
    static char[] SymStatePerm;
    static CubieCube urf1;
    static CubieCube urf2;
    static byte[][] urfMove;
    byte[] ca = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    byte[] ea = new byte[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22};
    CubieCube temps = null;

    static int ESym2CSym(int idx) {
        return idx ^ 0xDDDD00 >> ((idx & 0xF) << 1) & 3;
    }

    CubieCube() {
    }

    CubieCube(int cperm, int twist, int eperm, int flip) {
        this.setCPerm(cperm);
        this.setTwist(twist);
        Util.setNPerm(this.ea, eperm, 12, true);
        this.setFlip(flip);
    }

    CubieCube(CubieCube c) {
        this.copy(c);
    }

    void copy(CubieCube c) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.ca[i] = c.ca[i];
        }
        for (i = 0; i < 12; ++i) {
            this.ea[i] = c.ea[i];
        }
    }

    void invCubieCube() {
        if (this.temps == null) {
            this.temps = new CubieCube();
        }
        for (int edge = 0; edge < 12; edge = (int)((byte)(edge + 1))) {
            this.temps.ea[this.ea[edge] >> 1] = (byte)(edge << 1 | this.ea[edge] & 1);
        }
        for (int corn = 0; corn < 8; corn = (int)((byte)(corn + 1))) {
            this.temps.ca[this.ca[corn] & 7] = (byte)(corn | 32 >> (this.ca[corn] >> 3) & 0x18);
        }
        this.copy(this.temps);
    }

    static void CornMult(CubieCube a, CubieCube b, CubieCube prod) {
        for (int corn = 0; corn < 8; ++corn) {
            int oriA = a.ca[b.ca[corn] & 7] >> 3;
            int oriB = b.ca[corn] >> 3;
            prod.ca[corn] = (byte)(a.ca[b.ca[corn] & 7] & 7 | (oriA + oriB) % 3 << 3);
        }
    }

    static void CornMultFull(CubieCube a, CubieCube b, CubieCube prod) {
        for (int corn = 0; corn < 8; ++corn) {
            int oriA = a.ca[b.ca[corn] & 7] >> 3;
            int oriB = b.ca[corn] >> 3;
            int ori = oriA + (oriA < 3 ? oriB : 6 - oriB);
            ori = ori % 3 + (oriA < 3 == oriB < 3 ? 0 : 3);
            prod.ca[corn] = (byte)(a.ca[b.ca[corn] & 7] & 7 | ori << 3);
        }
    }

    static void EdgeMult(CubieCube a, CubieCube b, CubieCube prod) {
        for (int ed = 0; ed < 12; ++ed) {
            prod.ea[ed] = (byte)(a.ea[b.ea[ed] >> 1] ^ b.ea[ed] & 1);
        }
    }

    static void CornConjugate(CubieCube a, int idx, CubieCube b) {
        CubieCube sinv = CubeSym[SymMultInv[0][idx]];
        CubieCube s = CubeSym[idx];
        for (int corn = 0; corn < 8; ++corn) {
            int oriA = sinv.ca[a.ca[s.ca[corn] & 7] & 7] >> 3;
            int oriB = a.ca[s.ca[corn] & 7] >> 3;
            int ori = oriA < 3 ? oriB : (3 - oriB) % 3;
            b.ca[corn] = (byte)(sinv.ca[a.ca[s.ca[corn] & 7] & 7] & 7 | ori << 3);
        }
    }

    static void EdgeConjugate(CubieCube a, int idx, CubieCube b) {
        CubieCube sinv = CubeSym[SymMultInv[0][idx]];
        CubieCube s = CubeSym[idx];
        for (int ed = 0; ed < 12; ++ed) {
            b.ea[ed] = (byte)(sinv.ea[a.ea[s.ea[ed] >> 1] >> 1] ^ a.ea[s.ea[ed] >> 1] & 1 ^ s.ea[ed] & 1);
        }
    }

    static int getPermSymInv(int idx, int sym, boolean isCorner) {
        int idxi = PermInvEdgeSym[idx];
        if (isCorner) {
            idxi = CubieCube.ESym2CSym(idxi);
        }
        return idxi & 0xFFF0 | SymMult[idxi & 0xF][sym];
    }

    static int getSkipMoves(long ssym) {
        int ret = 0;
        int i = 1;
        while ((ssym >>= 1) != 0L) {
            if ((ssym & 1L) == 1L) {
                ret |= firstMoveSym[i];
            }
            ++i;
        }
        return ret;
    }

    void URFConjugate() {
        if (this.temps == null) {
            this.temps = new CubieCube();
        }
        CubieCube.CornMult(urf2, this, this.temps);
        CubieCube.CornMult(this.temps, urf1, this);
        CubieCube.EdgeMult(urf2, this, this.temps);
        CubieCube.EdgeMult(this.temps, urf1, this);
    }

    int getFlip() {
        int idx = 0;
        for (int i = 0; i < 11; ++i) {
            idx = idx << 1 | this.ea[i] & 1;
        }
        return idx;
    }

    void setFlip(int idx) {
        int parity = 0;
        int i = 10;
        while (i >= 0) {
            int val = idx & 1;
            parity ^= val;
            this.ea[i] = (byte)(this.ea[i] & 0xFE | val);
            --i;
            idx >>= 1;
        }
        this.ea[11] = (byte)(this.ea[11] & 0xFE | parity);
    }

    int getFlipSym() {
        return FlipR2S[this.getFlip()];
    }

    int getTwist() {
        int idx = 0;
        for (int i = 0; i < 7; ++i) {
            idx += (idx << 1) + (this.ca[i] >> 3);
        }
        return idx;
    }

    void setTwist(int idx) {
        int twst = 15;
        int i = 6;
        while (i >= 0) {
            int val = idx % 3;
            twst -= val;
            this.ca[i] = (byte)(this.ca[i] & 7 | val << 3);
            --i;
            idx /= 3;
        }
        this.ca[7] = (byte)(this.ca[7] & 7 | twst % 3 << 3);
    }

    int getTwistSym() {
        return TwistR2S[this.getTwist()];
    }

    int getUDSlice() {
        return 494 - Util.getComb(this.ea, 8, true);
    }

    void setUDSlice(int idx) {
        Util.setComb(this.ea, 494 - idx, 8, true);
    }

    int getCPerm() {
        return Util.getNPerm(this.ca, 8, false);
    }

    void setCPerm(int idx) {
        Util.setNPerm(this.ca, idx, 8, false);
    }

    int getCPermSym() {
        return CubieCube.ESym2CSym(EPermR2S[this.getCPerm()]);
    }

    int getEPerm() {
        return Util.getNPerm(this.ea, 8, true);
    }

    void setEPerm(int idx) {
        Util.setNPerm(this.ea, idx, 8, true);
    }

    int getEPermSym() {
        return EPermR2S[this.getEPerm()];
    }

    int getMPerm() {
        return Util.getNPerm(this.ea, 12, true) % 24;
    }

    void setMPerm(int idx) {
        Util.setNPerm(this.ea, idx, 12, true);
    }

    int getCComb() {
        return Util.getComb(this.ca, 0, false);
    }

    void setCComb(int idx) {
        Util.setComb(this.ca, idx, 0, false);
    }

    int verify() {
        int sum = 0;
        int edgeMask = 0;
        for (int e = 0; e < 12; ++e) {
            edgeMask |= 1 << (this.ea[e] >> 1);
            sum ^= this.ea[e] & 1;
        }
        if (edgeMask != 4095) {
            return -2;
        }
        if (sum != 0) {
            return -3;
        }
        int cornMask = 0;
        sum = 0;
        for (int c = 0; c < 8; ++c) {
            cornMask |= 1 << (this.ca[c] & 7);
            sum += this.ca[c] >> 3;
        }
        if (cornMask != 255) {
            return -4;
        }
        if (sum % 3 != 0) {
            return -5;
        }
        if ((this.getEdgeParityBit() ^ this.getCornerParityBit()) != 0) {
            return -6;
        }
        return 0;
    }

    public int getEdgeParityBit() {
        return Util.getNParity(Util.getNPerm(this.ea, 12, true), 12);
    }

    public int getCornerParityBit() {
        return Util.getNParity(this.getCPerm(), 8);
    }

    long selfSymmetry() {
        CubieCube c = new CubieCube(this);
        CubieCube d = new CubieCube();
        long sym = 0L;
        for (int i = 0; i < 96; ++i) {
            CubieCube.CornConjugate(c, SymMultInv[0][i % 16], d);
            if (Arrays.equals(d.ca, this.ca)) {
                CubieCube.EdgeConjugate(c, SymMultInv[0][i % 16], d);
                if (Arrays.equals(d.ea, this.ea)) {
                    sym |= 1L << Math.min(i, 48);
                }
            }
            if (i % 16 == 15) {
                c.URFConjugate();
            }
            if (i % 48 != 47) continue;
            c.invCubieCube();
        }
        return sym;
    }

    static void initMove() {
        CubieCube.moveCube[0] = new CubieCube(15120, 0, 119750400, 0);
        CubieCube.moveCube[3] = new CubieCube(21021, 1494, 323403417, 0);
        CubieCube.moveCube[6] = new CubieCube(8064, 1236, 29441808, 550);
        CubieCube.moveCube[9] = new CubieCube(9, 0, 5880, 0);
        CubieCube.moveCube[12] = new CubieCube(1230, 412, 2949660, 0);
        CubieCube.moveCube[15] = new CubieCube(224, 137, 328552, 137);
        for (int a = 0; a < 18; a += 3) {
            for (int p = 0; p < 2; ++p) {
                CubieCube.moveCube[a + p + 1] = new CubieCube();
                CubieCube.EdgeMult(moveCube[a + p], moveCube[a], moveCube[a + p + 1]);
                CubieCube.CornMult(moveCube[a + p], moveCube[a], moveCube[a + p + 1]);
            }
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < 8; ++i) {
            sb.append("|" + (this.ca[i] & 7) + " " + (this.ca[i] >> 3));
        }
        sb.append("\n");
        for (i = 0; i < 12; ++i) {
            sb.append("|" + (this.ea[i] >> 1) + " " + (this.ea[i] & 1));
        }
        return sb.toString();
    }

    static void initSym() {
        int j;
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        CubieCube f2 = new CubieCube(28783, 0, 259268407, 0);
        CubieCube u4 = new CubieCube(15138, 0, 119765538, 7);
        CubieCube lr2 = new CubieCube(5167, 0, 83473207, 0);
        int i = 0;
        while (i < 8) {
            int n = i++;
            lr2.ca[n] = (byte)(lr2.ca[n] | 0x18);
        }
        for (i = 0; i < 16; ++i) {
            CubieCube.CubeSym[i] = new CubieCube(c);
            CubieCube.CornMultFull(c, u4, d);
            CubieCube.EdgeMult(c, u4, d);
            CubieCube t = d;
            d = c;
            c = t;
            if (i % 4 == 3) {
                CubieCube.CornMultFull(c, lr2, d);
                CubieCube.EdgeMult(c, lr2, d);
                t = d;
                d = c;
                c = t;
            }
            if (i % 8 != 7) continue;
            CubieCube.CornMultFull(c, f2, d);
            CubieCube.EdgeMult(c, f2, d);
            t = d;
            d = c;
            c = t;
        }
        for (i = 0; i < 16; ++i) {
            block3: for (j = 0; j < 16; ++j) {
                CubieCube.CornMultFull(CubeSym[i], CubeSym[j], c);
                for (int k = 0; k < 16; ++k) {
                    if (!Arrays.equals(CubieCube.CubeSym[k].ca, c.ca)) continue;
                    CubieCube.SymMult[i][j] = k;
                    CubieCube.SymMultInv[k][j] = i;
                    continue block3;
                }
            }
        }
        for (int j2 = 0; j2 < 18; ++j2) {
            for (int s = 0; s < 16; ++s) {
                CubieCube.CornConjugate(moveCube[j2], SymMultInv[0][s], c);
                for (int m = 0; m < 18; ++m) {
                    if (!Arrays.equals(CubieCube.moveCube[m].ca, c.ca)) continue;
                    CubieCube.SymMove[s][j2] = m;
                    CubieCube.SymMoveUD[s][Util.std2ud[j2]] = Util.std2ud[m];
                    break;
                }
                if (s % 2 != 0) continue;
                CubieCube.Sym8Move[j2 << 3 | s >> 1] = SymMove[s][j2];
            }
        }
        for (i = 0; i < 18; ++i) {
            CubieCube.moveCubeSym[i] = moveCube[i].selfSymmetry();
            j = i;
            for (int s = 0; s < 48; ++s) {
                if (SymMove[s % 16][j] < i) {
                    int n = s;
                    firstMoveSym[n] = firstMoveSym[n] | 1 << i;
                }
                if (s % 16 != 15) continue;
                j = urfMove[2][j];
            }
        }
    }

    static int initSym2Raw(int N_RAW, char[] Sym2Raw, char[] Raw2Sym, char[] SymState, int coord) {
        int N_RAW_HALF = (N_RAW + 1) / 2;
        CubieCube c = new CubieCube();
        CubieCube d = new CubieCube();
        int count = 0;
        int idx = 0;
        int sym_inc = coord >= 2 ? 1 : 2;
        boolean isEdge = coord != 1;
        for (int i = 0; i < N_RAW; ++i) {
            if (Raw2Sym[i] != '\u0000') continue;
            switch (coord) {
                case 0: {
                    c.setFlip(i);
                    break;
                }
                case 1: {
                    c.setTwist(i);
                    break;
                }
                case 2: {
                    c.setEPerm(i);
                }
            }
            for (int s = 0; s < 16; s += sym_inc) {
                if (isEdge) {
                    CubieCube.EdgeConjugate(c, s, d);
                } else {
                    CubieCube.CornConjugate(c, s, d);
                }
                switch (coord) {
                    case 0: {
                        idx = d.getFlip();
                        break;
                    }
                    case 1: {
                        idx = d.getTwist();
                        break;
                    }
                    case 2: {
                        idx = d.getEPerm();
                    }
                }
                if (coord == 0) {
                    CubieCube.FlipS2RF[count << 3 | s >> 1] = (char)idx;
                }
                if (idx == i) {
                    int n = count;
                    SymState[n] = (char)(SymState[n] | 1 << s / sym_inc);
                }
                int symIdx = (count << 4 | s) / sym_inc;
                Raw2Sym[idx] = (char)symIdx;
            }
            Sym2Raw[count++] = (char)i;
        }
        return count;
    }

    static void initFlipSym2Raw() {
        SymStateFlip = new char[336];
        CubieCube.initSym2Raw(2048, FlipS2R, FlipR2S, SymStateFlip, 0);
    }

    static void initTwistSym2Raw() {
        SymStateTwist = new char[324];
        CubieCube.initSym2Raw(2187, TwistS2R, TwistR2S, SymStateTwist, 1);
    }

    static void initPermSym2Raw() {
        int i;
        SymStatePerm = new char[2768];
        CubieCube.initSym2Raw(40320, EPermS2R, EPermR2S, SymStatePerm, 2);
        CubieCube cc = new CubieCube();
        for (i = 0; i < 2768; ++i) {
            cc.setEPerm(EPermS2R[i]);
            CubieCube.Perm2CombP[i] = (byte)(Util.getComb(cc.ea, 0, true) + Util.getNParity(EPermS2R[i], 8) * 70);
            cc.invCubieCube();
            CubieCube.PermInvEdgeSym[i] = (char)cc.getEPermSym();
        }
        for (i = 0; i < 24; ++i) {
            cc.setMPerm(i);
            cc.invCubieCube();
            CubieCube.MPermInv[i] = (byte)cc.getMPerm();
        }
    }

    static {
        urf1 = new CubieCube(2531, 1373, 67026819, 1367);
        urf2 = new CubieCube(2089, 1906, 322752913, 2040);
        urfMove = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {6, 7, 8, 0, 1, 2, 3, 4, 5, 15, 16, 17, 9, 10, 11, 12, 13, 14}, {3, 4, 5, 6, 7, 8, 0, 1, 2, 12, 13, 14, 15, 16, 17, 9, 10, 11}, {2, 1, 0, 5, 4, 3, 8, 7, 6, 11, 10, 9, 14, 13, 12, 17, 16, 15}, {8, 7, 6, 2, 1, 0, 5, 4, 3, 17, 16, 15, 11, 10, 9, 14, 13, 12}, {5, 4, 3, 8, 7, 6, 2, 1, 0, 14, 13, 12, 17, 16, 15, 11, 10, 9}};
        CubieCube.initMove();
        CubieCube.initSym();
    }
}

