/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.CoordCube;
import cs.min2phase.CubieCube;
import cs.min2phase.Util;

public class Search {
    public static final boolean USE_TWIST_FLIP_PRUN = true;
    static final int MAX_PRE_MOVES = 20;
    static final boolean TRY_INVERSE = true;
    static final boolean TRY_THREE_AXES = true;
    static final boolean USE_COMBP_PRUN = true;
    static final boolean USE_CONJ_PRUN = true;
    protected static int MIN_P1LENGTH_PRE = 7;
    protected static int MAX_DEPTH2 = 12;
    static boolean inited = false;
    protected int[] move = new int[31];
    protected int[] moveSol = new int[31];
    protected CoordCube[] nodeUD = new CoordCube[21];
    protected CoordCube[] nodeRL = new CoordCube[21];
    protected CoordCube[] nodeFB = new CoordCube[21];
    protected long selfSym;
    protected int conjMask;
    protected int urfIdx;
    protected int length1;
    protected int depth1;
    protected int maxDep2;
    protected int sol;
    protected String solution;
    protected long probe;
    protected long probeMax;
    protected long probeMin;
    protected int verbose;
    protected int valid1;
    protected boolean allowShorter = false;
    public CubieCube cc = new CubieCube();
    protected CubieCube[] urfCubieCube = new CubieCube[6];
    protected CoordCube[] urfCoordCube = new CoordCube[6];
    protected CubieCube[] phase1Cubie = new CubieCube[21];
    CubieCube[] preMoveCubes = new CubieCube[21];
    int[] preMoves = new int[20];
    int preMoveLen = 0;
    int maxPreMoves = 0;
    protected boolean isRec = false;
    public static final int USE_SEPARATOR = 1;
    public static final int INVERSE_SOLUTION = 2;
    public static final int APPEND_LENGTH = 4;
    public static final int OPTIMAL_SOLUTION = 8;

    public Search() {
        int i;
        for (i = 0; i < 21; ++i) {
            this.nodeUD[i] = new CoordCube();
            this.nodeRL[i] = new CoordCube();
            this.nodeFB[i] = new CoordCube();
            this.phase1Cubie[i] = new CubieCube();
        }
        for (i = 0; i < 6; ++i) {
            this.urfCubieCube[i] = new CubieCube();
            this.urfCoordCube[i] = new CoordCube();
        }
        for (i = 0; i < 20; ++i) {
            this.preMoveCubes[i + 1] = new CubieCube();
        }
    }

    public synchronized String solution(String facelets, int maxDepth, long probeMax, long probeMin, int verbose) {
        int check = this.verify(facelets);
        if (check != 0) {
            return "Error " + Math.abs(check);
        }
        this.sol = maxDepth + 1;
        this.probe = 0L;
        this.probeMax = probeMax;
        this.probeMin = Math.min(probeMin, probeMax);
        this.verbose = verbose;
        this.solution = null;
        this.isRec = false;
        CoordCube.init(false);
        this.initSearch();
        return (verbose & 8) == 0 ? this.search() : this.searchopt();
    }

    protected void initSearch() {
        this.conjMask = 0;
        this.selfSym = this.cc.selfSymmetry();
        this.conjMask |= (this.selfSym >> 16 & 0xFFFFL) != 0L ? 18 : 0;
        this.conjMask |= (this.selfSym >> 32 & 0xFFFFL) != 0L ? 36 : 0;
        this.conjMask |= (this.selfSym >> 48 & 0xFFFFL) != 0L ? 56 : 0;
        this.selfSym &= 0xFFFFFFFFFFFFL;
        this.maxPreMoves = this.conjMask > 7 ? 0 : 20;
        for (int i = 0; i < 6; ++i) {
            this.urfCubieCube[i].copy(this.cc);
            this.urfCoordCube[i].setWithPrun(this.urfCubieCube[i], 20);
            this.cc.URFConjugate();
            if (i % 3 != 2) continue;
            this.cc.invCubieCube();
        }
    }

    public synchronized String next(long probeMax, long probeMin, int verbose) {
        this.probe = 0L;
        this.probeMax = probeMax;
        this.probeMin = Math.min(probeMin, probeMax);
        this.solution = null;
        this.isRec = (this.verbose & 8) == (verbose & 8);
        this.verbose = verbose;
        return (verbose & 8) == 0 ? this.search() : this.searchopt();
    }

    public static boolean isInited() {
        return inited;
    }

    public long numberOfProbes() {
        return this.probe;
    }

    public int length() {
        return this.sol;
    }

    public static synchronized void init() {
        if (!inited) {
            CoordCube.init(true);
            inited = true;
        }
    }

    public int verify(String facelets) {
        int count = 0;
        byte[] f = new byte[54];
        try {
            String center = new String(new char[]{facelets.charAt(4), facelets.charAt(13), facelets.charAt(22), facelets.charAt(31), facelets.charAt(40), facelets.charAt(49)});
            for (int i = 0; i < 54; ++i) {
                f[i] = (byte)center.indexOf(facelets.charAt(i));
                if (f[i] == -1) {
                    return -1;
                }
                count += 1 << (f[i] << 2);
            }
        }
        catch (Exception e) {
            return -1;
        }
        if (count != 0x999999) {
            return -1;
        }
        Util.toCubieCube(f, this.cc);
        return this.cc.verify();
    }

    protected int phase1PreMoves(int maxl, int lm, CubieCube cc, int ssym) {
        this.preMoveLen = this.maxPreMoves - maxl;
        if (this.isRec ? this.depth1 == this.length1 - this.preMoveLen : this.preMoveLen == 0 || (225207 >> lm & 1) == 0) {
            this.depth1 = this.length1 - this.preMoveLen;
            this.phase1Cubie[0] = cc;
            boolean bl = this.allowShorter = this.depth1 == MIN_P1LENGTH_PRE && this.preMoveLen != 0;
            if (this.nodeUD[this.depth1 + 1].setWithPrun(cc, this.depth1) && this.phase1(this.nodeUD[this.depth1 + 1], ssym, this.depth1, -1) == 0) {
                return 0;
            }
        }
        if (maxl == 0 || this.preMoveLen + MIN_P1LENGTH_PRE >= this.length1) {
            return 1;
        }
        int skipMoves = CubieCube.getSkipMoves(ssym);
        if (maxl == 1 || this.preMoveLen + 1 + MIN_P1LENGTH_PRE >= this.length1) {
            skipMoves |= 0x36FB7;
        }
        lm = lm / 3 * 3;
        for (int m = 0; m < 18; ++m) {
            if (m == lm || m == lm - 9 || m == lm + 9) {
                m += 2;
                continue;
            }
            if (this.isRec && m != this.preMoves[this.maxPreMoves - maxl] || (skipMoves & 1 << m) != 0) continue;
            CubieCube.CornMult(CubieCube.moveCube[m], cc, this.preMoveCubes[maxl]);
            CubieCube.EdgeMult(CubieCube.moveCube[m], cc, this.preMoveCubes[maxl]);
            this.preMoves[this.maxPreMoves - maxl] = m;
            int ret = this.phase1PreMoves(maxl - 1, m, this.preMoveCubes[maxl], ssym & (int)CubieCube.moveCubeSym[m]);
            if (ret != 0) continue;
            return 0;
        }
        return 1;
    }

    protected String search() {
        int n = this.length1 = this.isRec ? this.length1 : 0;
        while (this.length1 < this.sol) {
            this.maxDep2 = Math.min(MAX_DEPTH2, this.sol - this.length1 - 1);
            int n2 = this.urfIdx = this.isRec ? this.urfIdx : 0;
            while (this.urfIdx < 6) {
                if ((this.conjMask & 1 << this.urfIdx) == 0 && this.phase1PreMoves(this.maxPreMoves, -30, this.urfCubieCube[this.urfIdx], (int)(this.selfSym & 0xFFFFL)) == 0) {
                    return this.solution == null ? "Error 8" : this.solution;
                }
                ++this.urfIdx;
            }
            ++this.length1;
        }
        return this.solution == null ? "Error 7" : this.solution;
    }

    protected int initPhase2Pre() {
        this.isRec = false;
        if (this.probe >= (this.solution == null ? this.probeMax : this.probeMin)) {
            return 0;
        }
        ++this.probe;
        for (int i = this.valid1; i < this.depth1; ++i) {
            CubieCube.CornMult(this.phase1Cubie[i], CubieCube.moveCube[this.move[i]], this.phase1Cubie[i + 1]);
            CubieCube.EdgeMult(this.phase1Cubie[i], CubieCube.moveCube[this.move[i]], this.phase1Cubie[i + 1]);
        }
        this.valid1 = this.depth1;
        int p2corn = this.phase1Cubie[this.depth1].getCPermSym();
        int p2csym = p2corn & 0xF;
        int p2edge = this.phase1Cubie[this.depth1].getEPermSym();
        int p2esym = p2edge & 0xF;
        int p2mid = this.phase1Cubie[this.depth1].getMPerm();
        int edgei = CubieCube.getPermSymInv(p2edge >>= 4, p2esym, false);
        int corni = CubieCube.getPermSymInv(p2corn >>= 4, p2csym, true);
        int lastMove = this.depth1 == 0 ? -1 : this.move[this.depth1 - 1];
        int lastPre = this.preMoveLen == 0 ? -1 : this.preMoves[this.preMoveLen - 1];
        int ret = 0;
        int p2switchMax = (this.preMoveLen == 0 ? 1 : 2) * (this.depth1 == 0 ? 1 : 2);
        int p2switchMask = (1 << p2switchMax) - 1;
        for (int p2switch = 0; p2switch < p2switchMax; ++p2switch) {
            int m;
            if ((p2switchMask >> p2switch & 1) != 0) {
                p2switchMask &= ~(1 << p2switch);
                ret = this.initPhase2(p2corn, p2csym, p2edge, p2esym, p2mid, edgei, corni);
                if (ret == 0 || ret > 2) break;
                if (ret == 2) {
                    p2switchMask &= 4 << p2switch;
                }
            }
            if (p2switchMask == 0) break;
            if ((p2switch & 1) == 0 && this.depth1 > 0) {
                m = Util.std2ud[lastMove / 3 * 3 + 1];
                this.move[this.depth1 - 1] = Util.ud2std[m] * 2 - this.move[this.depth1 - 1];
                p2mid = CoordCube.MPermMove[p2mid][m];
                p2corn = CoordCube.CPermMove[p2corn][CubieCube.SymMoveUD[p2csym][m]];
                p2csym = CubieCube.SymMult[p2corn & 0xF][p2csym];
                p2edge = CoordCube.EPermMove[p2edge][CubieCube.SymMoveUD[p2esym][m]];
                p2esym = CubieCube.SymMult[p2edge & 0xF][p2esym];
                corni = CubieCube.getPermSymInv(p2corn >>= 4, p2csym, true);
                edgei = CubieCube.getPermSymInv(p2edge >>= 4, p2esym, false);
                continue;
            }
            if (this.preMoveLen <= 0) continue;
            m = Util.std2ud[lastPre / 3 * 3 + 1];
            this.preMoves[this.preMoveLen - 1] = Util.ud2std[m] * 2 - this.preMoves[this.preMoveLen - 1];
            p2mid = CubieCube.MPermInv[CoordCube.MPermMove[CubieCube.MPermInv[p2mid]][m]];
            p2corn = CoordCube.CPermMove[corni >> 4][CubieCube.SymMoveUD[corni & 0xF][m]];
            corni = p2corn & 0xFFFFFFF0 | CubieCube.SymMult[p2corn & 0xF][corni & 0xF];
            p2corn = CubieCube.getPermSymInv(corni >> 4, corni & 0xF, true);
            p2csym = p2corn & 0xF;
            p2corn >>= 4;
            p2edge = CoordCube.EPermMove[edgei >> 4][CubieCube.SymMoveUD[edgei & 0xF][m]];
            edgei = p2edge & 0xFFFFFFF0 | CubieCube.SymMult[p2edge & 0xF][edgei & 0xF];
            p2edge = CubieCube.getPermSymInv(edgei >> 4, edgei & 0xF, false);
            p2esym = p2edge & 0xF;
            p2edge >>= 4;
        }
        if (this.depth1 > 0) {
            this.move[this.depth1 - 1] = lastMove;
        }
        if (this.preMoveLen > 0) {
            this.preMoves[this.preMoveLen - 1] = lastPre;
        }
        return ret == 0 ? 0 : 2;
    }

    protected int initPhase2(int p2corn, int p2csym, int p2edge, int p2esym, int p2mid, int edgei, int corni) {
        int ret;
        int depth2;
        int prun = Math.max(CoordCube.getPruning(CoordCube.EPermCCombPPrun, (edgei >> 4) * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[corni >> 4] & 0xFF][CubieCube.SymMultInv[edgei & 0xF][corni & 0xF]]), Math.max(CoordCube.getPruning(CoordCube.EPermCCombPPrun, p2edge * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[p2corn] & 0xFF][CubieCube.SymMultInv[p2esym][p2csym]]), CoordCube.getPruning(CoordCube.MCPermPrun, p2corn * 24 + CoordCube.MPermConj[p2mid][p2csym])));
        if (prun > this.maxDep2) {
            return prun - this.maxDep2;
        }
        for (depth2 = this.maxDep2; depth2 >= prun && (ret = this.phase2(p2edge, p2esym, p2corn, p2csym, p2mid, depth2, this.depth1, 10)) >= 0; --depth2) {
            int i;
            depth2 -= ret;
            this.sol = 0;
            for (i = 0; i < this.depth1 + depth2; ++i) {
                this.appendSolMove(this.move[i]);
            }
            for (i = this.preMoveLen - 1; i >= 0; --i) {
                this.appendSolMove(this.preMoves[i]);
            }
            this.solution = this.solutionToString();
        }
        if (depth2 != this.maxDep2) {
            this.maxDep2 = Math.min(MAX_DEPTH2, this.sol - this.length1 - 1);
            return this.probe >= this.probeMin ? 0 : 1;
        }
        return 1;
    }

    protected int phase1(CoordCube node, int ssym, int maxl, int lm) {
        if (node.prun == 0 && maxl < 5) {
            if (this.allowShorter || maxl == 0) {
                this.depth1 -= maxl;
                int ret = this.initPhase2Pre();
                this.depth1 += maxl;
                return ret;
            }
            return 1;
        }
        int skipMoves = CubieCube.getSkipMoves(ssym);
        block0: for (int axis = 0; axis < 18; axis += 3) {
            if (axis == lm || axis == lm - 9) continue;
            for (int power = 0; power < 3; ++power) {
                int m = axis + power;
                if (this.isRec && m != this.move[this.depth1 - maxl] || skipMoves != 0 && (skipMoves & 1 << m) != 0) continue;
                int prun = this.nodeUD[maxl].doMovePrun(node, m, true);
                if (prun > maxl) continue block0;
                if (prun == maxl) continue;
                prun = this.nodeUD[maxl].doMovePrunConj(node, m);
                if (prun > maxl) continue block0;
                if (prun == maxl) continue;
                this.move[this.depth1 - maxl] = m;
                this.valid1 = Math.min(this.valid1, this.depth1 - maxl);
                int ret = this.phase1(this.nodeUD[maxl], ssym & (int)CubieCube.moveCubeSym[m], maxl - 1, axis);
                if (ret == 0) {
                    return 0;
                }
                if (ret >= 2) continue block0;
            }
        }
        return 1;
    }

    protected String searchopt() {
        int maxprun1 = 0;
        int maxprun2 = 0;
        for (int i = 0; i < 6; ++i) {
            this.urfCoordCube[i].calcPruning(false);
            if (i < 3) {
                maxprun1 = Math.max(maxprun1, this.urfCoordCube[i].prun);
                continue;
            }
            maxprun2 = Math.max(maxprun2, this.urfCoordCube[i].prun);
        }
        this.urfIdx = maxprun2 > maxprun1 ? 3 : 0;
        this.phase1Cubie[0] = this.urfCubieCube[this.urfIdx];
        int n = this.length1 = this.isRec ? this.length1 : 0;
        while (this.length1 < this.sol) {
            CoordCube ud = this.urfCoordCube[0 + this.urfIdx];
            CoordCube rl = this.urfCoordCube[1 + this.urfIdx];
            CoordCube fb = this.urfCoordCube[2 + this.urfIdx];
            if (ud.prun <= this.length1 && rl.prun <= this.length1 && fb.prun <= this.length1 && this.phase1opt(ud, rl, fb, this.selfSym, this.length1, -1) == 0) {
                return this.solution == null ? "Error 8" : this.solution;
            }
            ++this.length1;
        }
        return this.solution == null ? "Error 7" : this.solution;
    }

    protected int phase1opt(CoordCube ud, CoordCube rl, CoordCube fb, long ssym, int maxl, int lm) {
        if (ud.prun == 0 && rl.prun == 0 && fb.prun == 0 && maxl < 5) {
            this.maxDep2 = maxl;
            this.depth1 = this.length1 - maxl;
            return this.initPhase2Pre() == 0 ? 0 : 1;
        }
        int skipMoves = CubieCube.getSkipMoves(ssym);
        block0: for (int axis = 0; axis < 18; axis += 3) {
            if (axis == lm || axis == lm - 9) continue;
            for (int power = 0; power < 3; ++power) {
                int m = axis + power;
                if (this.isRec && m != this.move[this.length1 - maxl] || skipMoves != 0 && (skipMoves & 1 << m) != 0) continue;
                int prun_ud = Math.max(this.nodeUD[maxl].doMovePrun(ud, m, false), this.nodeUD[maxl].doMovePrunConj(ud, m));
                if (prun_ud > maxl) continue block0;
                if (prun_ud == maxl) continue;
                int prun_rl = Math.max(this.nodeRL[maxl].doMovePrun(rl, m = CubieCube.urfMove[2][m], false), this.nodeRL[maxl].doMovePrunConj(rl, m));
                if (prun_rl > maxl) continue block0;
                if (prun_rl == maxl) continue;
                m = CubieCube.urfMove[2][m];
                int prun_fb = Math.max(this.nodeFB[maxl].doMovePrun(fb, m, false), this.nodeFB[maxl].doMovePrunConj(fb, m));
                if (prun_ud == prun_rl && prun_rl == prun_fb && prun_fb != 0) {
                    ++prun_fb;
                }
                if (prun_fb > maxl) continue block0;
                if (prun_fb == maxl) continue;
                this.move[this.length1 - maxl] = m = CubieCube.urfMove[2][m];
                this.valid1 = Math.min(this.valid1, this.length1 - maxl);
                int ret = this.phase1opt(this.nodeUD[maxl], this.nodeRL[maxl], this.nodeFB[maxl], ssym & CubieCube.moveCubeSym[m], maxl - 1, axis);
                if (ret != 0) continue;
                return 0;
            }
        }
        return 1;
    }

    void appendSolMove(int curMove) {
        if (this.sol == 0) {
            this.moveSol[this.sol++] = curMove;
            return;
        }
        int axisCur = curMove / 3;
        int axisLast = this.moveSol[this.sol - 1] / 3;
        if (axisCur == axisLast) {
            int pow = (curMove % 3 + this.moveSol[this.sol - 1] % 3 + 1) % 4;
            if (pow == 3) {
                --this.sol;
            } else {
                this.moveSol[this.sol - 1] = axisCur * 3 + pow;
            }
            return;
        }
        if (this.sol > 1 && axisCur % 3 == axisLast % 3 && axisCur == this.moveSol[this.sol - 2] / 3) {
            int pow = (curMove % 3 + this.moveSol[this.sol - 2] % 3 + 1) % 4;
            if (pow == 3) {
                this.moveSol[this.sol - 2] = this.moveSol[this.sol - 1];
                --this.sol;
            } else {
                this.moveSol[this.sol - 2] = axisCur * 3 + pow;
            }
            return;
        }
        this.moveSol[this.sol++] = curMove;
    }

    protected int phase2(int edge, int esym, int corn, int csym, int mid, int maxl, int depth, int lm) {
        if (edge == 0 && corn == 0 && mid == 0) {
            return maxl;
        }
        int moveMask = Util.ckmv2bit[lm];
        for (int m = 0; m < 10; ++m) {
            int corni;
            int esymx;
            int edgei;
            int prun;
            if ((moveMask >> m & 1) != 0) {
                m += 66 >> m & 3;
                continue;
            }
            char midx = CoordCube.MPermMove[mid][m];
            int cornx = CoordCube.CPermMove[corn][CubieCube.SymMoveUD[csym][m]];
            int csymx = CubieCube.SymMult[cornx & 0xF][csym];
            int edgex = CoordCube.EPermMove[edge][CubieCube.SymMoveUD[esym][m]];
            if ((prun = CoordCube.getPruning(CoordCube.EPermCCombPPrun, ((edgei = CubieCube.getPermSymInv(edgex >>= 4, esymx = CubieCube.SymMult[edgex & 0xF][esym], false)) >> 4) * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[(corni = CubieCube.getPermSymInv(cornx >>= 4, csymx, true)) >> 4] & 0xFF][CubieCube.SymMultInv[edgei & 0xF][corni & 0xF]])) > maxl + 1) {
                return maxl - prun + 1;
            }
            if (prun >= maxl) {
                m += 66 >> m & 3 & maxl - prun;
                continue;
            }
            prun = Math.max(CoordCube.getPruning(CoordCube.MCPermPrun, cornx * 24 + CoordCube.MPermConj[midx][csymx]), CoordCube.getPruning(CoordCube.EPermCCombPPrun, edgex * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[cornx] & 0xFF][CubieCube.SymMultInv[esymx][csymx]]));
            if (prun >= maxl) {
                m += 66 >> m & 3 & maxl - prun;
                continue;
            }
            int ret = this.phase2(edgex, esymx, cornx, csymx, midx, maxl - 1, depth + 1, m);
            if (ret < 0) continue;
            this.move[depth] = Util.ud2std[m];
            return ret;
        }
        return -1;
    }

    protected String solutionToString() {
        int urf;
        StringBuffer sb = new StringBuffer();
        int n = urf = (this.verbose & 2) != 0 ? (this.urfIdx + 3) % 6 : this.urfIdx;
        if (urf < 3) {
            for (int s = 0; s < this.sol; ++s) {
                if ((this.verbose & 1) != 0 && s == this.depth1) {
                    sb.append(".  ");
                }
                sb.append(Util.move2str[CubieCube.urfMove[urf][this.moveSol[s]]]).append(' ');
            }
        } else {
            for (int s = this.sol - 1; s >= 0; --s) {
                sb.append(Util.move2str[CubieCube.urfMove[urf][this.moveSol[s]]]).append(' ');
                if ((this.verbose & 1) == 0 || s != this.depth1) continue;
                sb.append(".  ");
            }
        }
        if ((this.verbose & 4) != 0) {
            sb.append("(").append(this.sol).append("f)");
        }
        return sb.toString();
    }
}

