/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.CoordCube;
import cs.min2phase.CubieCube;
import cs.min2phase.Search;
import cs.min2phase.Util;
import java.util.HashMap;

public class SearchWCA
extends Search {
    static String[] move2str = new String[]{"U", "U2", "U'", "R", "R2", "R'", "F", "F2", "F'", "D", "D2", "D'", "L", "L2", "L'", "B", "B2", "B'"};
    static HashMap<String, Integer> str2axis = new HashMap();
    int[] firstMoveFilter;
    int[] lastMoveFilter;
    boolean isAxisRestricted;
    long startTime = 0L;

    @Override
    public synchronized String solution(String facelets, int maxDepth, long probeMax, long probeMin, int verbose) {
        return this.solution(facelets, maxDepth, probeMax, probeMin, verbose, null, null);
    }

    public synchronized String solution(String facelets, int maxDepth, long probeMax, long probeMin, int verbose, String firstAxisRestrictionStr, String lastAxisRestrictionStr) {
        int i;
        this.firstMoveFilter = new int[6];
        this.lastMoveFilter = new int[6];
        this.isAxisRestricted = false;
        if (firstAxisRestrictionStr != null) {
            if (!str2axis.containsKey(firstAxisRestrictionStr)) {
                return "Error 9";
            }
            int firstAxisRestriction = str2axis.get(firstAxisRestrictionStr);
            for (i = 0; i < 3; ++i) {
                int n = i;
                this.firstMoveFilter[n] = this.firstMoveFilter[n] | 3591 << CubieCube.urfMove[(3 - i) % 3][firstAxisRestriction * 3] / 3 * 3;
                int n2 = i + 3;
                this.lastMoveFilter[n2] = this.lastMoveFilter[n2] | 3591 << CubieCube.urfMove[(3 - i) % 3][firstAxisRestriction * 3] / 3 * 3;
            }
            this.isAxisRestricted = true;
        }
        if (lastAxisRestrictionStr != null) {
            if (!str2axis.containsKey(lastAxisRestrictionStr)) {
                return "Error 9";
            }
            int lastAxisRestriction = str2axis.get(lastAxisRestrictionStr);
            for (i = 0; i < 3; ++i) {
                int n = i;
                this.lastMoveFilter[n] = this.lastMoveFilter[n] | 3591 << CubieCube.urfMove[(3 - i) % 3][lastAxisRestriction * 3] / 3 * 3;
                int n3 = i + 3;
                this.firstMoveFilter[n3] = this.firstMoveFilter[n3] | 3591 << CubieCube.urfMove[(3 - i) % 3][lastAxisRestriction * 3] / 3 * 3;
            }
            this.isAxisRestricted = true;
        }
        SearchWCA.init();
        this.startTime = System.currentTimeMillis();
        return super.solution(facelets, maxDepth, probeMax, probeMin, verbose);
    }

    @Override
    protected void initSearch() {
        super.initSearch();
        if (this.isAxisRestricted) {
            this.selfSym = 1L;
            this.conjMask = 0;
            this.maxPreMoves = this.conjMask > 7 ? 0 : 20;
        }
    }

    @Override
    protected int phase1PreMoves(int maxl, int lm, CubieCube cc, int ssym) {
        if (maxl == this.maxPreMoves - 1 && (this.lastMoveFilter[this.urfIdx] >> lm & 1) != 0) {
            return 1;
        }
        return super.phase1PreMoves(maxl, lm, cc, ssym);
    }

    @Override
    protected int phase1(CoordCube node, int ssym, int maxl, int lm) {
        if (maxl == this.depth1 - 1 && (this.firstMoveFilter[this.urfIdx] >> lm & 1) != 0) {
            return 1;
        }
        return super.phase1(node, ssym, maxl, lm);
    }

    @Override
    protected int initPhase2Pre() {
        this.isRec = false;
        if (System.currentTimeMillis() - this.startTime >= (this.solution == null ? this.probeMax : this.probeMin)) {
            return 0;
        }
        this.probe = -1L;
        return super.initPhase2Pre();
    }

    @Override
    protected int phase2(int edge, int esym, int corn, int csym, int mid, int maxl, int depth, int lm) {
        if (this.depth1 == 0 && depth == 1 && (this.firstMoveFilter[this.urfIdx] >> Util.ud2std[lm] & 1) != 0) {
            return -1;
        }
        if (edge == 0 && corn == 0 && mid == 0 && (this.preMoveLen > 0 || (this.lastMoveFilter[this.urfIdx] >> Util.ud2std[lm] & 1) == 0)) {
            return maxl;
        }
        int moveMask = Util.ckmv2bit[lm];
        for (int m = 0; m < 10; ++m) {
            int corni;
            int esymx;
            int edgei;
            int prun;
            if ((moveMask >> m & 1) != 0) {
                m += 66 >> m & 3;
                continue;
            }
            char midx = CoordCube.MPermMove[mid][m];
            int cornx = CoordCube.CPermMove[corn][CubieCube.SymMoveUD[csym][m]];
            int csymx = CubieCube.SymMult[cornx & 0xF][csym];
            int edgex = CoordCube.EPermMove[edge][CubieCube.SymMoveUD[esym][m]];
            if ((prun = CoordCube.getPruning(CoordCube.EPermCCombPPrun, ((edgei = CubieCube.getPermSymInv(edgex >>= 4, esymx = CubieCube.SymMult[edgex & 0xF][esym], false)) >> 4) * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[(corni = CubieCube.getPermSymInv(cornx >>= 4, csymx, true)) >> 4] & 0xFF][CubieCube.SymMultInv[edgei & 0xF][corni & 0xF]])) > maxl + 1) {
                return maxl - prun + 1;
            }
            if (prun >= maxl) {
                m += 66 >> m & 3 & maxl - prun;
                continue;
            }
            prun = Math.max(CoordCube.getPruning(CoordCube.MCPermPrun, cornx * 24 + CoordCube.MPermConj[midx][csymx]), CoordCube.getPruning(CoordCube.EPermCCombPPrun, edgex * 140 + CoordCube.CCombPConj[CubieCube.Perm2CombP[cornx] & 0xFF][CubieCube.SymMultInv[esymx][csymx]]));
            if (prun >= maxl) {
                m += 66 >> m & 3 & maxl - prun;
                continue;
            }
            int ret = this.phase2(edgex, esymx, cornx, csymx, midx, maxl - 1, depth + 1, m);
            if (ret < 0) continue;
            this.move[depth] = Util.ud2std[m];
            return ret;
        }
        return -1;
    }

    @Override
    protected String solutionToString() {
        int urf;
        StringBuffer sb = new StringBuffer();
        int n = urf = (this.verbose & 2) != 0 ? (this.urfIdx + 3) % 6 : this.urfIdx;
        if (urf < 3) {
            for (int s = 0; s < this.sol; ++s) {
                if ((this.verbose & 1) != 0 && s == this.depth1) {
                    sb.append(".");
                }
                sb.append(move2str[CubieCube.urfMove[urf][this.moveSol[s]]]).append(' ');
            }
        } else {
            for (int s = this.sol - 1; s >= 0; --s) {
                sb.append(move2str[CubieCube.urfMove[urf][this.moveSol[s]]]).append(' ');
                if ((this.verbose & 1) == 0 || s != this.depth1) continue;
                sb.append(".");
            }
        }
        if ((this.verbose & 4) != 0) {
            sb.append("(").append(this.sol).append("f)");
        }
        return sb.toString();
    }

    static {
        for (int i = 0; i < move2str.length; ++i) {
            str2axis.put(move2str[i], i / 3 % 3);
        }
    }
}

