/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.CubieCube;
import cs.min2phase.Search;
import cs.min2phase.Util;
import java.util.Random;

public class Tools {
    private static Random gen = new Random();
    protected static final byte[] STATE_RANDOM = null;
    protected static final byte[] STATE_SOLVED = new byte[0];

    protected Tools() {
    }

    public static void setRandomSource(Random gen) {
        Tools.gen = gen;
    }

    public static String randomCube() {
        return Tools.randomState(STATE_RANDOM, STATE_RANDOM, STATE_RANDOM, STATE_RANDOM, gen);
    }

    public static String randomCube(Random gen) {
        return Tools.randomState(STATE_RANDOM, STATE_RANDOM, STATE_RANDOM, STATE_RANDOM, gen);
    }

    private static int resolveOri(byte[] arr, int base) {
        int i;
        int sum = 0;
        int idx = 0;
        int lastUnknown = -1;
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] == -1) {
                arr[i] = (byte)gen.nextInt(base);
                lastUnknown = i;
            }
            sum += arr[i];
        }
        if (sum % base != 0 && lastUnknown != -1) {
            arr[lastUnknown] = (byte)((30 + arr[lastUnknown] - sum) % base);
        }
        for (i = 0; i < arr.length - 1; ++i) {
            idx *= base;
            idx += arr[i];
        }
        return idx;
    }

    private static int countUnknown(byte[] arr) {
        if (arr == STATE_SOLVED) {
            return 0;
        }
        int cnt = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != -1) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int resolvePerm(byte[] arr, int cntU, int parity) {
        byte temp;
        if (arr == STATE_SOLVED) {
            return 0;
        }
        if (arr == STATE_RANDOM) {
            return parity == -1 ? gen.nextInt(2) : parity;
        }
        byte[] val = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == -1) continue;
            val[arr[i]] = -1;
        }
        int idx = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (val[i] == -1) continue;
            int j = gen.nextInt(idx + 1);
            temp = val[i];
            val[idx++] = val[j];
            val[j] = temp;
        }
        int last = -1;
        for (idx = 0; idx < arr.length && cntU > 0; ++idx) {
            if (arr[idx] != -1) continue;
            if (cntU == 2) {
                last = idx;
            }
            arr[idx] = val[--cntU];
        }
        int p = Util.getNParity(Tools.getNPerm(arr, arr.length), arr.length);
        if (p == 1 - parity && last != -1) {
            temp = arr[idx - 1];
            arr[idx - 1] = arr[last];
            arr[last] = temp;
        }
        return p;
    }

    static int getNPerm(byte[] arr, int n) {
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            idx *= n - i;
            for (int j = i + 1; j < n; ++j) {
                if (arr[j] >= arr[i]) continue;
                ++idx;
            }
        }
        return idx;
    }

    protected static String randomState(byte[] cp, byte[] co, byte[] ep, byte[] eo, Random gen) {
        int cpVal;
        int epVal;
        int cntUC;
        int cntUE = ep == STATE_RANDOM ? 12 : Tools.countUnknown(ep);
        int n = cntUC = cp == STATE_RANDOM ? 8 : Tools.countUnknown(cp);
        if (cntUE < 2) {
            int parity;
            if (ep == STATE_SOLVED) {
                parity = 0;
                epVal = 0;
            } else {
                parity = Tools.resolvePerm(ep, cntUE, -1);
                epVal = Tools.getNPerm(ep, 12);
            }
            if (cp == STATE_SOLVED) {
                cpVal = 0;
            } else if (cp == STATE_RANDOM) {
                while (Util.getNParity(cpVal = gen.nextInt(40320), 8) != parity) {
                }
            } else {
                Tools.resolvePerm(cp, cntUC, parity);
                cpVal = Tools.getNPerm(cp, 8);
            }
        } else {
            int parity;
            if (cp == STATE_SOLVED) {
                parity = 0;
                cpVal = 0;
            } else if (cp == STATE_RANDOM) {
                cpVal = gen.nextInt(40320);
                parity = Util.getNParity(cpVal, 8);
            } else {
                parity = Tools.resolvePerm(cp, cntUC, -1);
                cpVal = Tools.getNPerm(cp, 8);
            }
            if (ep == STATE_RANDOM) {
                while (Util.getNParity(epVal = gen.nextInt(479001600), 12) != parity) {
                }
            } else {
                Tools.resolvePerm(ep, cntUE, parity);
                epVal = Tools.getNPerm(ep, 12);
            }
        }
        return Util.toFaceCube(new CubieCube(cpVal, co == STATE_RANDOM ? gen.nextInt(2187) : (co == STATE_SOLVED ? 0 : Tools.resolveOri(co, 3)), epVal, eo == STATE_RANDOM ? gen.nextInt(2048) : (eo == STATE_SOLVED ? 0 : Tools.resolveOri(eo, 2))));
    }

    public static String randomLastLayer() {
        return Tools.randomState(new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, 8, 9, 10, 11}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0}, gen);
    }

    public static String randomLastSlot() {
        return Tools.randomState(new byte[]{-1, -1, -1, -1, -1, 5, 6, 7}, new byte[]{-1, -1, -1, -1, -1, 0, 0, 0}, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, -1, 9, 10, 11}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0}, gen);
    }

    public static String randomZBLastLayer() {
        return Tools.randomState(new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, 8, 9, 10, 11}, STATE_SOLVED, gen);
    }

    public static String randomCornerOfLastLayer() {
        return Tools.randomState(new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0}, STATE_SOLVED, STATE_SOLVED, gen);
    }

    public static String randomEdgeOfLastLayer() {
        return Tools.randomState(STATE_SOLVED, STATE_SOLVED, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, 8, 9, 10, 11}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0}, gen);
    }

    public static String randomCrossSolved() {
        return Tools.randomState(STATE_RANDOM, STATE_RANDOM, new byte[]{-1, -1, -1, -1, 4, 5, 6, 7, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1}, gen);
    }

    public static String randomEdgeSolved() {
        return Tools.randomState(STATE_RANDOM, STATE_RANDOM, STATE_SOLVED, STATE_SOLVED, gen);
    }

    public static String randomCornerSolved() {
        return Tools.randomState(STATE_SOLVED, STATE_SOLVED, STATE_RANDOM, STATE_RANDOM, gen);
    }

    public static String superFlip() {
        return Util.toFaceCube(new CubieCube(0, 0, 0, 2047));
    }

    public static String fromScramble(int[] scramble) {
        CubieCube c1 = new CubieCube();
        CubieCube c2 = new CubieCube();
        for (int i = 0; i < scramble.length; ++i) {
            CubieCube.CornMult(c1, CubieCube.moveCube[scramble[i]], c2);
            CubieCube.EdgeMult(c1, CubieCube.moveCube[scramble[i]], c2);
            CubieCube tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        return Util.toFaceCube(c1);
    }

    public static String fromScramble(String s) {
        int[] arr = new int[s.length()];
        int j = 0;
        int axis = -1;
        int length = s.length();
        block11: for (int i = 0; i < length; ++i) {
            switch (s.charAt(i)) {
                case 'U': {
                    axis = 0;
                    continue block11;
                }
                case 'R': {
                    axis = 3;
                    continue block11;
                }
                case 'F': {
                    axis = 6;
                    continue block11;
                }
                case 'D': {
                    axis = 9;
                    continue block11;
                }
                case 'L': {
                    axis = 12;
                    continue block11;
                }
                case 'B': {
                    axis = 15;
                    continue block11;
                }
                case ' ': {
                    if (axis != -1) {
                        arr[j++] = axis;
                    }
                    axis = -1;
                    continue block11;
                }
                case '2': {
                    ++axis;
                    continue block11;
                }
                case '\'': {
                    axis += 2;
                    continue block11;
                }
            }
        }
        if (axis != -1) {
            arr[j++] = axis;
        }
        int[] ret = new int[j];
        while (--j >= 0) {
            ret[j] = arr[j];
        }
        return Tools.fromScramble(ret);
    }

    public static int verify(String facelets) {
        return new Search().verify(facelets);
    }
}

