/*
 * Decompiled with CFR 0.152.
 */
package cs.min2phase;

import cs.min2phase.CubieCube;

class Util {
    static final byte Ux1 = 0;
    static final byte Ux2 = 1;
    static final byte Ux3 = 2;
    static final byte Rx1 = 3;
    static final byte Rx2 = 4;
    static final byte Rx3 = 5;
    static final byte Fx1 = 6;
    static final byte Fx2 = 7;
    static final byte Fx3 = 8;
    static final byte Dx1 = 9;
    static final byte Dx2 = 10;
    static final byte Dx3 = 11;
    static final byte Lx1 = 12;
    static final byte Lx2 = 13;
    static final byte Lx3 = 14;
    static final byte Bx1 = 15;
    static final byte Bx2 = 16;
    static final byte Bx3 = 17;
    static final byte U1 = 0;
    static final byte U2 = 1;
    static final byte U3 = 2;
    static final byte U4 = 3;
    static final byte U5 = 4;
    static final byte U6 = 5;
    static final byte U7 = 6;
    static final byte U8 = 7;
    static final byte U9 = 8;
    static final byte R1 = 9;
    static final byte R2 = 10;
    static final byte R3 = 11;
    static final byte R4 = 12;
    static final byte R5 = 13;
    static final byte R6 = 14;
    static final byte R7 = 15;
    static final byte R8 = 16;
    static final byte R9 = 17;
    static final byte F1 = 18;
    static final byte F2 = 19;
    static final byte F3 = 20;
    static final byte F4 = 21;
    static final byte F5 = 22;
    static final byte F6 = 23;
    static final byte F7 = 24;
    static final byte F8 = 25;
    static final byte F9 = 26;
    static final byte D1 = 27;
    static final byte D2 = 28;
    static final byte D3 = 29;
    static final byte D4 = 30;
    static final byte D5 = 31;
    static final byte D6 = 32;
    static final byte D7 = 33;
    static final byte D8 = 34;
    static final byte D9 = 35;
    static final byte L1 = 36;
    static final byte L2 = 37;
    static final byte L3 = 38;
    static final byte L4 = 39;
    static final byte L5 = 40;
    static final byte L6 = 41;
    static final byte L7 = 42;
    static final byte L8 = 43;
    static final byte L9 = 44;
    static final byte B1 = 45;
    static final byte B2 = 46;
    static final byte B3 = 47;
    static final byte B4 = 48;
    static final byte B5 = 49;
    static final byte B6 = 50;
    static final byte B7 = 51;
    static final byte B8 = 52;
    static final byte B9 = 53;
    static final byte U = 0;
    static final byte R = 1;
    static final byte F = 2;
    static final byte D = 3;
    static final byte L = 4;
    static final byte B = 5;
    static final byte[][] cornerFacelet;
    static final byte[][] edgeFacelet;
    static int[][] Cnk;
    static String[] move2str;
    static int[] ud2std;
    static int[] std2ud;
    static int[] ckmv2bit;

    Util() {
    }

    static void toCubieCube(byte[] f, CubieCube ccRet) {
        int j;
        int i;
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            ccRet.ca[i2] = 0;
        }
        for (i2 = 0; i2 < 12; ++i2) {
            ccRet.ea[i2] = 0;
        }
        block2: for (i = 0; i < 8; i = (int)((byte)(i + 1))) {
            int ori;
            for (ori = 0; ori < 3 && f[cornerFacelet[i][ori]] != 0 && f[cornerFacelet[i][ori]] != 3; ori = (int)((byte)(ori + 1))) {
            }
            byte col1 = f[cornerFacelet[i][(ori + 1) % 3]];
            byte col2 = f[cornerFacelet[i][(ori + 2) % 3]];
            for (j = 0; j < 8; j = (int)((byte)(j + 1))) {
                if (col1 != cornerFacelet[j][1] / 9 || col2 != cornerFacelet[j][2] / 9) continue;
                ccRet.ca[i] = (byte)(ori % 3 << 3 | j);
                continue block2;
            }
        }
        block5: for (i = 0; i < 12; i = (int)((byte)(i + 1))) {
            for (j = 0; j < 12; j = (int)((byte)(j + 1))) {
                if (f[edgeFacelet[i][0]] == edgeFacelet[j][0] / 9 && f[edgeFacelet[i][1]] == edgeFacelet[j][1] / 9) {
                    ccRet.ea[i] = (byte)(j << 1);
                    continue block5;
                }
                if (f[edgeFacelet[i][0]] != edgeFacelet[j][1] / 9 || f[edgeFacelet[i][1]] != edgeFacelet[j][0] / 9) continue;
                ccRet.ea[i] = (byte)(j << 1 | 1);
                continue block5;
            }
        }
    }

    static String toFaceCube(CubieCube cc) {
        int n;
        int ori;
        int j;
        char[] f = new char[54];
        char[] ts = new char[]{'U', 'R', 'F', 'D', 'L', 'B'};
        for (int i = 0; i < 54; ++i) {
            f[i] = ts[i / 9];
        }
        for (int c = 0; c < 8; c = (int)((byte)(c + 1))) {
            j = cc.ca[c] & 7;
            ori = cc.ca[c] >> 3;
            for (n = 0; n < 3; n = (int)((byte)(n + 1))) {
                f[Util.cornerFacelet[c][(n + ori) % 3]] = ts[cornerFacelet[j][n] / 9];
            }
        }
        for (int e = 0; e < 12; e = (int)((byte)(e + 1))) {
            j = cc.ea[e] >> 1;
            ori = cc.ea[e] & 1;
            for (n = 0; n < 2; n = (int)((byte)(n + 1))) {
                f[Util.edgeFacelet[e][(n + ori) % 2]] = ts[edgeFacelet[j][n] / 9];
            }
        }
        return new String(f);
    }

    static int getNParity(int idx, int n) {
        int p = 0;
        for (int i = n - 2; i >= 0; --i) {
            p ^= idx % (n - i);
            idx /= n - i;
        }
        return p & 1;
    }

    static byte setVal(int val0, int val, boolean isEdge) {
        return (byte)(isEdge ? val << 1 | val0 & 1 : val | val0 & 0xF8);
    }

    static int getVal(int val0, boolean isEdge) {
        return isEdge ? val0 >> 1 : val0 & 7;
    }

    static void setNPerm(byte[] arr, int idx, int n, boolean isEdge) {
        long val = -81985529216486896L;
        long extract = 0L;
        for (int p = 2; p <= n; ++p) {
            extract = extract << 4 | (long)(idx % p);
            idx /= p;
        }
        for (int i = 0; i < n - 1; ++i) {
            int v = ((int)extract & 0xF) << 2;
            extract >>= 4;
            arr[i] = Util.setVal(arr[i], (int)(val >> v & 0xFL), isEdge);
            long m = (1L << v) - 1L;
            val = val & m | val >> 4 & (m ^ 0xFFFFFFFFFFFFFFFFL);
        }
        arr[n - 1] = Util.setVal(arr[n - 1], (int)(val & 0xFL), isEdge);
    }

    static int getNPerm(byte[] arr, int n, boolean isEdge) {
        int idx = 0;
        long val = -81985529216486896L;
        for (int i = 0; i < n - 1; ++i) {
            int v = Util.getVal(arr[i], isEdge) << 2;
            idx = (n - i) * idx + (int)(val >> v & 0xFL);
            val -= 0x1111111111111110L << v;
        }
        return idx;
    }

    static int getComb(byte[] arr, int mask, boolean isEdge) {
        int end = arr.length - 1;
        int idxC = 0;
        int r = 4;
        for (int i = end; i >= 0; --i) {
            int perm = Util.getVal(arr[i], isEdge);
            if ((perm & 0xC) != mask) continue;
            idxC += Cnk[i][r--];
        }
        return idxC;
    }

    static void setComb(byte[] arr, int idxC, int mask, boolean isEdge) {
        int end = arr.length - 1;
        int r = 4;
        int fill = end;
        for (int i = end; i >= 0; --i) {
            if (idxC >= Cnk[i][r]) {
                idxC -= Cnk[i][r--];
                arr[i] = Util.setVal(arr[i], r | mask, isEdge);
                continue;
            }
            if ((fill & 0xC) == mask) {
                fill -= 4;
            }
            arr[i] = Util.setVal(arr[i], fill--, isEdge);
        }
    }

    static {
        int i;
        cornerFacelet = new byte[][]{{8, 9, 20}, {6, 18, 38}, {0, 36, 47}, {2, 45, 11}, {29, 26, 15}, {27, 44, 24}, {33, 53, 42}, {35, 17, 51}};
        edgeFacelet = new byte[][]{{5, 10}, {7, 19}, {3, 37}, {1, 46}, {32, 16}, {28, 25}, {30, 43}, {34, 52}, {23, 12}, {21, 41}, {50, 39}, {48, 14}};
        Cnk = new int[13][13];
        move2str = new String[]{"U ", "U2", "U'", "R ", "R2", "R'", "F ", "F2", "F'", "D ", "D2", "D'", "L ", "L2", "L'", "B ", "B2", "B'"};
        ud2std = new int[]{0, 1, 2, 4, 7, 9, 10, 11, 13, 16, 3, 5, 6, 8, 12, 14, 15, 17};
        std2ud = new int[18];
        ckmv2bit = new int[11];
        for (i = 0; i < 18; ++i) {
            Util.std2ud[Util.ud2std[i]] = i;
        }
        for (i = 0; i < 10; ++i) {
            int ix = ud2std[i] / 3;
            Util.ckmv2bit[i] = 0;
            for (int j = 0; j < 10; ++j) {
                int jx = ud2std[j] / 3;
                int n = i;
                ckmv2bit[n] = ckmv2bit[n] | (ix == jx || ix % 3 == jx % 3 && ix >= jx ? 1 : 0) << j;
            }
        }
        Util.ckmv2bit[10] = 0;
        for (i = 0; i < 13; ++i) {
            Util.Cnk[i][i] = 1;
            Util.Cnk[i][0] = 1;
            for (int j = 1; j < i; ++j) {
                Util.Cnk[i][j] = Cnk[i - 1][j - 1] + Cnk[i - 1][j];
            }
        }
    }
}

