/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.CenterCube;
import cs.threephase.FullCube;
import cs.threephase.Util;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Center1 {
    private static Logger logger = LoggerFactory.getLogger(Center1.class);
    static int[][] ctsmv = new int[15582][36];
    static int[] sym2raw = new int[15582];
    static byte[] csprun = new byte[15582];
    static int[][] symmult = new int[48][48];
    static int[][] symmove = new int[48][36];
    static int[] syminv = new int[48];
    static int[] finish = new int[48];
    static int[] raw2sym;
    byte[] ct = new byte[24];
    static String[] rot2str;

    static void initSym2Raw() {
        Center1 c = new Center1();
        int[] occ = new int[22984];
        int count = 0;
        for (int i = 0; i < 735471; ++i) {
            if ((occ[i >>> 5] & 1 << (i & 0x1F)) != 0) continue;
            c.set(i);
            for (int j = 0; j < 48; ++j) {
                int idx = c.get();
                int n = idx >>> 5;
                occ[n] = occ[n] | 1 << (idx & 0x1F);
                if (raw2sym != null) {
                    Center1.raw2sym[idx] = count << 6 | syminv[j];
                }
                c.rot(0);
                if (j % 2 == 1) {
                    c.rot(1);
                }
                if (j % 8 == 7) {
                    c.rot(2);
                }
                if (j % 16 != 15) continue;
                c.rot(3);
            }
            Center1.sym2raw[count++] = i;
        }
        assert (count == 15582);
    }

    static void createPrun() {
        Arrays.fill(csprun, (byte)-1);
        Center1.csprun[0] = 0;
        byte depth = 0;
        int done = 1;
        while (done != 15582) {
            boolean inv = depth > 4;
            byte select = inv ? (byte)-1 : depth;
            byte check = inv ? depth : (byte)-1;
            ++depth;
            block1: for (int i = 0; i < 15582; ++i) {
                if (csprun[i] != select) continue;
                for (int m = 0; m < 27; ++m) {
                    int idx = ctsmv[i][m] >>> 6;
                    if (csprun[idx] != check) continue;
                    ++done;
                    if (inv) {
                        Center1.csprun[i] = depth;
                        continue block1;
                    }
                    Center1.csprun[idx] = depth;
                }
            }
        }
    }

    static void createMoveTable() {
        logger.info("Create Phase1 Center Move Table...");
        Center1 c = new Center1();
        Center1 d = new Center1();
        for (int i = 0; i < 15582; ++i) {
            d.set(sym2raw[i]);
            for (int m = 0; m < 36; ++m) {
                c.set(d);
                c.move(m);
                Center1.ctsmv[i][m] = c.getsym();
            }
        }
    }

    Center1() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.ct[i] = 1;
        }
        for (i = 8; i < 24; ++i) {
            this.ct[i] = 0;
        }
    }

    Center1(byte[] ct) {
        for (int i = 0; i < 24; ++i) {
            this.ct[i] = ct[i];
        }
    }

    Center1(CenterCube c, int urf) {
        for (int i = 0; i < 24; ++i) {
            this.ct[i] = (byte)(c.ct[i] % 3 == urf ? 1 : 0);
        }
    }

    void move(int m) {
        int key = m % 3;
        switch (m /= 3) {
            case 0: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                break;
            }
            case 1: {
                Util.swap(this.ct, 16, 17, 18, 19, key);
                break;
            }
            case 2: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                break;
            }
            case 3: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                break;
            }
            case 4: {
                Util.swap(this.ct, 20, 21, 22, 23, key);
                break;
            }
            case 5: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                break;
            }
            case 6: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                Util.swap(this.ct, 8, 20, 12, 16, key);
                Util.swap(this.ct, 9, 21, 13, 17, key);
                break;
            }
            case 7: {
                Util.swap(this.ct, 16, 17, 18, 19, key);
                Util.swap(this.ct, 1, 15, 5, 9, key);
                Util.swap(this.ct, 2, 12, 6, 10, key);
                break;
            }
            case 8: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                Util.swap(this.ct, 2, 19, 4, 21, key);
                Util.swap(this.ct, 3, 16, 5, 22, key);
                break;
            }
            case 9: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                Util.swap(this.ct, 10, 18, 14, 22, key);
                Util.swap(this.ct, 11, 19, 15, 23, key);
                break;
            }
            case 10: {
                Util.swap(this.ct, 20, 21, 22, 23, key);
                Util.swap(this.ct, 0, 8, 4, 14, key);
                Util.swap(this.ct, 3, 11, 7, 13, key);
                break;
            }
            case 11: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                Util.swap(this.ct, 1, 20, 7, 18, key);
                Util.swap(this.ct, 0, 23, 6, 17, key);
            }
        }
    }

    void set(int idx) {
        int r = 8;
        for (int i = 23; i >= 0; --i) {
            this.ct[i] = 0;
            if (idx < Util.Cnk[i][r]) continue;
            idx -= Util.Cnk[i][r--];
            this.ct[i] = 1;
        }
    }

    int get() {
        int idx = 0;
        int r = 8;
        for (int i = 23; i >= 0; --i) {
            if (this.ct[i] != 1) continue;
            idx += Util.Cnk[i][r--];
        }
        return idx;
    }

    int getsym() {
        if (raw2sym != null) {
            return raw2sym[this.get()];
        }
        for (int j = 0; j < 48; ++j) {
            int cord = Center1.raw2sym(this.get());
            if (cord != -1) {
                return cord * 64 + j;
            }
            this.rot(0);
            if (j % 2 == 1) {
                this.rot(1);
            }
            if (j % 8 == 7) {
                this.rot(2);
            }
            if (j % 16 != 15) continue;
            this.rot(3);
        }
        System.out.print('e');
        return -1;
    }

    static int raw2sym(int n) {
        int m = Arrays.binarySearch(sym2raw, n);
        return m >= 0 ? m : -1;
    }

    void set(Center1 c) {
        for (int i = 0; i < 24; ++i) {
            this.ct[i] = c.ct[i];
        }
    }

    void rot(int r) {
        switch (r) {
            case 0: {
                this.move(19);
                this.move(28);
                break;
            }
            case 1: {
                this.move(21);
                this.move(32);
                break;
            }
            case 2: {
                Util.swap(this.ct, 0, 3, 1, 2, 1);
                Util.swap(this.ct, 8, 11, 9, 10, 1);
                Util.swap(this.ct, 4, 7, 5, 6, 1);
                Util.swap(this.ct, 12, 15, 13, 14, 1);
                Util.swap(this.ct, 16, 19, 21, 22, 1);
                Util.swap(this.ct, 17, 18, 20, 23, 1);
                break;
            }
            case 3: {
                this.move(18);
                this.move(29);
                this.move(24);
                this.move(35);
            }
        }
    }

    void rotate(int r) {
        for (int j = 0; j < r; ++j) {
            this.rot(0);
            if (j % 2 == 1) {
                this.rot(1);
            }
            if (j % 8 == 7) {
                this.rot(2);
            }
            if (j % 16 != 15) continue;
            this.rot(3);
        }
    }

    static int getSolvedSym(CenterCube cube) {
        Center1 c = new Center1(cube.ct);
        for (int j = 0; j < 48; ++j) {
            boolean check = true;
            for (int i = 0; i < 24; ++i) {
                if (c.ct[i] == FullCube.centerFacelet[i] / 16) continue;
                check = false;
                break;
            }
            if (check) {
                return j;
            }
            c.rot(0);
            if (j % 2 == 1) {
                c.rot(1);
            }
            if (j % 8 == 7) {
                c.rot(2);
            }
            if (j % 16 != 15) continue;
            c.rot(3);
        }
        return -1;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Center1) {
            Center1 c = (Center1)obj;
            for (int i = 0; i < 24; ++i) {
                if (this.ct[i] == c.ct[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void initSym() {
        int k;
        int j;
        int i;
        Center1 c = new Center1();
        for (int i2 = 0; i2 < 24; i2 = (int)((byte)(i2 + 1))) {
            c.ct[i2] = i2;
        }
        Center1 d = new Center1(c.ct);
        Center1 e = new Center1(c.ct);
        Center1 f = new Center1(c.ct);
        for (i = 0; i < 48; ++i) {
            for (j = 0; j < 48; ++j) {
                for (k = 0; k < 48; ++k) {
                    if (c.equals(d)) {
                        Center1.symmult[i][j] = k;
                        if (k == 0) {
                            Center1.syminv[i] = j;
                        }
                    }
                    d.rot(0);
                    if (k % 2 == 1) {
                        d.rot(1);
                    }
                    if (k % 8 == 7) {
                        d.rot(2);
                    }
                    if (k % 16 != 15) continue;
                    d.rot(3);
                }
                c.rot(0);
                if (j % 2 == 1) {
                    c.rot(1);
                }
                if (j % 8 == 7) {
                    c.rot(2);
                }
                if (j % 16 != 15) continue;
                c.rot(3);
            }
            c.rot(0);
            if (i % 2 == 1) {
                c.rot(1);
            }
            if (i % 8 == 7) {
                c.rot(2);
            }
            if (i % 16 != 15) continue;
            c.rot(3);
        }
        for (i = 0; i < 48; ++i) {
            c.set(e);
            c.rotate(syminv[i]);
            block5: for (j = 0; j < 36; ++j) {
                d.set(c);
                d.move(j);
                d.rotate(i);
                for (k = 0; k < 36; ++k) {
                    f.set(e);
                    f.move(k);
                    if (!f.equals(d)) continue;
                    Center1.symmove[i][j] = k;
                    continue block5;
                }
            }
        }
        c.set(0);
        for (i = 0; i < 48; ++i) {
            Center1.finish[Center1.syminv[i]] = c.get();
            c.rot(0);
            if (i % 2 == 1) {
                c.rot(1);
            }
            if (i % 8 == 7) {
                c.rot(2);
            }
            if (i % 16 != 15) continue;
            c.rot(3);
        }
    }

    static {
        rot2str = new String[]{"", "y2", "x", "x y2", "x2", "z2", "x'", "x' y2", "", "", "", "", "", "", "", "", "y z", "y' z'", "y2 z", "z'", "y' z", "y z'", "z", "z y2", "", "", "", "", "", "", "", "", "y' x'", "y x", "y'", "y", "y' x", "y x'", "y z2", "y' z2", "", "", "", "", "", "", "", ""};
    }
}

