/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.CenterCube;
import cs.threephase.Moves;
import cs.threephase.Util;
import java.util.Arrays;

class Center2 {
    int[] rl = new int[8];
    int[] ct = new int[16];
    int parity = 0;
    static int[][] rlmv = new int[70][28];
    static char[][] ctmv = new char[6435][28];
    static int[][] rlrot = new int[70][16];
    static char[][] ctrot = new char[6435][16];
    static byte[] ctprun = new byte[450450];
    private static int[] pmv = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0};

    static void init() {
        int j;
        int m;
        int i;
        Center2 c = new Center2();
        for (i = 0; i < 70; ++i) {
            for (m = 0; m < 28; ++m) {
                c.setrl(i);
                c.move(Moves.move2std[m]);
                Center2.rlmv[i][m] = c.getrl();
            }
        }
        for (i = 0; i < 70; ++i) {
            c.setrl(i);
            for (j = 0; j < 16; ++j) {
                Center2.rlrot[i][j] = c.getrl();
                c.rot(0);
                if (j % 2 == 1) {
                    c.rot(1);
                }
                if (j % 8 != 7) continue;
                c.rot(2);
            }
        }
        for (i = 0; i < 6435; ++i) {
            c.setct(i);
            for (j = 0; j < 16; ++j) {
                Center2.ctrot[i][j] = (char)c.getct();
                c.rot(0);
                if (j % 2 == 1) {
                    c.rot(1);
                }
                if (j % 8 != 7) continue;
                c.rot(2);
            }
        }
        for (i = 0; i < 6435; ++i) {
            for (m = 0; m < 28; ++m) {
                c.setct(i);
                c.move(Moves.move2std[m]);
                Center2.ctmv[i][m] = (char)c.getct();
            }
        }
        Arrays.fill(ctprun, (byte)-1);
        Center2.ctprun[56] = 0;
        Center2.ctprun[54] = 0;
        Center2.ctprun[46] = 0;
        Center2.ctprun[28] = 0;
        Center2.ctprun[18] = 0;
        Center2.ctprun[0] = 0;
        byte depth = 0;
        int done = 6;
        while (done != 450450) {
            for (int i2 = 0; i2 < 450450; ++i2) {
                if (ctprun[i2] != depth) continue;
                int ct = i2 / 70;
                int rl = i2 % 70;
                for (int m2 = 0; m2 < 23; ++m2) {
                    char ctx = ctmv[ct][m2];
                    int rlx = rlmv[rl][m2];
                    int idx = ctx * 70 + rlx;
                    if (ctprun[idx] != -1) continue;
                    Center2.ctprun[idx] = (byte)(depth + 1);
                    ++done;
                }
            }
            ++depth;
        }
    }

    Center2() {
    }

    void set(CenterCube c, int edgeParity) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.ct[i] = c.ct[i] % 3;
        }
        for (i = 0; i < 8; ++i) {
            this.rl[i] = c.ct[i + 16];
        }
        this.parity = edgeParity;
    }

    int getrl() {
        int idx = 0;
        int r = 4;
        for (int i = 6; i >= 0; --i) {
            if (this.rl[i] == this.rl[7]) continue;
            idx += Util.Cnk[i][r--];
        }
        return idx * 2 + this.parity;
    }

    void setrl(int idx) {
        this.parity = idx & 1;
        idx >>>= 1;
        int r = 4;
        this.rl[7] = 0;
        for (int i = 6; i >= 0; --i) {
            if (idx >= Util.Cnk[i][r]) {
                idx -= Util.Cnk[i][r--];
                this.rl[i] = 1;
                continue;
            }
            this.rl[i] = 0;
        }
    }

    int getct() {
        int idx = 0;
        int r = 8;
        for (int i = 14; i >= 0; --i) {
            if (this.ct[i] == this.ct[15]) continue;
            idx += Util.Cnk[i][r--];
        }
        return idx;
    }

    void setct(int idx) {
        int r = 8;
        this.ct[15] = 0;
        for (int i = 14; i >= 0; --i) {
            if (idx >= Util.Cnk[i][r]) {
                idx -= Util.Cnk[i][r--];
                this.ct[i] = 1;
                continue;
            }
            this.ct[i] = 0;
        }
    }

    void rot(int r) {
        switch (r) {
            case 0: {
                this.move(19);
                this.move(28);
                break;
            }
            case 1: {
                this.move(21);
                this.move(32);
                break;
            }
            case 2: {
                Util.swap(this.ct, 0, 3, 1, 2, 1);
                Util.swap(this.ct, 8, 11, 9, 10, 1);
                Util.swap(this.ct, 4, 7, 5, 6, 1);
                Util.swap(this.ct, 12, 15, 13, 14, 1);
                Util.swap(this.rl, 0, 3, 5, 6, 1);
                Util.swap(this.rl, 1, 2, 4, 7, 1);
            }
        }
    }

    void move(int m) {
        this.parity ^= pmv[m];
        int key = m % 3;
        switch (m /= 3) {
            case 0: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                break;
            }
            case 1: {
                Util.swap(this.rl, 0, 1, 2, 3, key);
                break;
            }
            case 2: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                break;
            }
            case 3: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                break;
            }
            case 4: {
                Util.swap(this.rl, 4, 5, 6, 7, key);
                break;
            }
            case 5: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                break;
            }
            case 6: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                Util.swap(this.rl, 0, 5, 4, 1, key);
                Util.swap(this.ct, 8, 9, 12, 13, key);
                break;
            }
            case 7: {
                Util.swap(this.rl, 0, 1, 2, 3, key);
                Util.swap(this.ct, 1, 15, 5, 9, key);
                Util.swap(this.ct, 2, 12, 6, 10, key);
                break;
            }
            case 8: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                Util.swap(this.rl, 0, 3, 6, 5, key);
                Util.swap(this.ct, 3, 2, 5, 4, key);
                break;
            }
            case 9: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                Util.swap(this.rl, 3, 2, 7, 6, key);
                Util.swap(this.ct, 11, 10, 15, 14, key);
                break;
            }
            case 10: {
                Util.swap(this.rl, 4, 5, 6, 7, key);
                Util.swap(this.ct, 0, 8, 4, 14, key);
                Util.swap(this.ct, 3, 11, 7, 13, key);
                break;
            }
            case 11: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                Util.swap(this.rl, 1, 4, 7, 2, key);
                Util.swap(this.ct, 1, 0, 7, 6, key);
            }
        }
    }
}

