/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.FullCube;
import cs.threephase.Util;
import java.util.Random;

class CenterCube {
    byte[] ct = new byte[24];
    static int[] center333Map = new int[]{0, 4, 2, 1, 5, 3};

    CenterCube() {
        for (int i = 0; i < 24; ++i) {
            this.ct[i] = (byte)(FullCube.centerFacelet[i] / 16);
        }
    }

    CenterCube(CenterCube c) {
        this.copy(c);
    }

    CenterCube(Random r) {
        this();
        for (int i = 0; i < 23; ++i) {
            int t = i + r.nextInt(24 - i);
            if (this.ct[t] == this.ct[i]) continue;
            byte m = this.ct[i];
            this.ct[i] = this.ct[t];
            this.ct[t] = m;
        }
    }

    CenterCube(int[] moveseq) {
        this();
        for (int m = 0; m < moveseq.length; ++m) {
            this.move(m);
        }
    }

    void copy(CenterCube c) {
        for (int i = 0; i < 24; ++i) {
            this.ct[i] = c.ct[i];
        }
    }

    void print() {
        for (int i = 0; i < 24; ++i) {
            System.out.print(this.ct[i]);
            System.out.print('\t');
        }
        System.out.println();
    }

    void fill333Facelet(char[] facelet) {
        int firstIdx = 4;
        int inc = 9;
        for (int i = 0; i < 6; ++i) {
            int idx = center333Map[i] << 2;
            if (this.ct[idx] != this.ct[idx + 1] || this.ct[idx + 1] != this.ct[idx + 2] || this.ct[idx + 2] != this.ct[idx + 3]) {
                throw new RuntimeException("Unsolved Center");
            }
            facelet[firstIdx + i * inc] = "URFDLB".charAt(this.ct[idx]);
        }
    }

    void move(int m) {
        int key = m % 3;
        switch (m /= 3) {
            case 0: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                break;
            }
            case 1: {
                Util.swap(this.ct, 16, 17, 18, 19, key);
                break;
            }
            case 2: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                break;
            }
            case 3: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                break;
            }
            case 4: {
                Util.swap(this.ct, 20, 21, 22, 23, key);
                break;
            }
            case 5: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                break;
            }
            case 6: {
                Util.swap(this.ct, 0, 1, 2, 3, key);
                Util.swap(this.ct, 8, 20, 12, 16, key);
                Util.swap(this.ct, 9, 21, 13, 17, key);
                break;
            }
            case 7: {
                Util.swap(this.ct, 16, 17, 18, 19, key);
                Util.swap(this.ct, 1, 15, 5, 9, key);
                Util.swap(this.ct, 2, 12, 6, 10, key);
                break;
            }
            case 8: {
                Util.swap(this.ct, 8, 9, 10, 11, key);
                Util.swap(this.ct, 2, 19, 4, 21, key);
                Util.swap(this.ct, 3, 16, 5, 22, key);
                break;
            }
            case 9: {
                Util.swap(this.ct, 4, 5, 6, 7, key);
                Util.swap(this.ct, 10, 18, 14, 22, key);
                Util.swap(this.ct, 11, 19, 15, 23, key);
                break;
            }
            case 10: {
                Util.swap(this.ct, 20, 21, 22, 23, key);
                Util.swap(this.ct, 0, 8, 4, 14, key);
                Util.swap(this.ct, 3, 11, 7, 13, key);
                break;
            }
            case 11: {
                Util.swap(this.ct, 12, 13, 14, 15, key);
                Util.swap(this.ct, 1, 20, 7, 18, key);
                Util.swap(this.ct, 0, 23, 6, 17, key);
            }
        }
    }
}

