/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.Util;
import java.util.Random;

class CornerCube {
    private static CornerCube[] moveCube = new CornerCube[18];
    private static final int[] cpmv = new int[]{1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1};
    byte[] cp = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    byte[] co = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    CornerCube temps = null;
    static final byte[][] cornerFacelet = new byte[][]{{8, 9, 20}, {6, 18, 38}, {0, 36, 47}, {2, 45, 11}, {29, 26, 15}, {27, 44, 24}, {33, 53, 42}, {35, 17, 51}};

    CornerCube() {
    }

    CornerCube(Random r) {
        this(r.nextInt(40320), r.nextInt(2187));
    }

    CornerCube(int cperm, int twist) {
        this.setCPerm(cperm);
        this.setTwist(twist);
    }

    CornerCube(CornerCube c) {
        this.copy(c);
    }

    void copy(CornerCube c) {
        for (int i = 0; i < 8; ++i) {
            this.cp[i] = c.cp[i];
            this.co[i] = c.co[i];
        }
    }

    int getParity() {
        return Util.parity(this.cp);
    }

    void fill333Facelet(char[] facelet) {
        for (int corn = 0; corn < 8; ++corn) {
            byte j = this.cp[corn];
            byte ori = this.co[corn];
            for (int n = 0; n < 3; ++n) {
                facelet[CornerCube.cornerFacelet[corn][(n + ori) % 3]] = "URFDLB".charAt(cornerFacelet[j][n] / 9);
            }
        }
    }

    static void CornMult(CornerCube a, CornerCube b, CornerCube prod) {
        for (int corn = 0; corn < 8; ++corn) {
            prod.cp[corn] = a.cp[b.cp[corn]];
            byte oriA = a.co[b.cp[corn]];
            int oriB = b.co[corn];
            byte ori = oriA;
            ori = (byte)(ori + (oriA < 3 ? oriB : 6 - oriB));
            ori = (byte)(ori % 3);
            if (oriA >= 3 ^ oriB >= 3) {
                ori = (byte)(ori + 3);
            }
            prod.co[corn] = ori;
        }
    }

    void setTwist(int idx) {
        int twst = 0;
        for (int i = 6; i >= 0; --i) {
            this.co[i] = (byte)(idx % 3);
            twst += this.co[i];
            idx /= 3;
        }
        this.co[7] = (byte)((15 - twst) % 3);
    }

    void setCPerm(int idx) {
        Util.set8Perm(this.cp, idx);
    }

    void move(int idx) {
        if (this.temps == null) {
            this.temps = new CornerCube();
        }
        CornerCube.CornMult(this, moveCube[idx], this.temps);
        this.copy(this.temps);
    }

    static void initMove() {
        CornerCube.moveCube[0] = new CornerCube(15120, 0);
        CornerCube.moveCube[3] = new CornerCube(21021, 1494);
        CornerCube.moveCube[6] = new CornerCube(8064, 1236);
        CornerCube.moveCube[9] = new CornerCube(9, 0);
        CornerCube.moveCube[12] = new CornerCube(1230, 412);
        CornerCube.moveCube[15] = new CornerCube(224, 137);
        for (int a = 0; a < 18; a += 3) {
            for (int p = 0; p < 2; ++p) {
                CornerCube.moveCube[a + p + 1] = new CornerCube();
                CornerCube.CornMult(moveCube[a + p], moveCube[a], moveCube[a + p + 1]);
            }
        }
    }

    static {
        CornerCube.initMove();
    }
}

