/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.EdgeCube;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edge3 {
    private static Logger logger = LoggerFactory.getLogger(Edge3.class);
    static final boolean IS_64BIT_PLATFORM = true;
    static final int N_SYM = 1538;
    static final int N_RAW = 20160;
    static final int N_EPRUN = 31006080;
    static final int MAX_DEPTH = 10;
    static final int[] prunValues = new int[]{1, 4, 16, 55, 324, 1922, 12275, 77640, 485359, 2778197, 11742425, 27492416, 31002941, 31006080};
    static int[] eprun = new int[1937880];
    static int[] sym2raw = new int[1538];
    static char[] symstate = new char[1538];
    static int[] raw2sym = new int[11880];
    static int[] syminv = new int[]{0, 1, 6, 3, 4, 5, 2, 7};
    int[] edge = new int[12];
    int[] edgeo = new int[12];
    int[] temp;
    boolean isStd = true;
    static int[][] mvrot = new int[160][12];
    static int[][] mvroto = new int[160][12];
    static int[] factX = new int[]{1, 1, 1, 3, 12, 60, 360, 2520, 20160, 181440, 1814400, 19958400, 239500800};
    static int done = 0;
    static int[] FullEdgeMap = new int[]{0, 2, 4, 6, 1, 3, 7, 5, 8, 9, 10, 11};

    public static double initStatus() {
        return (double)done * 1.0 / (double)prunValues[9];
    }

    static void initMvrot() {
        Edge3 e = new Edge3();
        for (int m = 0; m < 20; ++m) {
            for (int r = 0; r < 8; ++r) {
                int i;
                e.set(0);
                e.move(m);
                e.rotate(r);
                for (i = 0; i < 12; ++i) {
                    Edge3.mvrot[m << 3 | r][i] = e.edge[i];
                }
                e.std();
                for (i = 0; i < 12; ++i) {
                    Edge3.mvroto[m << 3 | r][i] = e.temp[i];
                }
            }
        }
    }

    static void initRaw2Sym() {
        Edge3 e = new Edge3();
        byte[] occ = new byte[1485];
        int count = 0;
        for (int i = 0; i < 11880; ++i) {
            if ((occ[i >>> 3] & 1 << (i & 7)) != 0) continue;
            e.set(i * factX[8]);
            for (int j = 0; j < 8; ++j) {
                int idx = e.get(4);
                if (idx == i) {
                    int n = count;
                    symstate[n] = (char)(symstate[n] | 1 << j);
                }
                int n = idx >> 3;
                occ[n] = (byte)(occ[n] | 1 << (idx & 7));
                Edge3.raw2sym[idx] = count << 3 | syminv[j];
                e.rot(0);
                if (j % 2 != 1) continue;
                e.rot(1);
                e.rot(2);
            }
            Edge3.sym2raw[count++] = i;
        }
        assert (count == 1538);
    }

    static void setPruning(int[] table, int index, int value) {
        int n = index >> 4;
        table[n] = table[n] ^ (3 ^ value) << ((index & 0xF) << 1);
    }

    static int getPruning(int[] table, int index) {
        return table[index >> 4] >> ((index & 0xF) << 1) & 3;
    }

    static int getprun(int edge, int prun) {
        int depm3 = Edge3.getPruning(eprun, edge);
        if (depm3 == 3) {
            return 10;
        }
        return (depm3 - prun + 16) % 3 + prun - 1;
    }

    static int getprun(int edge) {
        Edge3 e = new Edge3();
        int depth = 0;
        int depm3 = Edge3.getPruning(eprun, edge);
        if (depm3 == 3) {
            return 10;
        }
        block0: while (edge != 0) {
            depm3 = depm3 == 0 ? 2 : --depm3;
            int symcord1 = edge / 20160;
            int cord1 = sym2raw[symcord1];
            int cord2 = edge % 20160;
            e.set(cord1 * 20160 + cord2);
            for (int m = 0; m < 17; ++m) {
                int symx;
                int cord2x;
                int idx;
                int cord1x = Edge3.getmvrot(e.edge, m << 3, 4);
                int symcord1x = raw2sym[cord1x];
                if (Edge3.getPruning(eprun, idx = (symcord1x >>= 3) * 20160 + (cord2x = Edge3.getmvrot(e.edge, m << 3 | (symx = symcord1x & 7), 10) % 20160)) != depm3) continue;
                ++depth;
                edge = idx;
                continue block0;
            }
        }
        return depth;
    }

    static void createPrun() {
        Edge3 e = new Edge3();
        Edge3 f = new Edge3();
        Edge3 g = new Edge3();
        Arrays.fill(eprun, -1);
        int depth = 0;
        done = 1;
        Edge3.setPruning(eprun, 0, 0);
        while (done != 31006080) {
            int chk;
            boolean inv = depth > 9;
            int depm3 = depth % 3;
            int dep1m3 = (depth + 1) % 3;
            int find = inv ? 3 : depm3;
            int n = chk = inv ? depm3 : 3;
            if (depth >= 9) break;
            for (int i_ = 0; i_ < 31006080; i_ += 16) {
                int val = eprun[i_ >> 4];
                if (!inv && val == -1) continue;
                int i = i_;
                int end = i_ + 16;
                while (i < end) {
                    if ((val & 3) == find) {
                        int symcord1 = i / 20160;
                        int cord1 = sym2raw[symcord1];
                        int cord2 = i % 20160;
                        e.set(cord1 * 20160 + cord2);
                        for (int m = 0; m < 17; ++m) {
                            int symx;
                            int cord2x;
                            int idx;
                            int cord1x = Edge3.getmvrot(e.edge, m << 3, 4);
                            int symcord1x = raw2sym[cord1x];
                            if (Edge3.getPruning(eprun, idx = (symcord1x >>= 3) * 20160 + (cord2x = Edge3.getmvrot(e.edge, m << 3 | (symx = symcord1x & 7), 10) % 20160)) != chk) continue;
                            Edge3.setPruning(eprun, inv ? i : idx, dep1m3);
                            ++done;
                            if (inv) break;
                            char symState = symstate[symcord1x];
                            if (symState == '\u0001') continue;
                            f.set(e);
                            f.move(m);
                            f.rotate(symx);
                            int j = 1;
                            while ((symState = (char)(symState >> 1)) != '\u0000') {
                                if ((symState & '\u0001') == 1) {
                                    g.set(f);
                                    g.rotate(j);
                                    int idxx = symcord1x * 20160 + g.get(10) % 20160;
                                    if (Edge3.getPruning(eprun, idxx) == chk) {
                                        Edge3.setPruning(eprun, idxx, dep1m3);
                                        ++done;
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                    val >>= 2;
                }
            }
            logger.debug(++depth + "\t" + done);
        }
    }

    int getsym() {
        int cord1x = this.get(4);
        int symcord1x = raw2sym[cord1x];
        int symx = symcord1x & 7;
        this.rotate(symx);
        int cord2x = this.get(10) % 20160;
        return (symcord1x >>= 3) * 20160 + cord2x;
    }

    int set(EdgeCube c) {
        int i;
        if (this.temp == null) {
            this.temp = new int[12];
        }
        for (int i2 = 0; i2 < 12; ++i2) {
            this.temp[i2] = i2;
            this.edge[i2] = c.ep[FullEdgeMap[i2] + 12] % 12;
        }
        int parity = 1;
        for (i = 0; i < 12; ++i) {
            while (this.edge[i] != i) {
                int t = this.edge[i];
                this.edge[i] = this.edge[t];
                this.edge[t] = t;
                int s = this.temp[i];
                this.temp[i] = this.temp[t];
                this.temp[t] = s;
                parity ^= 1;
            }
        }
        for (i = 0; i < 12; ++i) {
            this.edge[i] = this.temp[c.ep[FullEdgeMap[i]] % 12];
        }
        return parity;
    }

    void set(Edge3 e) {
        for (int i = 0; i < 12; ++i) {
            this.edge[i] = e.edge[i];
            this.edgeo[i] = e.edgeo[i];
        }
        this.isStd = e.isStd;
    }

    static int getmvrot(int[] ep, int mrIdx, int end) {
        int[] movo = mvroto[mrIdx];
        int[] mov = mvrot[mrIdx];
        int idx = 0;
        long val = 205163983024656L;
        for (int i = 0; i < end; ++i) {
            int v = movo[ep[mov[i]]] << 2;
            idx *= 12 - i;
            idx = (int)((long)idx + (val >> v & 0xFL));
            val -= 0x111111111110L << v;
        }
        return idx;
    }

    void std() {
        int i;
        if (this.temp == null) {
            this.temp = new int[12];
        }
        for (i = 0; i < 12; ++i) {
            this.temp[this.edgeo[i]] = i;
        }
        for (i = 0; i < 12; ++i) {
            this.edge[i] = this.temp[this.edge[i]];
            this.edgeo[i] = i;
        }
        this.isStd = true;
    }

    int get(int end) {
        if (!this.isStd) {
            this.std();
        }
        int idx = 0;
        long val = 205163983024656L;
        for (int i = 0; i < end; ++i) {
            int v = this.edge[i] << 2;
            idx *= 12 - i;
            idx = (int)((long)idx + (val >> v & 0xFL));
            val -= 0x111111111110L << v;
        }
        return idx;
    }

    void set(int idx) {
        long val = 205163983024656L;
        int parity = 0;
        for (int i = 0; i < 11; ++i) {
            int p = factX[11 - i];
            int v = idx / p;
            idx %= p;
            parity ^= v;
            this.edge[i] = (int)(val >> (v <<= 2) & 0xFL);
            long m = (1L << v) - 1L;
            val = (val & m) + (val >> 4 & (m ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (!(parity & true)) {
            this.edge[11] = (int)val;
        } else {
            this.edge[11] = this.edge[10];
            this.edge[10] = (int)val;
        }
        for (int i = 0; i < 12; ++i) {
            this.edgeo[i] = i;
        }
        this.isStd = true;
    }

    void move(int i) {
        this.isStd = false;
        switch (i) {
            case 0: {
                this.circle(this.edge, 0, 4, 1, 5);
                this.circle(this.edgeo, 0, 4, 1, 5);
                break;
            }
            case 1: {
                this.swap(this.edge, 0, 4, 1, 5);
                this.swap(this.edgeo, 0, 4, 1, 5);
                break;
            }
            case 2: {
                this.circle(this.edge, 0, 5, 1, 4);
                this.circle(this.edgeo, 0, 5, 1, 4);
                break;
            }
            case 3: {
                this.swap(this.edge, 5, 10, 6, 11);
                this.swap(this.edgeo, 5, 10, 6, 11);
                break;
            }
            case 4: {
                this.circle(this.edge, 0, 11, 3, 8);
                this.circle(this.edgeo, 0, 11, 3, 8);
                break;
            }
            case 5: {
                this.swap(this.edge, 0, 11, 3, 8);
                this.swap(this.edgeo, 0, 11, 3, 8);
                break;
            }
            case 6: {
                this.circle(this.edge, 0, 8, 3, 11);
                this.circle(this.edgeo, 0, 8, 3, 11);
                break;
            }
            case 7: {
                this.circle(this.edge, 2, 7, 3, 6);
                this.circle(this.edgeo, 2, 7, 3, 6);
                break;
            }
            case 8: {
                this.swap(this.edge, 2, 7, 3, 6);
                this.swap(this.edgeo, 2, 7, 3, 6);
                break;
            }
            case 9: {
                this.circle(this.edge, 2, 6, 3, 7);
                this.circle(this.edgeo, 2, 6, 3, 7);
                break;
            }
            case 10: {
                this.swap(this.edge, 4, 8, 7, 9);
                this.swap(this.edgeo, 4, 8, 7, 9);
                break;
            }
            case 11: {
                this.circle(this.edge, 1, 9, 2, 10);
                this.circle(this.edgeo, 1, 9, 2, 10);
                break;
            }
            case 12: {
                this.swap(this.edge, 1, 9, 2, 10);
                this.swap(this.edgeo, 1, 9, 2, 10);
                break;
            }
            case 13: {
                this.circle(this.edge, 1, 10, 2, 9);
                this.circle(this.edgeo, 1, 10, 2, 9);
                break;
            }
            case 14: {
                this.swap(this.edge, 0, 4, 1, 5);
                this.swap(this.edgeo, 0, 4, 1, 5);
                this.swap(this.edge, 9, 11);
                this.swap(this.edgeo, 8, 10);
                break;
            }
            case 15: {
                this.swap(this.edge, 5, 10, 6, 11);
                this.swap(this.edgeo, 5, 10, 6, 11);
                this.swap(this.edge, 1, 3);
                this.swap(this.edgeo, 0, 2);
                break;
            }
            case 16: {
                this.swap(this.edge, 0, 11, 3, 8);
                this.swap(this.edgeo, 0, 11, 3, 8);
                this.swap(this.edge, 5, 7);
                this.swap(this.edgeo, 4, 6);
                break;
            }
            case 17: {
                this.swap(this.edge, 2, 7, 3, 6);
                this.swap(this.edgeo, 2, 7, 3, 6);
                this.swap(this.edge, 8, 10);
                this.swap(this.edgeo, 9, 11);
                break;
            }
            case 18: {
                this.swap(this.edge, 4, 8, 7, 9);
                this.swap(this.edgeo, 4, 8, 7, 9);
                this.swap(this.edge, 0, 2);
                this.swap(this.edgeo, 1, 3);
                break;
            }
            case 19: {
                this.swap(this.edge, 1, 9, 2, 10);
                this.swap(this.edgeo, 1, 9, 2, 10);
                this.swap(this.edge, 4, 6);
                this.swap(this.edgeo, 5, 7);
            }
        }
    }

    void rot(int r) {
        this.isStd = false;
        switch (r) {
            case 0: {
                this.move(14);
                this.move(17);
                break;
            }
            case 1: {
                this.circlex(11, 5, 10, 6);
                this.circlex(5, 10, 6, 11);
                this.circlex(1, 2, 3, 0);
                this.circlex(4, 9, 7, 8);
                this.circlex(8, 4, 9, 7);
                this.circlex(0, 1, 2, 3);
                break;
            }
            case 2: {
                this.swapx(4, 5);
                this.swapx(5, 4);
                this.swapx(11, 8);
                this.swapx(8, 11);
                this.swapx(7, 6);
                this.swapx(6, 7);
                this.swapx(9, 10);
                this.swapx(10, 9);
                this.swapx(1, 1);
                this.swapx(0, 0);
                this.swapx(3, 3);
                this.swapx(2, 2);
            }
        }
    }

    void rotate(int r) {
        while (r >= 2) {
            r -= 2;
            this.rot(1);
            this.rot(2);
        }
        if (r != 0) {
            this.rot(0);
        }
    }

    void circle(int[] arr, int a, int b, int c, int d) {
        int temp = arr[d];
        arr[d] = arr[c];
        arr[c] = arr[b];
        arr[b] = arr[a];
        arr[a] = temp;
    }

    void swap(int[] arr, int a, int b, int c, int d) {
        int temp = arr[a];
        arr[a] = arr[c];
        arr[c] = temp;
        temp = arr[b];
        arr[b] = arr[d];
        arr[d] = temp;
    }

    void swap(int[] arr, int x, int y) {
        int temp = arr[x];
        arr[x] = arr[y];
        arr[y] = temp;
    }

    void swapx(int x, int y) {
        int temp = this.edge[x];
        this.edge[x] = this.edgeo[y];
        this.edgeo[y] = temp;
    }

    void circlex(int a, int b, int c, int d) {
        int temp = this.edgeo[d];
        this.edgeo[d] = this.edge[c];
        this.edge[c] = this.edgeo[b];
        this.edgeo[b] = this.edge[a];
        this.edge[a] = temp;
    }
}

