/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.Util;
import java.util.Random;

class EdgeCube {
    private static final int[] epmv = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1};
    static int[][] EdgeColor = new int[][]{{2, 0}, {4, 0}, {5, 0}, {1, 0}, {5, 3}, {4, 3}, {2, 3}, {1, 3}, {2, 4}, {5, 4}, {5, 1}, {2, 1}};
    static int[] EdgeMap = new int[]{19, 37, 46, 10, 52, 43, 25, 16, 21, 50, 48, 23, 7, 3, 1, 5, 34, 30, 28, 32, 41, 39, 14, 12};
    byte[] ep = new byte[24];

    EdgeCube() {
        for (int i = 0; i < 24; i = (int)((byte)(i + 1))) {
            this.ep[i] = i;
        }
    }

    EdgeCube(EdgeCube c) {
        this.copy(c);
    }

    EdgeCube(Random r) {
        this();
        for (int i = 0; i < 23; ++i) {
            int t = i + r.nextInt(24 - i);
            if (t == i) continue;
            byte m = this.ep[i];
            this.ep[i] = this.ep[t];
            this.ep[t] = m;
        }
    }

    EdgeCube(int[] moveseq) {
        this();
        for (int m = 0; m < moveseq.length; ++m) {
            this.move(m);
        }
    }

    int getParity() {
        return Util.parity(this.ep);
    }

    void copy(EdgeCube c) {
        for (int i = 0; i < 24; ++i) {
            this.ep[i] = c.ep[i];
        }
    }

    void print() {
        for (int i = 0; i < 24; ++i) {
            System.out.print(this.ep[i]);
            System.out.print('\t');
        }
        System.out.println();
    }

    void fill333Facelet(char[] facelet) {
        for (int i = 0; i < 24; ++i) {
            facelet[EdgeCube.EdgeMap[i]] = "URFDLB".charAt(EdgeColor[this.ep[i] % 12][this.ep[i] / 12]);
        }
    }

    boolean checkEdge() {
        int ck = 0;
        boolean parity = false;
        for (int i = 0; i < 12; ++i) {
            ck |= 1 << this.ep[i];
            parity = parity != this.ep[i] >= 12;
        }
        return (ck &= ck >> 12) == 0 && !parity;
    }

    void move(int m) {
        int key = m % 3;
        switch (m /= 3) {
            case 0: {
                Util.swap(this.ep, 0, 1, 2, 3, key);
                Util.swap(this.ep, 12, 13, 14, 15, key);
                break;
            }
            case 1: {
                Util.swap(this.ep, 11, 15, 10, 19, key);
                Util.swap(this.ep, 23, 3, 22, 7, key);
                break;
            }
            case 2: {
                Util.swap(this.ep, 0, 11, 6, 8, key);
                Util.swap(this.ep, 12, 23, 18, 20, key);
                break;
            }
            case 3: {
                Util.swap(this.ep, 4, 5, 6, 7, key);
                Util.swap(this.ep, 16, 17, 18, 19, key);
                break;
            }
            case 4: {
                Util.swap(this.ep, 1, 20, 5, 21, key);
                Util.swap(this.ep, 13, 8, 17, 9, key);
                break;
            }
            case 5: {
                Util.swap(this.ep, 2, 9, 4, 10, key);
                Util.swap(this.ep, 14, 21, 16, 22, key);
                break;
            }
            case 6: {
                Util.swap(this.ep, 0, 1, 2, 3, key);
                Util.swap(this.ep, 12, 13, 14, 15, key);
                Util.swap(this.ep, 9, 22, 11, 20, key);
                break;
            }
            case 7: {
                Util.swap(this.ep, 11, 15, 10, 19, key);
                Util.swap(this.ep, 23, 3, 22, 7, key);
                Util.swap(this.ep, 2, 16, 6, 12, key);
                break;
            }
            case 8: {
                Util.swap(this.ep, 0, 11, 6, 8, key);
                Util.swap(this.ep, 12, 23, 18, 20, key);
                Util.swap(this.ep, 3, 19, 5, 13, key);
                break;
            }
            case 9: {
                Util.swap(this.ep, 4, 5, 6, 7, key);
                Util.swap(this.ep, 16, 17, 18, 19, key);
                Util.swap(this.ep, 8, 23, 10, 21, key);
                break;
            }
            case 10: {
                Util.swap(this.ep, 1, 20, 5, 21, key);
                Util.swap(this.ep, 13, 8, 17, 9, key);
                Util.swap(this.ep, 14, 0, 18, 4, key);
                break;
            }
            case 11: {
                Util.swap(this.ep, 2, 9, 4, 10, key);
                Util.swap(this.ep, 14, 21, 16, 22, key);
                Util.swap(this.ep, 7, 15, 1, 17, key);
            }
        }
    }
}

