/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.Center1;
import cs.threephase.CenterCube;
import cs.threephase.CornerCube;
import cs.threephase.EdgeCube;
import cs.threephase.Moves;
import java.util.Comparator;
import java.util.Random;

public class FullCube
implements Comparable<FullCube> {
    static final byte[] centerFacelet = new byte[]{5, 6, 10, 9, 53, 54, 58, 57, 37, 38, 42, 41, 85, 86, 90, 89, 21, 22, 26, 25, 69, 70, 74, 73};
    static final byte[][] edgeFacelet = new byte[][]{{13, 33}, {4, 65}, {2, 81}, {11, 17}, {61, 94}, {52, 78}, {50, 46}, {59, 30}, {75, 40}, {68, 87}, {27, 88}, {20, 39}, {34, 14}, {66, 8}, {82, 1}, {18, 7}, {93, 62}, {77, 56}, {45, 49}, {29, 55}, {36, 71}, {91, 72}, {84, 23}, {43, 24}};
    static final byte[][] cornerFacelet = new byte[][]{{15, 16, 35}, {12, 32, 67}, {0, 64, 83}, {3, 80, 19}, {51, 47, 28}, {48, 79, 44}, {60, 95, 76}, {63, 31, 92}};
    private EdgeCube edge;
    private CenterCube center;
    private CornerCube corner;
    int value = 0;
    boolean add1 = false;
    int length1 = 0;
    int length2 = 0;
    int length3 = 0;
    private static int[] move2rot = new int[]{35, 1, 34, 2, 4, 6, 22, 5, 19};
    byte[] moveBuffer = new byte[60];
    private int moveLength = 0;
    private int edgeAvail = 0;
    private int centerAvail = 0;
    private int cornerAvail = 0;
    int sym = 0;

    public FullCube(byte[] f) {
        int i;
        this.edge = new EdgeCube();
        this.center = new CenterCube();
        this.corner = new CornerCube();
        for (i = 0; i < 24; ++i) {
            this.center.ct[i] = f[centerFacelet[i]];
        }
        for (i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; j = (int)((byte)(j + 1))) {
                if (f[edgeFacelet[i][0]] != edgeFacelet[j][0] / 16 || f[edgeFacelet[i][1]] != edgeFacelet[j][1] / 16) continue;
                this.edge.ep[i] = j;
            }
        }
        block3: for (int i2 = 0; i2 < 8; i2 = (int)((byte)(i2 + 1))) {
            int ori;
            for (ori = 0; ori < 3 && f[cornerFacelet[i2][ori]] != 0 && f[cornerFacelet[i2][ori]] != 3; ori = (int)((byte)(ori + 1))) {
            }
            byte col1 = f[cornerFacelet[i2][(ori + 1) % 3]];
            byte col2 = f[cornerFacelet[i2][(ori + 2) % 3]];
            for (int j = 0; j < 8; j = (int)((byte)(j + 1))) {
                if (col1 != cornerFacelet[j][1] / 16 || col2 != cornerFacelet[j][2] / 16) continue;
                this.corner.cp[i2] = j;
                this.corner.co[i2] = (byte)(ori % 3);
                continue block3;
            }
        }
    }

    void toFacelet(byte[] f) {
        int i;
        for (i = 0; i < 24; ++i) {
            f[FullCube.centerFacelet[i]] = this.center.ct[i];
        }
        for (i = 0; i < 24; ++i) {
            f[FullCube.edgeFacelet[i][0]] = (byte)(edgeFacelet[this.edge.ep[i]][0] / 16);
            f[FullCube.edgeFacelet[i][1]] = (byte)(edgeFacelet[this.edge.ep[i]][1] / 16);
        }
        for (int c = 0; c < 8; c = (int)((byte)(c + 1))) {
            byte j = this.corner.cp[c];
            byte ori = this.corner.co[c];
            for (int n = 0; n < 3; n = (int)((byte)(n + 1))) {
                f[FullCube.cornerFacelet[c][(n + ori) % 3]] = (byte)(cornerFacelet[j][n] / 16);
            }
        }
    }

    public String toString() {
        this.getEdge();
        this.getCenter();
        this.getCorner();
        byte[] f = new byte[96];
        StringBuffer sb = new StringBuffer();
        this.toFacelet(f);
        for (int i = 0; i < 96; ++i) {
            sb.append("URFDLB".charAt(f[i]));
            if (i % 4 == 3) {
                sb.append('\n');
            }
            if (i % 16 != 15) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(FullCube c) {
        return this.value - c.value;
    }

    public FullCube() {
        this.edge = new EdgeCube();
        this.center = new CenterCube();
        this.corner = new CornerCube();
    }

    public FullCube(FullCube c) {
        this();
        this.copy(c);
    }

    public FullCube(Random r) {
        this.edge = new EdgeCube(r);
        this.center = new CenterCube(r);
        this.corner = new CornerCube(r);
    }

    public FullCube(int[] moveseq) {
        this();
        for (int m : moveseq) {
            this.doMove(m);
        }
    }

    public void copy(FullCube c) {
        this.edge.copy(c.edge);
        this.center.copy(c.center);
        this.corner.copy(c.corner);
        this.value = c.value;
        this.add1 = c.add1;
        this.length1 = c.length1;
        this.length2 = c.length2;
        this.length3 = c.length3;
        this.sym = c.sym;
        for (int i = 0; i < 60; ++i) {
            this.moveBuffer[i] = c.moveBuffer[i];
        }
        this.moveLength = c.moveLength;
        this.edgeAvail = c.edgeAvail;
        this.centerAvail = c.centerAvail;
        this.cornerAvail = c.cornerAvail;
    }

    public boolean checkEdge() {
        return this.getEdge().checkEdge();
    }

    public String getMoveString(boolean inverse, boolean rotation) {
        int[] fixedMoves = new int[this.moveLength - (this.add1 ? 2 : 0)];
        int idx = 0;
        for (int i = 0; i < this.length1; ++i) {
            fixedMoves[idx++] = this.moveBuffer[i];
        }
        int sym = this.sym;
        for (int i = this.length1 + (this.add1 ? 2 : 0); i < this.moveLength; ++i) {
            if (Center1.symmove[sym][this.moveBuffer[i]] >= 27) {
                fixedMoves[idx++] = Center1.symmove[sym][this.moveBuffer[i]] - 9;
                int rot = move2rot[Center1.symmove[sym][this.moveBuffer[i]] - 27];
                sym = Center1.symmult[sym][rot];
                continue;
            }
            fixedMoves[idx++] = Center1.symmove[sym][this.moveBuffer[i]];
        }
        int finishSym = Center1.symmult[Center1.syminv[sym]][Center1.getSolvedSym(this.getCenter())];
        StringBuffer sb = new StringBuffer();
        sym = finishSym;
        if (inverse) {
            for (int i = idx - 1; i >= 0; --i) {
                int move = fixedMoves[i];
                if (Center1.symmove[sym][move = move / 3 * 3 + (2 - move % 3)] >= 27) {
                    sb.append(Moves.move2str[Center1.symmove[sym][move] - 9]).append(' ');
                    int rot = move2rot[Center1.symmove[sym][move] - 27];
                    sym = Center1.symmult[sym][rot];
                    continue;
                }
                sb.append(Moves.move2str[Center1.symmove[sym][move]]).append(' ');
            }
            if (rotation) {
                sb.append(Center1.rot2str[Center1.syminv[sym]] + " ");
            }
        } else {
            for (int i = 0; i < idx; ++i) {
                sb.append(Moves.move2str[fixedMoves[i]]).append(' ');
            }
            if (rotation) {
                sb.append(Center1.rot2str[finishSym]);
            }
        }
        return sb.toString();
    }

    String to333Facelet() {
        char[] ret = new char[54];
        this.getEdge().fill333Facelet(ret);
        this.getCenter().fill333Facelet(ret);
        this.getCorner().fill333Facelet(ret);
        return new String(ret);
    }

    void move(int m) {
        this.moveBuffer[this.moveLength++] = (byte)m;
    }

    void doMove(int m) {
        this.getEdge().move(m);
        this.getCenter().move(m);
        this.getCorner().move(m % 18);
    }

    EdgeCube getEdge() {
        while (this.edgeAvail < this.moveLength) {
            this.edge.move(this.moveBuffer[this.edgeAvail++]);
        }
        return this.edge;
    }

    CenterCube getCenter() {
        while (this.centerAvail < this.moveLength) {
            this.center.move(this.moveBuffer[this.centerAvail++]);
        }
        return this.center;
    }

    CornerCube getCorner() {
        while (this.cornerAvail < this.moveLength) {
            this.corner.move(this.moveBuffer[this.cornerAvail++] % 18);
        }
        return this.corner;
    }

    public static class ValueComparator
    implements Comparator<FullCube> {
        @Override
        public int compare(FullCube c1, FullCube c2) {
            return c2.value - c1.value;
        }
    }
}

