/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.Center1;
import cs.threephase.Center2;
import cs.threephase.Center3;
import cs.threephase.Edge3;
import cs.threephase.FullCube;
import cs.threephase.Moves;
import cs.threephase.Util;
import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search {
    private static Logger logger = LoggerFactory.getLogger(Search.class);
    static final int PHASE1_SOLUTIONS = 10000;
    static final int PHASE2_ATTEMPTS = 500;
    static final int PHASE2_SOLUTIONS = 100;
    static final int PHASE3_ATTEMPTS = 100;
    static boolean inited = false;
    PriorityQueue<FullCube> p1sols = new PriorityQueue<FullCube>(500, new FullCube.ValueComparator());
    static int[] count = new int[1];
    int[] move1 = new int[15];
    int[] move2 = new int[20];
    int[] move3 = new int[20];
    int length1 = 0;
    int length2 = 0;
    int maxlength2;
    boolean add1 = false;
    public FullCube c;
    FullCube c1 = new FullCube();
    FullCube c2 = new FullCube();
    Center2 ct2 = new Center2();
    Center3 ct3 = new Center3();
    Edge3 e12 = new Edge3();
    Edge3[] tempe = new Edge3[20];
    cs.min2phase.Search search333 = new cs.min2phase.Search();
    int valid1 = 0;
    String solution = "";
    int p1SolsCnt = 0;
    FullCube[] arr2 = new FullCube[100];
    int arr2idx = 0;
    public boolean inverse_solution = true;
    public boolean with_rotation = false;
    int totlen = 0;

    public Search() {
        for (int i = 0; i < 20; ++i) {
            this.tempe[i] = new Edge3();
        }
    }

    public static synchronized void init() {
        if (inited) {
            return;
        }
        cs.min2phase.Search.init();
        logger.info("Initialize Center1 Solver...");
        Center1.initSym();
        Center1.raw2sym = new int[735471];
        Center1.initSym2Raw();
        Center1.createMoveTable();
        Center1.raw2sym = null;
        Center1.createPrun();
        logger.info("Initialize Center2 Solver...");
        Center2.init();
        logger.info("Initialize Center3 Solver...");
        Center3.init();
        logger.info("Initialize Edge3 Solver...");
        Edge3.initMvrot();
        Edge3.initRaw2Sym();
        Edge3.createPrun();
        logger.info("OK");
        inited = true;
    }

    public String randomMove(Random r) {
        int[] moveseq = new int[40];
        int lm = 36;
        int i = 0;
        while (i < moveseq.length) {
            int m = r.nextInt(27);
            if (Moves.ckmv[lm][m]) continue;
            moveseq[i++] = m;
            lm = m;
        }
        System.out.println(Util.tostr(moveseq));
        return this.solve(moveseq);
    }

    public String randomState(Random r) {
        this.c = new FullCube(r);
        this.doSearch();
        return this.solution;
    }

    public String solution(String facelet) {
        byte[] f = new byte[96];
        for (int i = 0; i < 96; ++i) {
            f[i] = (byte)"URFDLB".indexOf(facelet.charAt(i));
        }
        this.c = new FullCube(f);
        this.doSearch();
        return this.solution;
    }

    public String solve(String scramble) {
        int[] moveseq = Util.tomove(scramble);
        return this.solve(moveseq);
    }

    public String solve(int[] moveseq) {
        this.c = new FullCube(moveseq);
        this.doSearch();
        return this.solution;
    }

    void doSearch() {
        int length123;
        int length12;
        Search.init();
        this.solution = "";
        int ud = new Center1(this.c.getCenter(), 0).getsym();
        int fb = new Center1(this.c.getCenter(), 1).getsym();
        int rl = new Center1(this.c.getCenter(), 2).getsym();
        byte udprun = Center1.csprun[ud >> 6];
        byte fbprun = Center1.csprun[fb >> 6];
        byte rlprun = Center1.csprun[rl >> 6];
        this.p1SolsCnt = 0;
        this.arr2idx = 0;
        this.p1sols.clear();
        this.length1 = Math.min(Math.min(udprun, fbprun), rlprun);
        while (!(this.length1 >= 100 || rlprun <= this.length1 && this.search1(rl >>> 6, rl & 0x3F, this.length1, -1, 0) || udprun <= this.length1 && this.search1(ud >>> 6, ud & 0x3F, this.length1, -1, 0) || fbprun <= this.length1 && this.search1(fb >>> 6, fb & 0x3F, this.length1, -1, 0))) {
            ++this.length1;
        }
        Object[] p1SolsArr = this.p1sols.toArray(new FullCube[0]);
        Arrays.sort(p1SolsArr, 0, p1SolsArr.length);
        int MAX_LENGTH2 = 9;
        do {
            block2: for (length12 = ((FullCube)p1SolsArr[0]).value; length12 < 100; ++length12) {
                for (int i = 0; i < p1SolsArr.length && ((FullCube)p1SolsArr[i]).value <= length12; ++i) {
                    if (length12 - ((FullCube)p1SolsArr[i]).length1 > MAX_LENGTH2) continue;
                    this.c1.copy((FullCube)p1SolsArr[i]);
                    this.ct2.set(this.c1.getCenter(), this.c1.getEdge().getParity());
                    int s2ct = this.ct2.getct();
                    int s2rl = this.ct2.getrl();
                    this.length1 = ((FullCube)p1SolsArr[i]).length1;
                    this.length2 = length12 - ((FullCube)p1SolsArr[i]).length1;
                    if (this.search2(s2ct, s2rl, this.length2, 28, 0)) break block2;
                }
            }
            ++MAX_LENGTH2;
        } while (length12 == 100);
        Arrays.sort(this.arr2, 0, this.arr2idx);
        int index = 0;
        int solcnt = 0;
        int MAX_LENGTH3 = 13;
        do {
            block5: for (length123 = this.arr2[0].value; length123 < 100; ++length123) {
                for (int i = 0; i < Math.min(this.arr2idx, 100) && this.arr2[i].value <= length123; ++i) {
                    if (length123 - this.arr2[i].length1 - this.arr2[i].length2 > MAX_LENGTH3) continue;
                    int eparity = this.e12.set(this.arr2[i].getEdge());
                    this.ct3.set(this.arr2[i].getCenter(), eparity ^ this.arr2[i].getCorner().getParity());
                    int ct = this.ct3.getct();
                    int edge = this.e12.get(10);
                    int prun = Edge3.getprun(this.e12.getsym());
                    int lm = 20;
                    if (prun > length123 - this.arr2[i].length1 - this.arr2[i].length2 || !this.search3(edge, ct, prun, length123 - this.arr2[i].length1 - this.arr2[i].length2, lm, 0)) continue;
                    ++solcnt;
                    index = i;
                    break block5;
                }
            }
            ++MAX_LENGTH3;
        } while (length123 == 100);
        FullCube solcube = new FullCube(this.arr2[index]);
        this.length1 = solcube.length1;
        this.length2 = solcube.length2;
        int length = length123 - this.length1 - this.length2;
        for (int i = 0; i < length; ++i) {
            solcube.move(Moves.move3std[this.move3[i]]);
        }
        String facelet = solcube.to333Facelet();
        String sol = this.search333.solution(facelet, 21, 1000000L, 500L, 0);
        int len333 = this.search333.length();
        if (sol.startsWith("Error")) {
            System.out.println(sol);
            System.out.println(solcube);
            System.out.println(facelet);
            throw new RuntimeException();
        }
        int[] sol333 = Util.tomove(sol);
        for (int i = 0; i < sol333.length; ++i) {
            solcube.move(sol333[i]);
        }
        this.solution = solcube.getMoveString(this.inverse_solution, this.with_rotation);
        this.totlen = this.length1 + this.length2 + length + len333;
    }

    public void calc(FullCube s) {
        this.c = s;
        this.doSearch();
    }

    boolean search1(int ct, int sym, int maxl, int lm, int depth) {
        if (ct == 0 && maxl < 5) {
            return maxl == 0 && this.init2(sym, lm);
        }
        block0: for (int axis = 0; axis < 27; axis += 3) {
            if (axis == lm || axis == lm - 9 || axis == lm - 18) continue;
            for (int power = 0; power < 3; ++power) {
                int m = axis + power;
                int ctx = Center1.ctsmv[ct][Center1.symmove[sym][m]];
                byte prun = Center1.csprun[ctx >>> 6];
                if (prun >= maxl) {
                    if (prun <= maxl) continue;
                    continue block0;
                }
                int symx = Center1.symmult[sym][ctx & 0x3F];
                this.move1[depth] = m;
                if (!this.search1(ctx >>>= 6, symx, maxl - 1, axis, depth + 1)) continue;
                return true;
            }
        }
        return false;
    }

    boolean init2(int sym, int lm) {
        FullCube next;
        this.c1.copy(this.c);
        for (int i = 0; i < this.length1; ++i) {
            this.c1.move(this.move1[i]);
        }
        switch (Center1.finish[sym]) {
            case 0: {
                this.c1.move(24);
                this.c1.move(35);
                this.move1[this.length1] = 24;
                this.move1[this.length1 + 1] = 35;
                this.add1 = true;
                sym = 19;
                break;
            }
            case 12869: {
                this.c1.move(18);
                this.c1.move(29);
                this.move1[this.length1] = 18;
                this.move1[this.length1 + 1] = 29;
                this.add1 = true;
                sym = 34;
                break;
            }
            case 735470: {
                this.add1 = false;
                sym = 0;
            }
        }
        this.ct2.set(this.c1.getCenter(), this.c1.getEdge().getParity());
        int s2ct = this.ct2.getct();
        int s2rl = this.ct2.getrl();
        byte ctp = Center2.ctprun[s2ct * 70 + s2rl];
        this.c1.value = ctp + this.length1;
        this.c1.length1 = this.length1;
        this.c1.add1 = this.add1;
        this.c1.sym = sym;
        ++this.p1SolsCnt;
        if (this.p1sols.size() < 500) {
            next = new FullCube(this.c1);
        } else {
            next = this.p1sols.poll();
            if (next.value > this.c1.value) {
                next.copy(this.c1);
            }
        }
        this.p1sols.add(next);
        return this.p1SolsCnt == 10000;
    }

    boolean search2(int ct, int rl, int maxl, int lm, int depth) {
        if (ct == 0 && Center2.ctprun[rl] == 0 && maxl == 0) {
            return maxl == 0 && this.init3();
        }
        for (int m = 0; m < 23; ++m) {
            if (Moves.ckmv2[lm][m]) {
                m = Moves.skipAxis2[m];
                continue;
            }
            char ctx = Center2.ctmv[ct][m];
            int rlx = Center2.rlmv[rl][m];
            byte prun = Center2.ctprun[ctx * 70 + rlx];
            if (prun >= maxl) {
                if (prun <= maxl) continue;
                m = Moves.skipAxis2[m];
                continue;
            }
            this.move2[depth] = Moves.move2std[m];
            if (!this.search2(ctx, rlx, maxl - 1, m, depth + 1)) continue;
            return true;
        }
        return false;
    }

    boolean init3() {
        this.c2.copy(this.c1);
        for (int i = 0; i < this.length2; ++i) {
            this.c2.move(this.move2[i]);
        }
        if (!this.c2.checkEdge()) {
            return false;
        }
        int eparity = this.e12.set(this.c2.getEdge());
        this.ct3.set(this.c2.getCenter(), eparity ^ this.c2.getCorner().getParity());
        int ct = this.ct3.getct();
        int edge = this.e12.get(10);
        int prun = Edge3.getprun(this.e12.getsym());
        if (this.arr2[this.arr2idx] == null) {
            this.arr2[this.arr2idx] = new FullCube(this.c2);
        } else {
            this.arr2[this.arr2idx].copy(this.c2);
        }
        this.arr2[this.arr2idx].value = this.length1 + this.length2 + Math.max(prun, Center3.prun[ct]);
        this.arr2[this.arr2idx].length2 = this.length2;
        ++this.arr2idx;
        return this.arr2idx == this.arr2.length;
    }

    public boolean search3(int edge, int ct, int prun, int maxl, int lm, int depth) {
        if (maxl == 0) {
            return edge == 0 && ct == 0;
        }
        this.tempe[depth].set(edge);
        for (int m = 0; m < 17; ++m) {
            int symx;
            int cord2x;
            int prunx;
            if (Moves.ckmv3[lm][m]) {
                m = Moves.skipAxis3[m];
                continue;
            }
            char ctx = Center3.ctmove[ct][m];
            byte prun1 = Center3.prun[ctx];
            if (prun1 >= maxl) {
                if (prun1 <= maxl || m >= 14) continue;
                m = Moves.skipAxis3[m];
                continue;
            }
            int edgex = Edge3.getmvrot(this.tempe[depth].edge, m << 3, 10);
            int cord1x = edgex / 20160;
            int symcord1x = Edge3.raw2sym[cord1x];
            if ((prunx = Edge3.getprun((symcord1x >>= 3) * 20160 + (cord2x = Edge3.getmvrot(this.tempe[depth].edge, m << 3 | (symx = symcord1x & 7), 10) % 20160), prun)) >= maxl) {
                if (prunx <= maxl || m >= 14) continue;
                m = Moves.skipAxis3[m];
                continue;
            }
            if (!this.search3(edgex, ctx, prunx, maxl - 1, m, depth + 1)) continue;
            this.move3[depth] = m;
            return true;
        }
        return false;
    }
}

