/*
 * Decompiled with CFR 0.152.
 */
package cs.threephase;

import cs.threephase.Center1;
import cs.threephase.Center2;
import cs.threephase.Center3;
import cs.threephase.Edge3;
import cs.threephase.FullCube;
import cs.threephase.Search;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tools {
    private static Logger logger = LoggerFactory.getLogger(Tools.class);
    static Random r = new Random();

    private static void read(int[] arr, DataInput in) throws IOException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readInt();
        }
    }

    private static void write(int[] arr, DataOutput out) throws IOException {
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            out.writeInt(arr[i]);
        }
    }

    private static void read(int[][] arr, DataInput in) throws IOException {
        int leng = arr.length;
        for (int i = 0; i < leng; ++i) {
            int len = arr[i].length;
            for (int j = 0; j < len; ++j) {
                arr[i][j] = in.readInt();
            }
        }
    }

    private static void write(int[][] arr, DataOutput out) throws IOException {
        int leng = arr.length;
        for (int i = 0; i < leng; ++i) {
            int len = arr[i].length;
            for (int j = 0; j < len; ++j) {
                out.writeInt(arr[i][j]);
            }
        }
    }

    public static String randomCube() {
        return Tools.randomCube(r);
    }

    public static String randomCube(Random r) {
        FullCube c = new FullCube(r);
        byte[] f = new byte[96];
        c.toFacelet(f);
        StringBuffer sb = new StringBuffer();
        for (byte i : f) {
            sb.append("URFDLB".charAt(i));
        }
        return sb.toString();
    }

    public static synchronized void initFrom(DataInput in) throws IOException {
        if (Search.inited) {
            return;
        }
        logger.info("Initialize Center1 Solver...");
        Center1.initSym();
        Center1.initSym2Raw();
        Tools.read(Center1.ctsmv, in);
        Center1.createPrun();
        logger.info("Initialize Center2 Solver...");
        Center2.init();
        logger.info("Initialize Center3 Solver...");
        Center3.init();
        logger.info("Initialize Edge3 Solver...");
        Edge3.initMvrot();
        Edge3.initRaw2Sym();
        Tools.read(Edge3.eprun, in);
        Edge3.done = 31006080;
        logger.info("OK");
        Search.inited = true;
    }

    public static synchronized void saveTo(DataOutput out) throws IOException {
        if (!Search.inited) {
            Search.init();
        }
        Tools.write(Center1.ctsmv, out);
        Tools.write(Edge3.eprun, out);
    }
}

