/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.rmi;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import org.apache.zookeeper.CreateMode;
import org.wowtools.rmi.ZookeeperUtil;

public class RmiPublisher {
    public static final String ZK_REGISTRY_PATH = "/catRmiService";
    private final String url;
    private ZookeeperUtil zku;

    public RmiPublisher(String localUrl, int port, String zkUrl, Integer zkSessionTimeOut) {
        block2: {
            this(localUrl, port);
            this.zku = new ZookeeperUtil(zkUrl, zkSessionTimeOut);
            try {
                this.zku.createNode(ZK_REGISTRY_PATH, null, CreateMode.PERSISTENT);
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("NodeExists") >= 0) break block2;
                throw e;
            }
        }
    }

    public RmiPublisher(int port) {
        this("localhost", port);
    }

    public RmiPublisher(String localUrl, int port) {
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.url = localUrl + ":" + port;
    }

    public void publish(String name, Remote servie) {
        block4: {
            try {
                block5: {
                    Naming.bind("rmi://" + this.url + "/" + name, servie);
                    if (null == this.zku) break block4;
                    try {
                        this.zku.createNode("/catRmiService/" + name, null, CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        if (e.getMessage().indexOf("NodeExists") >= 0) break block5;
                        throw e;
                    }
                }
                this.zku.createNode("/catRmiService/" + name + "/s", this.url.getBytes(), CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

