/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.mvt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.wowtools.giscat.vector.mvt.MvtCoordinateConvertor;
import org.wowtools.giscat.vector.mvt.MvtFeature;
import org.wowtools.giscat.vector.mvt.MvtLayer;
import org.wowtools.giscat.vector.mvt.VectorTile;
import org.wowtools.giscat.vector.util.analyse.Bbox;
import org.wowtools.giscat.vector.util.analyse.TileClip;
import org.wowtools.giscat.vector.util.cst.Tile2Wgs84;

public class MvtBuilder {
    protected final int extent;
    @NotNull
    protected final TileClip tileClip;
    @NotNull
    private final MvtCoordinateConvertor mvtCoordinateConvertor;
    private final Map<String, MvtLayer> layers = new LinkedHashMap<String, MvtLayer>();
    @NotNull
    private final Bbox bbox;
    private int x = 0;
    private int y = 0;

    public MvtBuilder(byte z, int x, int y, @NotNull GeometryFactory geometryFactory) {
        this(z, x, y, 4096, 8, geometryFactory);
    }

    public MvtBuilder(byte z, int x, int y, int extent, int clipBuffer, @NotNull GeometryFactory geometryFactory) {
        this.extent = extent;
        this.bbox = MvtBuilder.createTileBbox(z, x, y, extent, clipBuffer);
        this.tileClip = new TileClip(this.bbox.xmin, this.bbox.ymin, this.bbox.xmax, this.bbox.ymax, geometryFactory);
        this.mvtCoordinateConvertor = new MvtCoordinateConvertor(z, x, y);
    }

    public MvtLayer createLayer(String layerName, int simplifyDistance) {
        MvtLayer layer = new MvtLayer(this, simplifyDistance);
        this.layers.put(layerName, layer);
        return layer;
    }

    public MvtLayer createLayer(String layerName) {
        return this.createLayer(layerName, 0);
    }

    @NotNull
    public MvtLayer getOrCreateLayer(String layerName, int simplifyDistance) {
        MvtLayer layer = this.layers.get(layerName);
        if (layer != null) {
            return layer;
        }
        return this.createLayer(layerName, simplifyDistance);
    }

    @NotNull
    public MvtLayer getOrCreateLayer(String layerName) {
        MvtLayer layer = this.layers.get(layerName);
        if (layer != null) {
            return layer;
        }
        return this.createLayer(layerName, 0);
    }

    @NotNull
    private static Bbox createTileBbox(byte z, int tileX, int tileY, int extent, int clipBuffer) {
        double x0 = Tile2Wgs84.tileX2lon((int)tileX, (byte)z);
        double y0 = Tile2Wgs84.tileY2lat((int)tileY, (byte)z);
        double x1 = Tile2Wgs84.tileX2lon((int)(tileX + 1), (byte)z);
        double y1 = Tile2Wgs84.tileY2lat((int)(tileY + 1), (byte)z);
        double dx = (x1 - x0) / (double)extent;
        double clipBufferX = dx * (double)clipBuffer;
        double dy = (y0 - y1) / (double)extent;
        double clipBufferY = dy * (double)clipBuffer;
        return new Bbox(x0 -= clipBufferX, y1 -= clipBufferY, x1 += clipBufferX, y0 += clipBufferY);
    }

    public Bbox getBbox() {
        return this.bbox;
    }

    public byte[] toBytes() {
        VectorTile.Tile.Builder tile = VectorTile.Tile.newBuilder();
        this.layers.forEach((layerName, layer) -> {
            VectorTile.Tile.Layer.Builder tileLayer = VectorTile.Tile.Layer.newBuilder();
            tileLayer.setVersion(2);
            tileLayer.setName((String)layerName);
            tileLayer.addAllKeys(layer.keys());
            for (Object value : layer.values()) {
                VectorTile.Tile.Value.Builder tileValue = VectorTile.Tile.Value.newBuilder();
                if (value instanceof String) {
                    tileValue.setStringValue((String)value);
                } else if (value instanceof Integer) {
                    tileValue.setSintValue(((Integer)value).intValue());
                } else if (value instanceof Long) {
                    tileValue.setSintValue((Long)value);
                } else if (value instanceof Float) {
                    tileValue.setFloatValue(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    tileValue.setDoubleValue((Double)value);
                } else if (value instanceof Boolean) {
                    tileValue.setBoolValue((Boolean)value);
                } else {
                    tileValue.setStringValue(value.toString());
                }
                tileLayer.addValues(tileValue.build());
            }
            tileLayer.setExtent(this.extent);
            for (MvtFeature feature : layer.features) {
                Geometry geometry = feature.geometry;
                VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
                if (null != feature.tags) {
                    featureBuilder.addAllTags(feature.tags);
                }
                VectorTile.Tile.GeomType geomType = MvtBuilder.toGeomType(geometry);
                this.x = 0;
                this.y = 0;
                List<Integer> commands = this.commands(geometry);
                featureBuilder.setType(geomType);
                featureBuilder.addAllGeometry(commands);
                tileLayer.addFeatures(featureBuilder.build());
            }
            tile.addLayers(tileLayer.build());
        });
        return tile.build().toByteArray();
    }

    private static  @NotNull VectorTile.Tile.GeomType toGeomType(Geometry geometry) {
        if (geometry instanceof Point) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof MultiPoint) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof LineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof MultiLineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof Polygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        return VectorTile.Tile.GeomType.UNKNOWN;
    }

    List<Integer> commands(Geometry geometry) {
        if (geometry instanceof MultiLineString) {
            return this.commands((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.commands((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.commands((MultiPolygon)geometry);
        }
        return this.commands(geometry.getCoordinates(), MvtBuilder.shouldClosePath(geometry), geometry instanceof MultiPoint);
    }

    @NotNull
    List<Integer> commands(@NotNull MultiLineString mls) {
        ArrayList<Integer> commands = new ArrayList<Integer>();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            commands.addAll(this.commands(mls.getGeometryN(i).getCoordinates(), false));
        }
        return commands;
    }

    @NotNull
    List<Integer> commands(@NotNull MultiPolygon mp) {
        ArrayList<Integer> commands = new ArrayList<Integer>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)mp.getGeometryN(i);
            commands.addAll(this.commands(polygon));
        }
        return commands;
    }

    @NotNull
    List<Integer> commands(@NotNull Polygon polygon) {
        LineString exteriorRing = polygon.getExteriorRing();
        if (!Orientation.isCCW((Coordinate[])exteriorRing.getCoordinates())) {
            exteriorRing = (LineString)exteriorRing.reverse();
        }
        ArrayList<Integer> commands = new ArrayList<Integer>(this.commands(exteriorRing.getCoordinates(), true));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LineString interiorRing = polygon.getInteriorRingN(i);
            if (Orientation.isCCW((Coordinate[])interiorRing.getCoordinates())) {
                interiorRing = (LineString)interiorRing.reverse();
            }
            commands.addAll(this.commands(interiorRing.getCoordinates(), true));
        }
        return commands;
    }

    List<Integer> commands(Coordinate @NotNull [] cs, boolean closePathAtEnd) {
        return this.commands(cs, closePathAtEnd, false);
    }

    @NotNull
    List<Integer> commands(Coordinate @NotNull [] cs, boolean closePathAtEnd, boolean multiPoint) {
        if (cs.length == 0) {
            throw new IllegalArgumentException("empty geometry");
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        int lineToIndex = 0;
        int lineToLength = 0;
        for (int i = 0; i < cs.length; ++i) {
            Coordinate c = cs[i];
            double cx = this.mvtCoordinateConvertor.wgs84X2mvt(c.x);
            double cy = this.mvtCoordinateConvertor.wgs84Y2mvt(c.y);
            if (i == 0) {
                r.add(MvtBuilder.commandAndLength(1, multiPoint ? cs.length : 1));
            }
            int _x = (int)Math.round(cx);
            int _y = (int)Math.round(cy);
            if (i > 0 && _x == this.x && _y == this.y) {
                --lineToLength;
                continue;
            }
            if (closePathAtEnd && cs.length > 1 && i == cs.length - 1 && cs[0].equals((Object)c)) {
                --lineToLength;
                continue;
            }
            r.add(MvtBuilder.zigZagEncode(_x - this.x));
            r.add(MvtBuilder.zigZagEncode(_y - this.y));
            this.x = _x;
            this.y = _y;
            if (i != 0 || cs.length <= 1 || multiPoint) continue;
            lineToIndex = r.size();
            lineToLength = cs.length - 1;
            r.add(MvtBuilder.commandAndLength(2, lineToLength));
        }
        if (lineToIndex > 0) {
            if (lineToLength == 0) {
                r.remove(lineToIndex);
            } else {
                r.set(lineToIndex, MvtBuilder.commandAndLength(2, lineToLength));
            }
        }
        if (closePathAtEnd) {
            r.add(MvtBuilder.commandAndLength(7, 1));
        }
        return r;
    }

    static int commandAndLength(int command, int repeat) {
        return repeat << 3 | command;
    }

    static int zigZagEncode(int n) {
        return n << 1 ^ n >> 31;
    }

    static boolean shouldClosePath(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof LinearRing;
    }
}

