/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.mvt;

import org.jetbrains.annotations.NotNull;

class MvtCoordinateConvertor {
    private static final short TILE_SIZE = 256;
    private static final long @NotNull [] zoomPow;
    private final double px;
    private final double py;
    private final long zoomMultiple;

    public MvtCoordinateConvertor(byte z, int x, int y) {
        this.px = x * 256;
        this.py = y * 256;
        this.zoomMultiple = zoomPow[z];
    }

    public int wgs84X2mvt(double x) {
        double ppx = (x + 180.0) / 360.0 * (double)this.zoomMultiple;
        return (int)((ppx - this.px) * 16.0 + Math.sin(x) + 0.5);
    }

    public int wgs84Y2mvt(double y) {
        double sinLatitude = Math.sin(y * Math.PI / 180.0);
        double mp = Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude));
        double ppy = (0.5 - mp / (Math.PI * 4)) * (double)this.zoomMultiple;
        return (int)((ppy - this.py) * 16.0 + Math.cos(y) + 0.5);
    }

    public double mvtX2wgs84(double pixelX) {
        double ppx = pixelX / 16.0 + this.px;
        return ppx / (double)this.zoomMultiple * 360.0 - 180.0;
    }

    public double mvtY2wgs84(double pixelY) {
        double ppy = pixelY / 16.0 + this.py;
        double mp = (0.5 - ppy / (double)this.zoomMultiple) * (Math.PI * 4);
        double exp = Math.exp(mp);
        double sinLatitude = (exp - 1.0) / (exp + 1.0);
        return Math.asin(sinLatitude) * 180.0 / Math.PI;
    }

    static {
        int n = 30;
        zoomPow = new long[n];
        long s = 256L;
        for (int i = 0; i < n; ++i) {
            MvtCoordinateConvertor.zoomPow[i] = s;
            s *= 2L;
        }
    }
}

