/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.mvt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.wowtools.giscat.vector.mvt.MvtBuilder;
import org.wowtools.giscat.vector.mvt.MvtFeature;
import org.wowtools.giscat.vector.pojo.Feature;
import org.wowtools.giscat.vector.util.analyse.Bbox;

public final class MvtLayer {
    protected final List<MvtFeature> features = new LinkedList<MvtFeature>();
    private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
    private final Map<Object, Integer> values = new LinkedHashMap<Object, Integer>();
    private final MvtBuilder mvtBuilder;
    private final double wgs84SimplifyDistance;

    protected MvtLayer(@NotNull MvtBuilder mvtBuilder, int simplifyDistance) {
        this.mvtBuilder = mvtBuilder;
        if (simplifyDistance > 0) {
            Bbox bbox = mvtBuilder.getBbox();
            double d = Math.sqrt(Math.pow(bbox.xmax - bbox.xmin, 2.0) + Math.pow(bbox.ymax - bbox.ymin, 2.0)) / (double)mvtBuilder.extent;
            this.wgs84SimplifyDistance = (double)simplifyDistance * d;
        } else {
            this.wgs84SimplifyDistance = 0.0;
        }
    }

    public void addFeatures(@NotNull Iterable<Feature> features) {
        for (Feature feature : features) {
            this.addFeature(feature);
        }
    }

    public void addClipedFeatures(@NotNull Iterable<Feature> features) {
        for (Feature feature : features) {
            this.addClipedFeature(feature);
        }
    }

    public void addFeature(@NotNull Feature feature) {
        Geometry clipedGeometry = this.clipGeometry(feature.getGeometry());
        this.addCipedGeometryAndAttributes(feature.getProperties(), clipedGeometry);
    }

    public void addClipedFeature(@NotNull Feature feature) {
        this.addCipedGeometryAndAttributes(feature.getProperties(), feature.getGeometry());
    }

    public void addCipedGeometryAndAttributes(Map<String, ?> attributes, @Nullable Geometry clipedGeometry) {
        if (null == clipedGeometry || clipedGeometry.isEmpty()) {
            return;
        }
        if (this.wgs84SimplifyDistance > 0.0) {
            clipedGeometry = TopologyPreservingSimplifier.simplify((Geometry)clipedGeometry, (double)this.wgs84SimplifyDistance);
        }
        ArrayList<Integer> tags = this.tags(attributes);
        LinkedList<Geometry> resolveGeometries = new LinkedList<Geometry>();
        this.resolveGeometryCollection(clipedGeometry, resolveGeometries);
        for (Geometry resolveGeometry : resolveGeometries) {
            this.addSampleGeometryFeature(tags, resolveGeometry);
        }
    }

    private void resolveGeometryCollection(@NotNull Geometry geometry, @NotNull List<Geometry> resolveGeometries) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeometry = geometry.getGeometryN(i);
            if (subGeometry.getClass().equals(GeometryCollection.class)) {
                this.resolveGeometryCollection(subGeometry, resolveGeometries);
                continue;
            }
            resolveGeometries.add(subGeometry);
        }
    }

    private void addSampleGeometryFeature(ArrayList<Integer> tags, Geometry geometry) {
        MvtFeature feature = new MvtFeature();
        feature.geometry = geometry;
        feature.tags = tags;
        this.features.add(feature);
    }

    private ArrayList<Integer> tags(@Nullable Map<String, ?> attributes) {
        if (null == attributes) {
            return null;
        }
        ArrayList<Integer> tags = new ArrayList<Integer>(attributes.size() * 2);
        for (Map.Entry<String, ?> e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            tags.add(this.key(e.getKey()));
            tags.add(this.value(e.getValue()));
        }
        return tags;
    }

    @NotNull
    private Integer key(String key) {
        return this.keys.computeIfAbsent(key, k -> this.keys.size());
    }

    @NotNull
    protected Set<String> keys() {
        return this.keys.keySet();
    }

    @NotNull
    private Integer value(Object value) {
        return this.values.computeIfAbsent(value, k -> this.values.size());
    }

    protected Set<Object> values() {
        return this.values.keySet();
    }

    private Geometry clipGeometry(Geometry geometry) {
        try {
            return this.mvtBuilder.tileClip.intersection(geometry);
        }
        catch (TopologyException e) {
            geometry = geometry.buffer(0.0);
            return this.mvtBuilder.tileClip.intersection(geometry);
        }
    }
}

