/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.mvt;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.wowtools.giscat.vector.mvt.MvtCoordinateConvertor;
import org.wowtools.giscat.vector.mvt.VectorTile;
import org.wowtools.giscat.vector.pojo.Feature;

public class MvtParser {
    public static MvtFeatureLayer @NotNull [] parse2TileCoords(byte[] data, @NotNull GeometryFactory gf) {
        return MvtParser.parse(null, data, gf);
    }

    public static MvtFeatureLayer @NotNull [] parse2Wgs84Coords(byte z, int x, int y, byte[] data, @NotNull GeometryFactory gf) {
        MvtCoordinateConvertor mvtCoordinateConvertor = new MvtCoordinateConvertor(z, x, y);
        return MvtParser.parse(mvtCoordinateConvertor, data, gf);
    }

    private static MvtFeatureLayer @NotNull [] parse(MvtCoordinateConvertor mvtCoordinateConvertor, byte[] data, @NotNull GeometryFactory gf) {
        VectorTile.Tile tile;
        try {
            tile = VectorTile.Tile.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("\u89e3\u6790 bytes \u51fa\u9519", e);
        }
        MvtFeatureLayer[] layers = new MvtFeatureLayer[tile.getLayersCount()];
        int i = 0;
        for (VectorTile.Tile.Layer pLayer : tile.getLayersList()) {
            layers[i] = new MvtFeatureLayer(pLayer, gf, mvtCoordinateConvertor);
            ++i;
        }
        return layers;
    }

    private static int zigZagDecode(int n) {
        return n >> 1 ^ -(n & 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Feature parseFeature( @NotNull VectorTile.Tile.Feature pFeature, String[] keys, Object[] values, @NotNull GeometryFactory gf, @Nullable MvtCoordinateConvertor mvtCoordinateConvertor) {
        int tagsCount = pFeature.getTagsCount();
        HashMap<String, Object> attributes = new HashMap<String, Object>(tagsCount / 2);
        int tagIdx = 0;
        while (tagIdx < pFeature.getTagsCount()) {
            String key = keys[pFeature.getTags(tagIdx++)];
            Object value = values[pFeature.getTags(tagIdx++)];
            attributes.put(key, value);
        }
        int x = 0;
        int y = 0;
        LinkedList coordsList = new LinkedList();
        LinkedList<Coordinate> coords = null;
        int geometryCount = pFeature.getGeometryCount();
        int length = 0;
        int command = 0;
        int i = 0;
        while (i < geometryCount) {
            Coordinate coord;
            if (length <= 0) {
                length = pFeature.getGeometry(i++);
                command = length & 7;
                length >>= 3;
            }
            if (length <= 0) continue;
            if (command == 1) {
                coords = new LinkedList<Coordinate>();
                coordsList.add(coords);
            }
            if (command == 7) {
                if (pFeature.getType() != VectorTile.Tile.GeomType.POINT && null != coords && !coords.isEmpty()) {
                    coords.add((Coordinate)coords.getFirst());
                }
                --length;
                continue;
            }
            int dx = pFeature.getGeometry(i++);
            int dy = pFeature.getGeometry(i++);
            --length;
            dx = MvtParser.zigZagDecode(dx);
            dy = MvtParser.zigZagDecode(dy);
            x += dx;
            y += dy;
            if (null != mvtCoordinateConvertor) {
                double d = mvtCoordinateConvertor.mvtX2wgs84(x);
                double wgs84Y = mvtCoordinateConvertor.mvtY2wgs84(y);
                coord = new Coordinate(d, wgs84Y);
            } else {
                coord = new Coordinate((double)x, (double)y);
            }
            coords.add(coord);
        }
        GeometryCollection geometry = null;
        switch (pFeature.getType()) {
            case LINESTRING: {
                ArrayList<LineString> lineStrings = new ArrayList<LineString>();
                for (List list : coordsList) {
                    if (list.size() <= 1) continue;
                    lineStrings.add(gf.createLineString(list.toArray(new Coordinate[list.size()])));
                }
                if (lineStrings.size() == 1) {
                    geometry = (Geometry)lineStrings.get(0);
                    break;
                }
                if (lineStrings.size() <= 1) break;
                geometry = gf.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
                break;
            }
            case POINT: {
                ArrayList allCoords = new ArrayList();
                for (List list : coordsList) {
                    allCoords.addAll(list);
                }
                if (allCoords.size() == 1) {
                    geometry = gf.createPoint((Coordinate)allCoords.get(0));
                    break;
                }
                if (allCoords.size() <= 1) break;
                geometry = gf.createMultiPointFromCoords(allCoords.toArray(new Coordinate[allCoords.size()]));
                break;
            }
            case POLYGON: {
                void var20_31;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (List list : coordsList) {
                    if (var20_31.size() > 0 && list.size() < 4 || list.size() < 4) continue;
                    LinearRing linearRing = gf.createLinearRing(list.toArray(new Coordinate[list.size()]));
                    if (Orientation.isCCW((Coordinate[])linearRing.getCoordinates())) {
                        ArrayList arrayList3 = new ArrayList();
                        arrayList.add(arrayList3);
                    }
                    var20_31.add(linearRing);
                }
                if (arrayList.size() == 0 && var20_31.size() > 0) {
                    LinearRing shell = (LinearRing)var20_31.get(0);
                    geometry = gf.createPolygon(shell);
                    break;
                }
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (List list : arrayList) {
                    LinearRing shell = (LinearRing)list.get(0);
                    LinearRing[] holes = list.subList(1, list.size()).toArray(new LinearRing[list.size() - 1]);
                    polygons.add(gf.createPolygon(shell, holes));
                }
                if (polygons.size() == 1) {
                    geometry = (Geometry)polygons.get(0);
                }
                if (polygons.size() <= 1) break;
                geometry = gf.createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
                break;
            }
        }
        if (geometry == null) {
            geometry = gf.createGeometryCollection(new Geometry[0]);
        }
        return new Feature((Geometry)geometry, Collections.unmodifiableMap(attributes));
    }

    public static final class MvtFeatureLayer {
        private final String layerName;
        private final int extent;
        private final Feature @NotNull [] features;

        private MvtFeatureLayer( @NotNull VectorTile.Tile.Layer pLayer, @NotNull GeometryFactory gf, MvtCoordinateConvertor mvtCoordinateConvertor) {
            this.layerName = pLayer.getName();
            this.extent = pLayer.getExtent();
            ProtocolStringList pKeys = pLayer.getKeysList();
            String[] keys = new String[pKeys.size()];
            pKeys.toArray(keys);
            List<VectorTile.Tile.Value> pValueList = pLayer.getValuesList();
            Object[] values = new Object[pValueList.size()];
            int i = 0;
            for (VectorTile.Tile.Value value : pValueList) {
                if (value.hasBoolValue()) {
                    values[i] = value.getBoolValue();
                } else if (value.hasDoubleValue()) {
                    values[i] = value.getDoubleValue();
                } else if (value.hasFloatValue()) {
                    values[i] = Float.valueOf(value.getFloatValue());
                } else if (value.hasIntValue()) {
                    values[i] = value.getIntValue();
                } else if (value.hasSintValue()) {
                    values[i] = value.getSintValue();
                } else if (value.hasUintValue()) {
                    values[i] = value.getUintValue();
                } else if (value.hasStringValue()) {
                    values[i] = value.getStringValue();
                }
                ++i;
            }
            int i2 = 0;
            List<VectorTile.Tile.Feature> pFeatureList = pLayer.getFeaturesList();
            this.features = new Feature[pFeatureList.size()];
            for (VectorTile.Tile.Feature pFeature : pFeatureList) {
                this.features[i2] = MvtParser.parseFeature(pFeature, keys, values, gf, mvtCoordinateConvertor);
                ++i2;
            }
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getExtent() {
            return this.extent;
        }

        public Feature[] getFeatures() {
            return this.features;
        }
    }
}

