/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.pojo.converter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.wowtools.giscat.vector.pojo.Feature;
import org.wowtools.giscat.vector.pojo.FeatureCollection;
import org.wowtools.giscat.vector.pojo.GeoJsonObject;

public class GeoJsonFeatureConverter {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final JavaType typeGeometry;
    private static final JavaType typeFeature;
    private static final JavaType typeFeatureCollection;

    public static GeoJsonObject.Geometry geometry2GeoJson(@Nullable Geometry geometry) {
        if (null == geometry || geometry.isEmpty()) {
            return null;
        }
        if (geometry instanceof Point) {
            return new GeoJsonObject.Point((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return new GeoJsonObject.LineString((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return new GeoJsonObject.Polygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return new GeoJsonObject.MultiPoint((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return new GeoJsonObject.MultiLineString((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return new GeoJsonObject.MultiPolygon((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return new GeoJsonObject.GeometryCollection((GeometryCollection)geometry);
        }
        throw new RuntimeException("\u672a\u77e5\u7c7b\u578b " + geometry.getGeometryType());
    }

    public static  @NotNull GeoJsonObject.Feature toGeoJson(@NotNull Feature feature) {
        GeoJsonObject.Feature geoJsonFeature = new GeoJsonObject.Feature();
        geoJsonFeature.setGeometry(GeoJsonFeatureConverter.geometry2GeoJson(feature.getGeometry()));
        geoJsonFeature.setProperties(feature.getProperties());
        return geoJsonFeature;
    }

    public static  @NotNull GeoJsonObject.FeatureCollection toGeoJson(@NotNull FeatureCollection featureCollection) {
        GeoJsonObject.FeatureCollection geoJsonFeatureCollection = new GeoJsonObject.FeatureCollection();
        if (null != featureCollection.getHeaders()) {
            geoJsonFeatureCollection.setHeaders(featureCollection.getHeaders());
        }
        GeoJsonObject.Feature[] geoJsonFeatures = new GeoJsonObject.Feature[featureCollection.getFeatures().size()];
        int i = 0;
        for (Feature feature : featureCollection.getFeatures()) {
            geoJsonFeatures[i] = GeoJsonFeatureConverter.toGeoJson(feature);
            ++i;
        }
        geoJsonFeatureCollection.setFeatures(geoJsonFeatures);
        return geoJsonFeatureCollection;
    }

    @Nullable
    public static Geometry geoJson2Geometry(String strGeojsonGeometry, @NotNull GeometryFactory geometryFactory) {
        GeoJsonObject.Geometry geojsonGeometry;
        try {
            geojsonGeometry = (GeoJsonObject.Geometry)mapper.readValue(strGeojsonGeometry, typeGeometry);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return GeoJsonFeatureConverter.geoJson2Geometry(geojsonGeometry, geometryFactory);
    }

    public static Geometry geoJson2Geometry( @Nullable GeoJsonObject.Geometry geojsonGeometry, @NotNull GeometryFactory geometryFactory) {
        if (null == geojsonGeometry) {
            return null;
        }
        if (geojsonGeometry instanceof GeoJsonObject.Point) {
            return GeoJsonFeatureConverter.coords2Point(((GeoJsonObject.Point)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.LineString) {
            return GeoJsonFeatureConverter.coords2LineString(((GeoJsonObject.LineString)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.Polygon) {
            return GeoJsonFeatureConverter.coords2Polygon(((GeoJsonObject.Polygon)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.MultiPoint) {
            return GeoJsonFeatureConverter.coords2MultiPoint(((GeoJsonObject.MultiPoint)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.MultiLineString) {
            return GeoJsonFeatureConverter.coords2MultiLineString(((GeoJsonObject.MultiLineString)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.MultiPolygon) {
            return GeoJsonFeatureConverter.coords2MultiPolygon(((GeoJsonObject.MultiPolygon)geojsonGeometry).getCoordinates(), geometryFactory);
        }
        if (geojsonGeometry instanceof GeoJsonObject.GeometryCollection) {
            return GeoJsonFeatureConverter.toGeometryCollection((GeoJsonObject.GeometryCollection)geojsonGeometry, geometryFactory);
        }
        throw new RuntimeException("\u672a\u77e5\u7c7b\u578b " + geojsonGeometry.getType());
    }

    @NotNull
    public static Feature fromGeoJsonFeature(String strGeoJsonFeature, @NotNull GeometryFactory geometryFactory) {
        GeoJsonObject.Feature geoJsonFeature;
        try {
            geoJsonFeature = (GeoJsonObject.Feature)mapper.readValue(strGeoJsonFeature, typeFeature);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return GeoJsonFeatureConverter.fromGeoJsonFeature(geoJsonFeature, geometryFactory);
    }

    @NotNull
    public static Feature fromGeoJsonFeature( @NotNull GeoJsonObject.Feature geoJsonFeature, @NotNull GeometryFactory geometryFactory) {
        Geometry geometry = GeoJsonFeatureConverter.geoJson2Geometry(geoJsonFeature.getGeometry(), geometryFactory);
        return new Feature(geometry, geoJsonFeature.getProperties());
    }

    @NotNull
    public static FeatureCollection fromGeoJsonFeatureCollection(String strGeoJsonFeatureCollection, @NotNull GeometryFactory geometryFactory) {
        GeoJsonObject.FeatureCollection geoJsonFeatureCollection;
        try {
            geoJsonFeatureCollection = (GeoJsonObject.FeatureCollection)mapper.readValue(strGeoJsonFeatureCollection, typeFeatureCollection);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return GeoJsonFeatureConverter.fromGeoJsonFeatureCollection(geoJsonFeatureCollection, geometryFactory);
    }

    @NotNull
    public static FeatureCollection fromGeoJsonFeatureCollection( @NotNull GeoJsonObject.FeatureCollection geoJsonFeatureCollection, @NotNull GeometryFactory geometryFactory) {
        FeatureCollection featureCollection = new FeatureCollection();
        featureCollection.setHeaders(geoJsonFeatureCollection.getHeaders());
        ArrayList<Feature> features = new ArrayList<Feature>(geoJsonFeatureCollection.getFeatures().length);
        for (int i = 0; i < geoJsonFeatureCollection.getFeatures().length; ++i) {
            Feature feature = GeoJsonFeatureConverter.fromGeoJsonFeature(geoJsonFeatureCollection.getFeatures()[i], geometryFactory);
            features.add(feature);
        }
        featureCollection.setFeatures(features);
        return featureCollection;
    }

    private static Coordinate @NotNull [] coords2Coordinates(double[] @NotNull [] coords) {
        Coordinate[] coordinates = new Coordinate[coords.length];
        for (int i = 0; i < coordinates.length; ++i) {
            double[] xy = coords[i];
            coordinates[i] = new Coordinate(xy[0], xy[1]);
        }
        return coordinates;
    }

    private static LinearRing coords2Ring(double[] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = GeoJsonFeatureConverter.coords2Coordinates(coords);
        return geometryFactory.createLinearRing(coordinates);
    }

    private static Point coords2Point(double @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        return geometryFactory.createPoint(new Coordinate(coords[0], coords[1]));
    }

    private static LineString coords2LineString(double[] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = GeoJsonFeatureConverter.coords2Coordinates(coords);
        return geometryFactory.createLineString(coordinates);
    }

    private static Polygon coords2Polygon(double[][] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        LinearRing ring = GeoJsonFeatureConverter.coords2Ring(coords[0], geometryFactory);
        if (coords.length == 1) {
            return geometryFactory.createPolygon(ring);
        }
        LinearRing[] holes = new LinearRing[coords.length - 1];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = GeoJsonFeatureConverter.coords2Ring(coords[i + 1], geometryFactory);
        }
        return geometryFactory.createPolygon(ring, holes);
    }

    private static MultiPoint coords2MultiPoint(double[] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        Point[] points = new Point[coords.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = GeoJsonFeatureConverter.coords2Point(coords[i], geometryFactory);
        }
        return geometryFactory.createMultiPoint(points);
    }

    private static MultiLineString coords2MultiLineString(double[][] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        LineString[] subs = new LineString[coords.length];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = GeoJsonFeatureConverter.coords2LineString(coords[i], geometryFactory);
        }
        return geometryFactory.createMultiLineString(subs);
    }

    private static MultiPolygon coords2MultiPolygon(double[][][] @NotNull [] coords, @NotNull GeometryFactory geometryFactory) {
        Polygon[] subs = new Polygon[coords.length];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = GeoJsonFeatureConverter.coords2Polygon(coords[i], geometryFactory);
        }
        return geometryFactory.createMultiPolygon(subs);
    }

    private static GeometryCollection toGeometryCollection( @NotNull GeoJsonObject.GeometryCollection geometryCollection, @NotNull GeometryFactory geometryFactory) {
        Geometry[] geos = new Geometry[geometryCollection.getGeometries().length];
        for (int i = 0; i < geos.length; ++i) {
            GeoJsonObject.Geometry sub = geometryCollection.getGeometries()[i];
            if (sub instanceof GeoJsonObject.Point) {
                geos[i] = GeoJsonFeatureConverter.coords2Point(((GeoJsonObject.Point)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.LineString) {
                geos[i] = GeoJsonFeatureConverter.coords2LineString(((GeoJsonObject.LineString)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.Polygon) {
                geos[i] = GeoJsonFeatureConverter.coords2Polygon(((GeoJsonObject.Polygon)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.MultiPoint) {
                geos[i] = GeoJsonFeatureConverter.coords2MultiPoint(((GeoJsonObject.MultiPoint)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.MultiLineString) {
                geos[i] = GeoJsonFeatureConverter.coords2MultiLineString(((GeoJsonObject.MultiLineString)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.MultiPolygon) {
                geos[i] = GeoJsonFeatureConverter.coords2MultiPolygon(((GeoJsonObject.MultiPolygon)sub).getCoordinates(), geometryFactory);
                continue;
            }
            if (sub instanceof GeoJsonObject.GeometryCollection) {
                geos[i] = GeoJsonFeatureConverter.toGeometryCollection((GeoJsonObject.GeometryCollection)sub, geometryFactory);
                continue;
            }
            throw new RuntimeException("\u672a\u77e5\u7c7b\u578b " + sub.getType());
        }
        return geometryFactory.createGeometryCollection(geos);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        typeGeometry = mapper.constructType(GeoJsonObject.Geometry.class);
        typeFeature = mapper.constructType(GeoJsonObject.Feature.class);
        typeFeatureCollection = mapper.constructType(GeoJsonObject.FeatureCollection.class);
    }
}

