/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.pojo.converter;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.wowtools.giscat.vector.pojo.Feature;
import org.wowtools.giscat.vector.pojo.FeatureCollection;
import org.wowtools.giscat.vector.pojo.proto.ProtoFeature;

public class ProtoFeatureConverter {
    private static final int doubleValueIdsIndex = 2;
    private static final int floatValueIdsIndex = 3;
    private static final int sint32ValueIdsIndex = 4;
    private static final int sint64ValueIdsIndex = 5;
    private static final int boolValuesIndex = 6;
    private static final int stringValueIdsIndex = 7;
    private static final int bytesValueIdsIndex = 8;
    private static final int mapValuesIndex = 9;
    private static final int subListValuesIndex = 10;
    private static final ProtoFeature.NullGeometry nullGeometry = ProtoFeature.NullGeometry.getDefaultInstance();
    private static final ProtoFeature.Map nullMap = ProtoFeature.Map.newBuilder().build();
    private static final Descriptors.FieldDescriptor FieldDescriptor_Point_z = ProtoFeature.Point.getDescriptor().findFieldByNumber(3);
    @NotNull
    private static final Map<Class, PropertiesSetter> propertiesSetterMap;
    @NotNull
    private static final PropertiesSetter listPropertiesSetter;
    @NotNull
    private static final PropertiesSetter mapPropertiesSetter;

    public static byte[] geometry2Proto(Geometry geometry) {
        return ProtoFeatureConverter.geometry2ProtoBuilder(geometry).build().toByteArray();
    }

    private static  @NotNull ProtoFeature.Geometry.Builder geometry2ProtoBuilder(@Nullable Geometry geometry) {
        ProtoFeature.Geometry.Builder geometryBuilder = ProtoFeature.Geometry.newBuilder();
        if (null == geometry || geometry.isEmpty()) {
            geometryBuilder.setNullGeometry(nullGeometry);
        } else if (geometry instanceof Point) {
            geometryBuilder.setPoint(ProtoFeatureConverter.point2Proto((Point)geometry));
        } else if (geometry instanceof LineString) {
            geometryBuilder.setLineString(ProtoFeatureConverter.lineString2Proto((LineString)geometry));
        } else if (geometry instanceof Polygon) {
            geometryBuilder.setPolygon(ProtoFeatureConverter.polygon2Proto((Polygon)geometry));
        } else if (geometry instanceof MultiPoint) {
            geometryBuilder.setMultiPoint(ProtoFeatureConverter.multiPoint2Proto((MultiPoint)geometry));
        } else if (geometry instanceof MultiLineString) {
            geometryBuilder.setMultiLineString(ProtoFeatureConverter.multiLineString2Proto((MultiLineString)geometry));
        } else if (geometry instanceof MultiPolygon) {
            geometryBuilder.setMultiPolygon(ProtoFeatureConverter.multiPolygon2Proto((MultiPolygon)geometry));
        } else if (geometry instanceof GeometryCollection) {
            geometryBuilder.setGeometryCollection(ProtoFeatureConverter.geometryCollection2Proto((GeometryCollection)geometry));
        } else {
            throw new RuntimeException("\u672a\u5b9e\u73b0\u7684geometry\u7c7b\u578b " + geometry.getClass());
        }
        return geometryBuilder;
    }

    private static  @NotNull ProtoFeature.Point.Builder point2Proto(@NotNull Point point) {
        Coordinate coordinate = point.getCoordinate();
        ProtoFeature.Point.Builder builder = ProtoFeature.Point.newBuilder();
        builder.setX(coordinate.getX());
        builder.setY(coordinate.getY());
        if (!Double.isNaN(coordinate.getZ())) {
            builder.setZ(coordinate.getZ());
        }
        return builder;
    }

    private static  @NotNull ProtoFeature.LineString.Builder lineString2Proto(@NotNull LineString lineString) {
        ProtoFeature.LineString.Builder builder = ProtoFeature.LineString.newBuilder();
        Coordinate[] coordinates = lineString.getCoordinates();
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static  @NotNull ProtoFeature.Polygon.Builder polygon2Proto(@NotNull Polygon polygon) {
        ProtoFeature.Polygon.Builder builder = ProtoFeature.Polygon.newBuilder();
        LinkedList<Integer> separators = new LinkedList<Integer>();
        int holeNum = polygon.getNumInteriorRing();
        Coordinate[] coordinates = new Coordinate[polygon.getNumPoints() - 1 - holeNum];
        int k = -1;
        Coordinate[] shellCoordinates = polygon.getExteriorRing().getCoordinates();
        for (int x = 0; x < shellCoordinates.length - 1; ++x) {
            coordinates[++k] = shellCoordinates[x];
        }
        if (holeNum > 0) {
            separators.add(k);
            for (int i = 0; i < holeNum; ++i) {
                Coordinate[] childCoordinates = polygon.getInteriorRingN(i).getCoordinates();
                for (int j = 0; j < childCoordinates.length - 1; ++j) {
                    coordinates[++k] = childCoordinates[j];
                }
                if (i >= holeNum - 1) continue;
                separators.add(k);
            }
        }
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        builder.addAllSeparators(separators);
        return builder;
    }

    private static  @NotNull ProtoFeature.MultiPoint.Builder multiPoint2Proto(@NotNull MultiPoint multiPoint) {
        ProtoFeature.MultiPoint.Builder builder = ProtoFeature.MultiPoint.newBuilder();
        Coordinate[] coordinates = multiPoint.getCoordinates();
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static  @NotNull ProtoFeature.MultiLineString.Builder multiLineString2Proto(@NotNull MultiLineString multiLineString) {
        ProtoFeature.MultiLineString.Builder builder = ProtoFeature.MultiLineString.newBuilder();
        LinkedList<Integer> separators = new LinkedList<Integer>();
        int lineNum = multiLineString.getNumGeometries();
        Coordinate[] coordinates = new Coordinate[multiLineString.getNumPoints()];
        int k = -1;
        for (int i = 0; i < lineNum; ++i) {
            Coordinate[] childCoordinates;
            for (Coordinate childCoordinate : childCoordinates = multiLineString.getGeometryN(i).getCoordinates()) {
                coordinates[++k] = childCoordinate;
            }
            if (i >= lineNum - 1) continue;
            separators.add(k);
        }
        if (separators.size() > 0) {
            builder.addAllSeparators(separators);
        }
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static  @NotNull ProtoFeature.MultiPolygon.Builder multiPolygon2Proto(@NotNull MultiPolygon multiPolygon) {
        ProtoFeature.MultiPolygon.Builder builder = ProtoFeature.MultiPolygon.newBuilder();
        int polygonNum = multiPolygon.getNumGeometries();
        LinkedList<Integer> coordSeparators = new LinkedList<Integer>();
        LinkedList<Integer> polygonSeparators = new LinkedList<Integer>();
        LinkedList<Coordinate> coordinateList = new LinkedList<Coordinate>();
        int k = -1;
        int beforePolygonSeparator = 0;
        for (int gi = 0; gi < polygonNum; ++gi) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(gi);
            int holeNum = polygon.getNumInteriorRing();
            Coordinate[] shellCoordinates = polygon.getExteriorRing().getCoordinates();
            for (int x = 0; x < shellCoordinates.length - 1; ++x) {
                ++k;
                coordinateList.add(shellCoordinates[x]);
            }
            coordSeparators.add(k);
            if (holeNum > 0) {
                for (int i = 0; i < holeNum; ++i) {
                    Coordinate[] childCoordinates = polygon.getInteriorRingN(i).getCoordinates();
                    for (int j = 0; j < childCoordinates.length - 1; ++j) {
                        ++k;
                        coordinateList.add(childCoordinates[j]);
                    }
                    coordSeparators.add(k);
                }
            }
            int currentPolygonSeparator = beforePolygonSeparator + 1 + holeNum;
            polygonSeparators.add(currentPolygonSeparator);
            beforePolygonSeparator = currentPolygonSeparator;
        }
        coordSeparators.removeLast();
        polygonSeparators.removeLast();
        if (coordSeparators.size() > 0) {
            builder.addAllCoordSeparators(coordSeparators);
        }
        if (polygonSeparators.size() > 0) {
            builder.addAllPolygonSeparators(polygonSeparators);
        }
        Coordinate[] coordinates = new Coordinate[coordinateList.size()];
        coordinateList.toArray(coordinates);
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static ProtoFeature.GeometryCollection.Builder geometryCollection2Proto(@NotNull GeometryCollection geometryCollection) {
        ProtoFeature.GeometryCollection.Builder builder = ProtoFeature.GeometryCollection.newBuilder();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            if (geometry instanceof Point) {
                builder.addPoints(ProtoFeatureConverter.point2Proto((Point)geometry));
                continue;
            }
            if (geometry instanceof LineString) {
                builder.addLineStrings(ProtoFeatureConverter.lineString2Proto((LineString)geometry));
                continue;
            }
            if (geometry instanceof Polygon) {
                builder.addPolygons(ProtoFeatureConverter.polygon2Proto((Polygon)geometry));
                continue;
            }
            if (geometry instanceof MultiPoint) {
                builder.addMultiPoints(ProtoFeatureConverter.multiPoint2Proto((MultiPoint)geometry));
                continue;
            }
            if (geometry instanceof MultiLineString) {
                builder.addMultiLineStrings(ProtoFeatureConverter.multiLineString2Proto((MultiLineString)geometry));
                continue;
            }
            if (geometry instanceof MultiPolygon) {
                builder.addMultiPolygons(ProtoFeatureConverter.multiPolygon2Proto((MultiPolygon)geometry));
                continue;
            }
            if (geometry instanceof GeometryCollection) {
                builder.addGeometryCollections(ProtoFeatureConverter.geometryCollection2Proto((GeometryCollection)geometry));
                continue;
            }
            throw new RuntimeException("\u672a\u5b9e\u73b0\u7684geometry\u7c7b\u578b " + geometry.getClass());
        }
        return builder;
    }

    public static Geometry proto2Geometry(byte @Nullable [] bytes, @NotNull GeometryFactory geometryFactory) {
        ProtoFeature.Geometry pGeometry;
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        try {
            pGeometry = ProtoFeature.Geometry.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        return ProtoFeatureConverter.proto2Geometry(pGeometry, geometryFactory);
    }

    @Nullable
    private static Geometry proto2Geometry( @NotNull ProtoFeature.Geometry pGeometry, @NotNull GeometryFactory geometryFactory) {
        if (pGeometry.hasPoint()) {
            ProtoFeature.Point pPoint = pGeometry.getPoint();
            return ProtoFeatureConverter.proto2Point(pPoint, geometryFactory);
        }
        if (pGeometry.hasLineString()) {
            ProtoFeature.LineString pLineString = pGeometry.getLineString();
            return ProtoFeatureConverter.proto2LineString(pLineString, geometryFactory);
        }
        if (pGeometry.hasPolygon()) {
            ProtoFeature.Polygon pPolygon = pGeometry.getPolygon();
            return ProtoFeatureConverter.proto2Polygon(pPolygon, geometryFactory);
        }
        if (pGeometry.hasMultiPoint()) {
            ProtoFeature.MultiPoint pMultiPoint = pGeometry.getMultiPoint();
            return ProtoFeatureConverter.proto2MultiPoint(pMultiPoint, geometryFactory);
        }
        if (pGeometry.hasMultiLineString()) {
            ProtoFeature.MultiLineString pMultiLineString = pGeometry.getMultiLineString();
            return ProtoFeatureConverter.proto2MultiLineString(pMultiLineString, geometryFactory);
        }
        if (pGeometry.hasMultiPolygon()) {
            ProtoFeature.MultiPolygon pMultiPolygon = pGeometry.getMultiPolygon();
            return ProtoFeatureConverter.proto2MultiPolygon(pMultiPolygon, geometryFactory);
        }
        if (pGeometry.hasGeometryCollection()) {
            ProtoFeature.GeometryCollection pGeometryCollection = pGeometry.getGeometryCollection();
            return ProtoFeatureConverter.proto2GeometryCollection(pGeometryCollection, geometryFactory);
        }
        if (pGeometry.hasNullGeometry()) {
            return null;
        }
        throw new RuntimeException("\u89e3\u6790pGeometry\u903b\u8f91\u9519\u8bef");
    }

    private static Coordinate @NotNull [] proto2Coordinates(@NotNull List<Double> xs, @NotNull List<Double> ys, @NotNull List<Double> zs) {
        int n = xs.size();
        Coordinate[] coordinates = new Coordinate[n];
        if (zs.size() != xs.size()) {
            for (int i = 0; i < n; ++i) {
                coordinates[i] = new Coordinate(xs.get(i).doubleValue(), ys.get(i).doubleValue());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                coordinates[i] = new Coordinate(xs.get(i).doubleValue(), ys.get(i).doubleValue(), zs.get(i).doubleValue());
            }
        }
        return coordinates;
    }

    private static Coordinate[] @NotNull [] separatorCoordinates(Coordinate @NotNull [] coordinates, @NotNull List<Integer> separators) {
        Coordinate[][] separatorCoordinates = new Coordinate[separators.size() + 1][];
        int idx = 0;
        int i = 0;
        int beforeSeparator = 0;
        for (int separator : separators) {
            int k = 0;
            Coordinate[] subCoordinate = new Coordinate[++separator - beforeSeparator];
            while (i < separator) {
                subCoordinate[k] = coordinates[i];
                ++k;
                ++i;
            }
            separatorCoordinates[idx] = subCoordinate;
            beforeSeparator = separator;
            ++idx;
        }
        int k = 0;
        Coordinate[] subCoordinate = new Coordinate[coordinates.length - i];
        while (i < coordinates.length) {
            subCoordinate[k] = coordinates[i];
            ++k;
            ++i;
        }
        separatorCoordinates[idx] = subCoordinate;
        return separatorCoordinates;
    }

    private static Point proto2Point( @NotNull ProtoFeature.Point pPoint, @NotNull GeometryFactory geometryFactory) {
        double x = pPoint.getX();
        double y = pPoint.getY();
        Coordinate coordinate = new Coordinate(x, y);
        if (pPoint.hasField(FieldDescriptor_Point_z)) {
            coordinate.setZ(pPoint.getZ());
        }
        return geometryFactory.createPoint(coordinate);
    }

    private static LineString proto2LineString( @NotNull ProtoFeature.LineString pLineString, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pLineString.getXsList(), pLineString.getYsList(), pLineString.getZsList());
        return geometryFactory.createLineString(coordinates);
    }

    private static LinearRing coordinates2LinearRing(Coordinate @NotNull [] coordinates, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] ringCoordinates = new Coordinate[coordinates.length + 1];
        System.arraycopy(coordinates, 0, ringCoordinates, 0, coordinates.length);
        ringCoordinates[coordinates.length] = coordinates[0].copy();
        return geometryFactory.createLinearRing(ringCoordinates);
    }

    private static Polygon proto2Polygon(Coordinate[] @NotNull [] separatorCoordinates, @NotNull GeometryFactory geometryFactory) {
        LinearRing shell = ProtoFeatureConverter.coordinates2LinearRing(separatorCoordinates[0], geometryFactory);
        LinearRing[] holes = new LinearRing[separatorCoordinates.length - 1];
        for (int i = 1; i < separatorCoordinates.length; ++i) {
            holes[i - 1] = ProtoFeatureConverter.coordinates2LinearRing(separatorCoordinates[i], geometryFactory);
        }
        return geometryFactory.createPolygon(shell, holes);
    }

    private static Polygon proto2Polygon( @NotNull ProtoFeature.Polygon pPolygon, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pPolygon.getXsList(), pPolygon.getYsList(), pPolygon.getZsList());
        List<Integer> separators = pPolygon.getSeparatorsList();
        if (separators.size() == 0) {
            return geometryFactory.createPolygon(ProtoFeatureConverter.coordinates2LinearRing(coordinates, geometryFactory));
        }
        return ProtoFeatureConverter.proto2Polygon(ProtoFeatureConverter.separatorCoordinates(coordinates, separators), geometryFactory);
    }

    private static MultiPoint proto2MultiPoint( @NotNull ProtoFeature.MultiPoint pMultiPoint, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiPoint.getXsList(), pMultiPoint.getYsList(), pMultiPoint.getZsList());
        return geometryFactory.createMultiPointFromCoords(coordinates);
    }

    private static MultiLineString proto2MultiLineString( @NotNull ProtoFeature.MultiLineString pMultiLineString, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiLineString.getXsList(), pMultiLineString.getYsList(), pMultiLineString.getZsList());
        List<Integer> separators = pMultiLineString.getSeparatorsList();
        if (separators.size() == 0) {
            return geometryFactory.createMultiLineString(new LineString[]{geometryFactory.createLineString(coordinates)});
        }
        Coordinate[][] separatorCoordinates = ProtoFeatureConverter.separatorCoordinates(coordinates, separators);
        LineString[] lineStrings = new LineString[separatorCoordinates.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = geometryFactory.createLineString(separatorCoordinates[i]);
        }
        return geometryFactory.createMultiLineString(lineStrings);
    }

    private static MultiPolygon proto2MultiPolygon( @NotNull ProtoFeature.MultiPolygon pMultiPolygon, @NotNull GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiPolygon.getXsList(), pMultiPolygon.getYsList(), pMultiPolygon.getZsList());
        List<Integer> list = pMultiPolygon.getPolygonSeparatorsList();
        ArrayList<Integer> polygonSeparators = new ArrayList<Integer>(list.size() + 1);
        polygonSeparators.addAll(list);
        List<Integer> coordSeparators = pMultiPolygon.getCoordSeparatorsList();
        if (polygonSeparators.size() == 0) {
            Polygon polygon = geometryFactory.createPolygon(ProtoFeatureConverter.coordinates2LinearRing(coordinates, geometryFactory));
            return geometryFactory.createMultiPolygon(new Polygon[]{polygon});
        }
        Polygon[] polygons = new Polygon[polygonSeparators.size() + 1];
        int idx = 0;
        int beforePolygonSeparator = 0;
        Coordinate[][] separatorCoordinates = ProtoFeatureConverter.separatorCoordinates(coordinates, coordSeparators);
        polygonSeparators.add(separatorCoordinates.length);
        Iterator iterator = polygonSeparators.iterator();
        while (iterator.hasNext()) {
            Polygon polygon;
            int polygonSeparator = (Integer)iterator.next();
            Coordinate[][] subSeparatorCoordinates = new Coordinate[polygonSeparator - beforePolygonSeparator][];
            int i1 = 0;
            for (int i = beforePolygonSeparator; i < polygonSeparator; ++i) {
                subSeparatorCoordinates[i1] = separatorCoordinates[i];
                ++i1;
            }
            polygons[idx] = polygon = ProtoFeatureConverter.proto2Polygon(subSeparatorCoordinates, geometryFactory);
            ++idx;
            beforePolygonSeparator = polygonSeparator;
        }
        return geometryFactory.createMultiPolygon(polygons);
    }

    private static GeometryCollection proto2GeometryCollection( @NotNull ProtoFeature.GeometryCollection pGeometryCollection, @NotNull GeometryFactory geometryFactory) {
        LinkedList<Object> geometryList = new LinkedList<Object>();
        for (ProtoFeature.Point point : pGeometryCollection.getPointsList()) {
            geometryList.add(ProtoFeatureConverter.proto2Point(point, geometryFactory));
        }
        for (ProtoFeature.LineString lineString : pGeometryCollection.getLineStringsList()) {
            geometryList.add(ProtoFeatureConverter.proto2LineString(lineString, geometryFactory));
        }
        for (ProtoFeature.Polygon polygon : pGeometryCollection.getPolygonsList()) {
            geometryList.add(ProtoFeatureConverter.proto2Polygon(polygon, geometryFactory));
        }
        for (ProtoFeature.MultiPoint multiPoint : pGeometryCollection.getMultiPointsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiPoint(multiPoint, geometryFactory));
        }
        for (ProtoFeature.MultiLineString multiLineString : pGeometryCollection.getMultiLineStringsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiLineString(multiLineString, geometryFactory));
        }
        for (ProtoFeature.MultiPolygon multiPolygon : pGeometryCollection.getMultiPolygonsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiPolygon(multiPolygon, geometryFactory));
        }
        for (ProtoFeature.GeometryCollection geometryCollection : pGeometryCollection.getGeometryCollectionsList()) {
            geometryList.add(ProtoFeatureConverter.proto2GeometryCollection(geometryCollection, geometryFactory));
        }
        Geometry[] geometries = new Geometry[geometryList.size()];
        geometryList.toArray(geometries);
        return geometryFactory.createGeometryCollection(geometries);
    }

    public static byte[] feature2Proto(@NotNull Feature feature) {
        FeatureCollection fc = new FeatureCollection();
        fc.setFeatures(List.of(feature));
        return ProtoFeatureConverter.featureCollection2Proto(fc);
    }

    private static ProtoFeature.Map.Builder putPropertiesToCell(@NotNull Map<String, Object> properties, ToProtoKeyValueCell keyValueCell) {
        ProtoFeature.Map.Builder propertiesBuilder = ProtoFeature.Map.newBuilder();
        properties.forEach((k, v) -> {
            if (null == v) {
                return;
            }
            PropertiesSetter setter = ProtoFeatureConverter.getPropertiesSetter(v);
            setter.setKey(propertiesBuilder, keyValueCell, (String)k);
            setter.setValue(propertiesBuilder, keyValueCell, v);
        });
        return propertiesBuilder;
    }

    public static byte[] featureCollection2Proto(@NotNull FeatureCollection featureCollection) {
        ProtoFeature.FeatureCollection.Builder builder = ProtoFeature.FeatureCollection.newBuilder();
        ToProtoKeyValueCell keyValueCell = new ToProtoKeyValueCell();
        if (null != featureCollection.getHeaders()) {
            ProtoFeature.Map.Builder propertiesBuilder = ProtoFeatureConverter.putPropertiesToCell(featureCollection.getHeaders(), keyValueCell);
            builder.setHeaders(propertiesBuilder);
        }
        if (null != featureCollection.getFeatures()) {
            for (Feature feature : featureCollection.getFeatures()) {
                Map<String, Object> properties = feature.getProperties();
                if (null != properties) {
                    ProtoFeature.Map.Builder propertiesBuilder = ProtoFeatureConverter.putPropertiesToCell(properties, keyValueCell);
                    builder.addPropertiess(propertiesBuilder);
                } else {
                    builder.addPropertiess(nullMap);
                }
                Geometry geometry = feature.getGeometry();
                ProtoFeature.Geometry.Builder geometryBuilder = ProtoFeatureConverter.geometry2ProtoBuilder(geometry);
                builder.addGeometries(geometryBuilder);
            }
        }
        keyValueCell.toProto(builder);
        return builder.build().toByteArray();
    }

    private static PropertiesSetter getPropertiesSetter(@NotNull Object value) {
        PropertiesSetter setter = propertiesSetterMap.get(value.getClass());
        if (null == setter) {
            if (value instanceof Map) {
                setter = mapPropertiesSetter;
            } else if (value instanceof List) {
                setter = listPropertiesSetter;
            } else {
                throw new RuntimeException("\u672a\u77e5\u5bf9\u8c61\u7c7b\u578b " + value.getClass());
            }
        }
        return setter;
    }

    public static Feature proto2feature(byte[] bytes, @NotNull GeometryFactory geometryFactory) {
        FeatureCollection fc = ProtoFeatureConverter.proto2featureCollection(bytes, geometryFactory);
        return fc.getFeatures().get(0);
    }

    @NotNull
    public static FeatureCollection proto2featureCollection(byte[] bytes, @NotNull GeometryFactory geometryFactory) {
        ProtoFeature.FeatureCollection pFeatureCollection;
        try {
            pFeatureCollection = ProtoFeature.FeatureCollection.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        FeatureCollection featureCollection = new FeatureCollection();
        FromProtoKeyValueCell keyValueCell = new FromProtoKeyValueCell(pFeatureCollection);
        if (pFeatureCollection.hasHeaders()) {
            ProtoFeature.Map pHeaders = pFeatureCollection.getHeaders();
            Map<String, Object> headers = keyValueCell.parseProperties(pHeaders);
            featureCollection.setHeaders(headers);
        }
        int featureNum = pFeatureCollection.getGeometriesCount();
        ArrayList<Feature> features = new ArrayList<Feature>(featureNum);
        for (int i = 0; i < featureNum; ++i) {
            Feature feature = new Feature();
            ProtoFeature.Geometry pGeometry = pFeatureCollection.getGeometries(i);
            Geometry geometry = ProtoFeatureConverter.proto2Geometry(pGeometry, geometryFactory);
            feature.setGeometry(geometry);
            ProtoFeature.Map pProperties = pFeatureCollection.getPropertiess(i);
            feature.setProperties(keyValueCell.parseProperties(pProperties));
            features.add(feature);
        }
        featureCollection.setFeatures(features);
        return featureCollection;
    }

    static {
        PropertiesSetter doublePropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addDoubleKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addDoubleValueIds(keyValueCell.doubleValues.getId((Double)value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(2);
                propertiesBuilder.addDoubleValueIds(keyValueCell.doubleValues.getId((Double)value));
            }
        };
        PropertiesSetter floatPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addFloatKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addFloatValueIds(keyValueCell.floatValues.getId((Float)value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(3);
                propertiesBuilder.addFloatValueIds(keyValueCell.floatValues.getId((Float)value));
            }
        };
        PropertiesSetter sint32PropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addSint32KeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addSint32ValueIds(keyValueCell.sint32Values.getId((Integer)value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(4);
                propertiesBuilder.addSint32ValueIds(keyValueCell.sint32Values.getId((Integer)value));
            }
        };
        PropertiesSetter sint64PropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addSint64KeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addSint64ValueIds(keyValueCell.sint64Values.getId((Long)value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(5);
                propertiesBuilder.addSint64ValueIds(keyValueCell.sint64Values.getId((Long)value));
            }
        };
        PropertiesSetter boolPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addBoolKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addBoolValues((Boolean)value);
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(6);
                propertiesBuilder.addBoolValues((Boolean)value);
            }
        };
        PropertiesSetter stringPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addStringKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addStringValueIds(keyValueCell.stringValues.getId((String)value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(7);
                propertiesBuilder.addStringValueIds(keyValueCell.stringValues.getId((String)value));
            }
        };
        PropertiesSetter bytesPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addBytesKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addBytesValueIds(keyValueCell.bytesValues.getId((byte[])value));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(8);
                propertiesBuilder.addBytesValueIds(keyValueCell.bytesValues.getId((byte[])value));
            }
        };
        mapPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addSubMapKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                ProtoFeature.Map.Builder subBuilder = this.createMapBuilder(keyValueCell, value);
                propertiesBuilder.addSubMapValues(subBuilder);
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(9);
                ProtoFeature.Map.Builder subBuilder = this.createMapBuilder(keyValueCell, value);
                propertiesBuilder.addMapValues(subBuilder);
            }

            private ProtoFeature.Map.Builder createMapBuilder(ToProtoKeyValueCell keyValueCell, Object value) {
                Map subProperties = (Map)value;
                ProtoFeature.Map.Builder subBuilder = ProtoFeatureConverter.putPropertiesToCell(subProperties, keyValueCell);
                return subBuilder;
            }
        };
        listPropertiesSetter = new PropertiesSetter(){

            @Override
            public void setKey( @NotNull ProtoFeature.Map.Builder propertiesBuilder, @NotNull ToProtoKeyValueCell keyValueCell, String key) {
                propertiesBuilder.addListKeyIds(keyValueCell.keys.getId(key));
            }

            @Override
            public void setValue( @NotNull ProtoFeature.Map.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                ProtoFeature.List.Builder listBuilder = this.createListBuilder(keyValueCell, value);
                propertiesBuilder.addListValues(listBuilder);
            }

            @Override
            public void setValue( @NotNull ProtoFeature.List.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell, Object value) {
                propertiesBuilder.addIndexes(10);
                ProtoFeature.List.Builder listBuilder = this.createListBuilder(keyValueCell, value);
                propertiesBuilder.addSubListValues(listBuilder);
            }

            private ProtoFeature.List.Builder createListBuilder(ToProtoKeyValueCell keyValueCell, Object value) {
                ProtoFeature.List.Builder builder = ProtoFeature.List.newBuilder();
                List listProperties = (List)value;
                for (Object v : listProperties) {
                    if (null == v) continue;
                    PropertiesSetter setter = ProtoFeatureConverter.getPropertiesSetter(v);
                    setter.setValue(builder, keyValueCell, v);
                }
                return builder;
            }
        };
        Map.Entry[] entries = new Map.Entry[]{new AbstractMap.SimpleEntry<Class<Double>, 1>(Double.TYPE, doublePropertiesSetter), new AbstractMap.SimpleEntry<Class<Double>, 1>(Double.class, doublePropertiesSetter), new AbstractMap.SimpleEntry<Class<Float>, 2>(Float.TYPE, floatPropertiesSetter), new AbstractMap.SimpleEntry<Class<Float>, 2>(Float.class, floatPropertiesSetter), new AbstractMap.SimpleEntry<Class<Integer>, 3>(Integer.TYPE, sint32PropertiesSetter), new AbstractMap.SimpleEntry<Class<Integer>, 3>(Integer.class, sint32PropertiesSetter), new AbstractMap.SimpleEntry<Class<Long>, 4>(Long.TYPE, sint64PropertiesSetter), new AbstractMap.SimpleEntry<Class<Long>, 4>(Long.class, sint64PropertiesSetter), new AbstractMap.SimpleEntry<Class<Boolean>, 5>(Boolean.TYPE, boolPropertiesSetter), new AbstractMap.SimpleEntry<Class<Boolean>, 5>(Boolean.class, boolPropertiesSetter), new AbstractMap.SimpleEntry<Class<String>, 6>(String.class, stringPropertiesSetter), new AbstractMap.SimpleEntry<Class<byte[]>, 7>(byte[].class, bytesPropertiesSetter), new AbstractMap.SimpleEntry<Class<HashMap>, PropertiesSetter>(HashMap.class, mapPropertiesSetter), new AbstractMap.SimpleEntry<Class<ArrayList>, PropertiesSetter>(ArrayList.class, listPropertiesSetter), new AbstractMap.SimpleEntry<Class<LinkedList>, PropertiesSetter>(LinkedList.class, listPropertiesSetter)};
        propertiesSetterMap = Map.ofEntries(entries);
    }

    private static final class FromProtoKeyValueCell {
        @NotNull
        private final HashMap<Integer, String> keyMap;
        @NotNull
        private final HashMap<Integer, Double> doubleValueMap;
        @NotNull
        private final HashMap<Integer, Float> floatValueMap;
        @NotNull
        private final HashMap<Integer, Integer> sint32ValueMap;
        @NotNull
        private final HashMap<Integer, Long> sint64ValueMap;
        @NotNull
        private final HashMap<Integer, String> stringValueMap;
        @NotNull
        private final HashMap<Integer, byte[]> bytesValueMap;

        public FromProtoKeyValueCell( @NotNull ProtoFeature.FeatureCollection pFeatureCollection) {
            int i;
            int n = pFeatureCollection.getKeysCount();
            this.keyMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.keyMap.put(i, pFeatureCollection.getKeys(i));
            }
            n = pFeatureCollection.getDoubleValuesCount();
            this.doubleValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.doubleValueMap.put(i, pFeatureCollection.getDoubleValues(i));
            }
            n = pFeatureCollection.getFloatValuesCount();
            this.floatValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.floatValueMap.put(i, Float.valueOf(pFeatureCollection.getFloatValues(i)));
            }
            n = pFeatureCollection.getSint32ValuesCount();
            this.sint32ValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.sint32ValueMap.put(i, pFeatureCollection.getSint32Values(i));
            }
            n = pFeatureCollection.getSint64ValuesCount();
            this.sint64ValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.sint64ValueMap.put(i, pFeatureCollection.getSint64Values(i));
            }
            n = pFeatureCollection.getStringValuesCount();
            this.stringValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.stringValueMap.put(i, pFeatureCollection.getStringValues(i));
            }
            n = pFeatureCollection.getBytesValuesCount();
            this.bytesValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.bytesValueMap.put(i, pFeatureCollection.getBytesValues(i).toByteArray());
            }
        }

        private static void putValueToMap(@NotNull HashMap<String, Object> map, @Nullable List<Integer> keyIdList, @NotNull List<Integer> valueIdList, @NotNull HashMap<Integer, String> keyMap, @NotNull Map<Integer, ?> valueMap) {
            if (null == keyIdList || keyIdList.size() == 0) {
                return;
            }
            Iterator<Integer> keyIdIterator = keyIdList.iterator();
            Iterator<Integer> valueIdIterator = valueIdList.iterator();
            while (keyIdIterator.hasNext()) {
                Integer keyId = keyIdIterator.next();
                Integer valueId = valueIdIterator.next();
                String key = keyMap.get(keyId);
                Object value = valueMap.get(valueId);
                map.put(key, value);
            }
        }

        @NotNull
        private HashMap<String, Object> parseMap( @NotNull ProtoFeature.Map pMap) {
            Iterator<GeneratedMessageV3> valueIdIterator;
            Iterator<Integer> keyIdIterator;
            String key;
            HashMap<String, Object> map = new HashMap<String, Object>();
            FromProtoKeyValueCell.putValueToMap(map, pMap.getDoubleKeyIdsList(), pMap.getDoubleValueIdsList(), this.keyMap, this.doubleValueMap);
            FromProtoKeyValueCell.putValueToMap(map, pMap.getFloatKeyIdsList(), pMap.getFloatValueIdsList(), this.keyMap, this.floatValueMap);
            FromProtoKeyValueCell.putValueToMap(map, pMap.getSint32KeyIdsList(), pMap.getSint32ValueIdsList(), this.keyMap, this.sint32ValueMap);
            FromProtoKeyValueCell.putValueToMap(map, pMap.getSint64KeyIdsList(), pMap.getSint64ValueIdsList(), this.keyMap, this.sint64ValueMap);
            Iterator<Integer> keyIdIterator2 = pMap.getBoolKeyIdsList().iterator();
            Iterator valueIterator = pMap.getBoolValuesList().stream().iterator();
            while (keyIdIterator2.hasNext()) {
                Integer keyId = keyIdIterator2.next();
                boolean value = (Boolean)valueIterator.next();
                key = this.keyMap.get(keyId);
                map.put(key, value);
            }
            FromProtoKeyValueCell.putValueToMap(map, pMap.getStringKeyIdsList(), pMap.getStringValueIdsList(), this.keyMap, this.stringValueMap);
            FromProtoKeyValueCell.putValueToMap(map, pMap.getBytesKeyIdsList(), pMap.getBytesValueIdsList(), this.keyMap, this.bytesValueMap);
            List<Integer> keyIdList = pMap.getSubMapKeyIdsList();
            if (keyIdList.size() > 0) {
                keyIdIterator = keyIdList.iterator();
                valueIdIterator = pMap.getSubMapValuesList().iterator();
                while (keyIdIterator.hasNext()) {
                    Integer keyId = keyIdIterator.next();
                    key = this.keyMap.get(keyId);
                    ProtoFeature.Map subPMap = (ProtoFeature.Map)valueIdIterator.next();
                    HashMap<String, Object> subMap = this.parseMap(subPMap);
                    map.put(key, subMap);
                }
            }
            if ((keyIdList = pMap.getListKeyIdsList()).size() > 0) {
                keyIdIterator = keyIdList.iterator();
                valueIdIterator = pMap.getListValuesList().iterator();
                while (keyIdIterator.hasNext()) {
                    Integer keyId = keyIdIterator.next();
                    key = this.keyMap.get(keyId);
                    ProtoFeature.List pList = (ProtoFeature.List)valueIdIterator.next();
                    ArrayList<Object> list = this.parseList(pList);
                    map.put(key, list);
                }
            }
            return map;
        }

        @NotNull
        private ArrayList<Object> parseList( @NotNull ProtoFeature.List pList) {
            List<Integer> indexes = pList.getIndexesList();
            Iterator<Integer> doubleValueIdsIterator = pList.getDoubleValueIdsList().iterator();
            Iterator<Integer> floatValueIdsIterator = pList.getFloatValueIdsList().iterator();
            Iterator<Integer> sint32ValueIdsIterator = pList.getSint32ValueIdsList().iterator();
            Iterator<Integer> sint64ValueIdsIterator = pList.getSint64ValueIdsList().iterator();
            Iterator<Boolean> boolValuesIterator = pList.getBoolValuesList().iterator();
            Iterator<Integer> stringValueIdsIterator = pList.getStringValueIdsList().iterator();
            Iterator<Integer> bytesValueIdsIterator = pList.getBytesValueIdsList().iterator();
            Iterator<ProtoFeature.Map> mapValuesIterator = pList.getMapValuesList().iterator();
            Iterator<ProtoFeature.List> subListValuesIterator = pList.getSubListValuesList().iterator();
            ArrayList<Object> list = new ArrayList<Object>(indexes.size());
            for (Integer index : indexes) {
                Object value;
                switch (index) {
                    case 2: {
                        Integer valueId = doubleValueIdsIterator.next();
                        value = this.doubleValueMap.get(valueId);
                        break;
                    }
                    case 3: {
                        Integer valueId = floatValueIdsIterator.next();
                        value = this.floatValueMap.get(valueId);
                        break;
                    }
                    case 4: {
                        Integer valueId = sint32ValueIdsIterator.next();
                        value = this.sint32ValueMap.get(valueId);
                        break;
                    }
                    case 5: {
                        Integer valueId = sint64ValueIdsIterator.next();
                        value = this.sint64ValueMap.get(valueId);
                        break;
                    }
                    case 6: {
                        value = boolValuesIterator.next();
                        break;
                    }
                    case 7: {
                        Integer valueId = stringValueIdsIterator.next();
                        value = this.stringValueMap.get(valueId);
                        break;
                    }
                    case 8: {
                        Integer valueId = bytesValueIdsIterator.next();
                        value = this.bytesValueMap.get(valueId);
                        break;
                    }
                    case 9: {
                        ProtoFeature.Map pMap = mapValuesIterator.next();
                        value = this.parseMap(pMap);
                        break;
                    }
                    case 10: {
                        ProtoFeature.List subList = subListValuesIterator.next();
                        value = this.parseList(subList);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u672a\u77e5index\u7c7b\u578b " + index);
                    }
                }
                list.add(value);
            }
            return list;
        }

        @NotNull
        public Map<String, Object> parseProperties( @NotNull ProtoFeature.Map pProperties) {
            return this.parseMap(pProperties);
        }
    }

    private static final class ToProtoKeyValueCell {
        private final ReusableIndex<String> keys = new ReusableIndex();
        private final ReusableIndex<Double> doubleValues = new ReusableIndex();
        private final ReusableIndex<Float> floatValues = new ReusableIndex();
        private final ReusableIndex<Integer> sint32Values = new ReusableIndex();
        private final ReusableIndex<Long> sint64Values = new ReusableIndex();
        private final ReusableIndex<String> stringValues = new ReusableIndex();
        private final ReusableIndex<byte[]> bytesValues = new ReusableIndex();

        private ToProtoKeyValueCell() {
        }

        public void toProto( @NotNull ProtoFeature.FeatureCollection.Builder builder) {
            if (this.keys.size() == 0) {
                return;
            }
            builder.addAllKeys(this.keys.toList());
            if (this.doubleValues.size() > 0) {
                builder.addAllDoubleValues(this.doubleValues.toList());
            }
            if (this.floatValues.size() > 0) {
                builder.addAllFloatValues(this.floatValues.toList());
            }
            if (this.sint32Values.size() > 0) {
                builder.addAllSint32Values(this.sint32Values.toList());
            }
            if (this.sint64Values.size() > 0) {
                builder.addAllSint64Values(this.sint64Values.toList());
            }
            if (this.stringValues.size() > 0) {
                builder.addAllStringValues(this.stringValues.toList());
            }
            if (this.bytesValues.size() > 0) {
                ArrayList<SortT> sortList = new ArrayList<SortT>(this.bytesValues.size());
                this.bytesValues.indexMap.forEach((t, id) -> sortList.add(new SortT<byte[]>((byte[])t, (int)id)));
                sortList.sort(Comparator.comparingInt(c -> c.id));
                ArrayList<ByteString> res = new ArrayList<ByteString>(this.bytesValues.indexMap.size());
                for (SortT sortT : sortList) {
                    res.add(ByteString.copyFrom((byte[])((byte[])sortT.t)));
                }
                builder.addAllBytesValues(res);
            }
        }

        private static final class SortT<T> {
            private final T t;
            private final int id;

            public SortT(T t, int id) {
                this.t = t;
                this.id = id;
            }
        }

        private static final class NoReusableIndex<T> {
            private final List<T> list = new LinkedList<T>();

            private NoReusableIndex() {
            }

            @NotNull
            public Integer getId(T t) {
                int id = this.list.size();
                this.list.add(t);
                return id;
            }

            @NotNull
            public ArrayList<T> toList() {
                ArrayList<T> res = new ArrayList<T>(this.list.size());
                res.addAll(this.list);
                return res;
            }

            public int size() {
                return this.list.size();
            }
        }

        private static final class ReusableIndex<T> {
            private int index = 0;
            private final HashMap<T, Integer> indexMap = new HashMap();

            private ReusableIndex() {
            }

            @NotNull
            public Integer getId(T t) {
                Integer id = this.indexMap.get(t);
                if (id != null) {
                    return id;
                }
                id = this.index;
                this.indexMap.put(t, id);
                ++this.index;
                return id;
            }

            @NotNull
            public ArrayList<T> toList() {
                ArrayList<SortT> sortList = new ArrayList<SortT>(this.indexMap.size());
                this.indexMap.forEach((t, id) -> sortList.add(new SortT<Object>(t, (int)id)));
                sortList.sort(Comparator.comparingInt(c -> c.id));
                ArrayList res = new ArrayList(this.indexMap.size());
                for (SortT sortT : sortList) {
                    res.add(sortT.t);
                }
                return res;
            }

            public int size() {
                return this.index;
            }
        }
    }

    private static interface PropertiesSetter {
        public void setKey(ProtoFeature.Map.Builder var1, ToProtoKeyValueCell var2, String var3);

        public void setValue(ProtoFeature.Map.Builder var1, ToProtoKeyValueCell var2, Object var3);

        public void setValue(ProtoFeature.List.Builder var1, ToProtoKeyValueCell var2, Object var3);
    }

    private static final class ProtoCoordinateCell {
        @NotNull
        private final ArrayList<Double> xs;
        @NotNull
        private final ArrayList<Double> ys;
        @Nullable
        private final ArrayList<Double> zs;

        public ProtoCoordinateCell(Coordinate @NotNull [] coordinates) {
            if (Double.isNaN(coordinates[0].getZ())) {
                this.xs = new ArrayList();
                this.ys = new ArrayList();
                this.zs = null;
                for (Coordinate coordinate : coordinates) {
                    this.xs.add(coordinate.getX());
                    this.ys.add(coordinate.getY());
                }
            } else {
                this.xs = new ArrayList();
                this.ys = new ArrayList();
                this.zs = new ArrayList();
                for (Coordinate coordinate : coordinates) {
                    this.xs.add(coordinate.getX());
                    this.ys.add(coordinate.getY());
                    this.zs.add(coordinate.getZ());
                }
            }
        }
    }
}

