/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.Rule;
import org.wso2.balana.combine.CombinerElement;
import org.wso2.balana.combine.CombinerParameter;
import org.wso2.balana.combine.RuleCombinerElement;
import org.wso2.balana.combine.RuleCombiningAlgorithm;
import org.wso2.balana.cond.VariableDefinition;
import org.wso2.balana.cond.VariableManager;

public class Policy
extends AbstractPolicy {
    private Set<VariableDefinition> definitions;

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, AbstractTarget target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, AbstractTarget target, List<Rule> rules) {
        this(id, null, combiningAlg, null, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, AbstractTarget target, List<Rule> rules) {
        this(id, version, combiningAlg, description, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion, List<Rule> rules) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion, List<Rule> rules, Set<AbstractObligation> obligations) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, obligations, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion, List<Rule> rules, Set<AbstractObligation> obligations, Set<VariableDefinition> definitions) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null, null);
        ArrayList<RuleCombinerElement> list = null;
        if (rules != null) {
            list = new ArrayList<RuleCombinerElement>();
            for (Rule rule : rules) {
                list.add(new RuleCombinerElement(rule));
            }
        }
        this.setChildren(list);
        this.definitions = definitions == null ? new HashSet<VariableDefinition>() : Collections.unmodifiableSet(new HashSet<VariableDefinition>(definitions));
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion, List<CombinerElement> ruleElements, Set<AbstractObligation> obligations, Set<VariableDefinition> definitions, List<CombinerParameter> parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null, parameters);
        if (ruleElements != null) {
            for (CombinerElement o : ruleElements) {
                if (o instanceof RuleCombinerElement) continue;
                throw new IllegalArgumentException("non-Rule in rules");
            }
        }
        this.setChildren(ruleElements);
        this.definitions = definitions == null ? new HashSet<VariableDefinition>() : Collections.unmodifiableSet(new HashSet<VariableDefinition>(definitions));
    }

    private Policy(Node root) throws ParsingException {
        super(root, "Policy", "RuleCombiningAlgId");
        String id;
        ArrayList<CombinerParameter> list;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashMap<String, ArrayList<CombinerParameter>> parameters = new HashMap<String, ArrayList<CombinerParameter>>();
        HashMap<String, Node> variableIds = new HashMap<String, Node>();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!DOMHelper.getLocalName(child).equals("VariableDefinition")) continue;
            String id2 = child.getAttributes().getNamedItem("VariableId").getNodeValue();
            if (variableIds.containsKey(id2)) {
                throw new ParsingException("multiple definitions for variable " + id2);
            }
            variableIds.put(id2, child);
        }
        VariableManager manager = new VariableManager(variableIds, metaData);
        this.definitions = new HashSet<VariableDefinition>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = DOMHelper.getLocalName(child);
            if (name.equals("Rule")) {
                rules.add(Rule.getInstance(child, metaData, manager));
                continue;
            }
            if (name.equals("RuleCombinerParameters")) {
                String ref = child.getAttributes().getNamedItem("RuleIdRef").getNodeValue();
                if (parameters.containsKey(ref)) {
                    list = (List)parameters.get(ref);
                    this.parseParameters(list, child);
                    continue;
                }
                list = new ArrayList();
                this.parseParameters(list, child);
                parameters.put(ref, list);
                continue;
            }
            if (!name.equals("VariableDefinition")) continue;
            id = child.getAttributes().getNamedItem("VariableId").getNodeValue();
            this.definitions.add(manager.getDefinition(id));
        }
        this.definitions = Collections.unmodifiableSet(this.definitions);
        ArrayList<CombinerElement> elements = new ArrayList<CombinerElement>();
        for (Rule rule : rules) {
            id = rule.getId().toString();
            list = (ArrayList)parameters.remove(id);
            elements.add(new RuleCombinerElement(rule, list));
        }
        if (!parameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Rule");
        }
        this.setChildren(elements);
    }

    private void parseParameters(List<CombinerParameter> parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("CombinerParameter")) continue;
            parameters.add(CombinerParameter.getInstance(node));
        }
    }

    public static Policy getInstance(Node root) throws ParsingException {
        if (!DOMHelper.getLocalName(root).equals("Policy")) {
            throw new ParsingException("Cannot create Policy from root of type " + DOMHelper.getLocalName(root));
        }
        return new Policy(root);
    }

    public Set getVariableDefinitions() {
        return this.definitions;
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        String xPathVersion;
        String xacmlVersionId = this.metaData.getXACMLIdentifier();
        String version = this.getVersion();
        builder.append("<Policy xmlns=\"").append(xacmlVersionId).append("\" PolicyId=\"").append(this.getId().toString()).append("\" Version=\"").append(version).append("\" RuleCombiningAlgId=\"").append(this.getCombiningAlg().getIdentifier().toString()).append("\">\n");
        String description = this.getDescription();
        if (description != null) {
            builder.append("<Description>").append(description).append("</Description>\n");
        }
        if ((xPathVersion = this.metaData.getXPathIdentifier()) != null) {
            builder.append("<PolicyDefaults><XPathVersion>").append(xPathVersion).append("</XPathVersion></PolicyDefaults>\n");
        }
        this.getTarget().encode(builder);
        for (VariableDefinition definition : this.definitions) {
            definition.encode(builder);
        }
        this.encodeCommonElements(builder);
        builder.append("</Policy>\n");
    }
}

