/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Node;
import org.wso2.balana.attr.AttributeValue;

public class AnyURIAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#anyURI";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private URI value;

    public AnyURIAttribute(URI value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = value;
    }

    public static AnyURIAttribute getInstance(Node root) throws URISyntaxException {
        return AnyURIAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static AnyURIAttribute getInstance(String value) throws URISyntaxException {
        return new AnyURIAttribute(new URI(value));
    }

    public URI getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnyURIAttribute)) {
            return false;
        }
        AnyURIAttribute other = (AnyURIAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "AnyURIAttribute: \"" + this.value.toString() + "\"";
    }

    @Override
    public String encode() {
        return this.value.toString();
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

