/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr.xacml3;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AbstractDesignator;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.MissingAttributeDetail;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.StatusDetail;

public class AttributeDesignator
extends AbstractDesignator {
    private URI type;
    private URI id;
    private String issuer;
    private boolean mustBePresent;
    private URI category;
    private static Log logger = LogFactory.getLog(AttributeDesignator.class);

    public AttributeDesignator(URI type, URI id, boolean mustBePresent, URI category) {
        this(type, id, mustBePresent, null, category);
    }

    public AttributeDesignator(URI type, URI id, boolean mustBePresent, String issuer, URI category) throws IllegalArgumentException {
        this.type = type;
        this.id = id;
        this.mustBePresent = mustBePresent;
        this.issuer = issuer;
        this.category = category;
    }

    public static AttributeDesignator getInstance(Node root) throws ParsingException {
        URI type = null;
        URI id = null;
        String issuer = null;
        URI category = null;
        boolean mustBePresent = false;
        String tagName = DOMHelper.getLocalName(root);
        if (!tagName.equals("AttributeDesignator")) {
            throw new ParsingException("AttributeDesignator cannot be constructed using type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required AttributeId missing in AttributeDesignator", e);
        }
        try {
            category = new URI(attrs.getNamedItem("Category").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required Category missing in AttributeDesignator", e);
        }
        try {
            String nodeValue = attrs.getNamedItem("MustBePresent").getNodeValue();
            if ("true".equals(nodeValue)) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Required MustBePresent missing in AttributeDesignator", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required DataType missing in AttributeDesignator", e);
        }
        try {
            Node node = attrs.getNamedItem("Issuer");
            if (node != null) {
                issuer = node.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing AttributeDesignator optional attributes", e);
        }
        return new AttributeDesignator(type, id, mustBePresent, issuer, category);
    }

    @Override
    public URI getType() {
        return this.type;
    }

    @Override
    public URI getId() {
        return this.id;
    }

    public URI getCategory() {
        return this.category;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    @Override
    public boolean evaluatesToBag() {
        return true;
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = null;
        result = context.getAttribute(this.type, this.id, this.issuer, this.category);
        if (result.indeterminate()) {
            return result;
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        if (bag.isEmpty() && this.mustBePresent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AttributeDesignator failed to resolve a value for a required attribute: " + this.id.toString()));
            }
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            ArrayList<MissingAttributeDetail> missingAttributes = new ArrayList<MissingAttributeDetail>();
            MissingAttributeDetail missingAttribute = new MissingAttributeDetail(this.id, this.type, this.category, this.issuer, null, 3);
            missingAttributes.add(missingAttribute);
            StatusDetail detail = new StatusDetail(missingAttributes);
            String message = "Couldn't find AttributeDesignator attribute";
            return new EvaluationResult(new Status(code, message, detail));
        }
        return result;
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<AttributeDesignator");
        builder.append(" AttributeId=\"").append(this.id.toString()).append("\"");
        builder.append(" DataType=\"").append(this.type.toString()).append("\"");
        builder.append(" Category=\"").append(this.category.toString()).append("\"");
        if (this.issuer != null) {
            builder.append(" Issuer=\"").append(this.issuer).append("\"");
        }
        if (this.mustBePresent) {
            builder.append(" MustBePresent=\"true\"");
        } else {
            builder.append(" MustBePresent=\"false\"");
        }
        builder.append("/>\n");
    }
}

