/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr.xacml3;

import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.attr.AttributeValue;

public class XPathAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:3.0:data-type:xpathExpression";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;
    private String xPathCategory;

    public XPathAttribute(String value, String xPathCategory) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = value == null ? "" : value;
        this.xPathCategory = xPathCategory == null ? "" : xPathCategory;
    }

    public static XPathAttribute getInstance(Node root) {
        String xPathCategory = null;
        NamedNodeMap nodeMap = root.getAttributes();
        if (nodeMap != null) {
            Node categoryNode = nodeMap.getNamedItem("XPathCategory");
            xPathCategory = categoryNode.getNodeValue();
        }
        return XPathAttribute.getInstance(root.getFirstChild().getNodeValue(), xPathCategory);
    }

    public static XPathAttribute getInstance(String value, String xPathCategory) {
        return new XPathAttribute(value, xPathCategory);
    }

    public String getValue() {
        return this.value;
    }

    public String getXPathCategory() {
        return this.xPathCategory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XPathAttribute)) {
            return false;
        }
        XPathAttribute other = (XPathAttribute)o;
        return this.value.equals(other.value) && this.xPathCategory.equals(other.xPathCategory);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String encode() {
        return this.value;
    }

    @Override
    public String encodeWithTags(boolean includeType) {
        StringBuilder builder = new StringBuilder();
        builder.append("<AttributeValue");
        if (includeType && this.getType() != null) {
            builder.append(" DataType=\"");
            builder.append(this.getType().toString());
            builder.append("\" XPathCategory=\"");
            builder.append(this.getXPathCategory());
            builder.append("\"");
        }
        builder.append(">");
        builder.append(this.encode());
        builder.append("</AttributeValue>");
        return builder.toString();
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

