/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import org.w3c.dom.Node;
import org.wso2.balana.Balana;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;

public class CombinerParameter {
    private String name;
    private AttributeValue value;

    public CombinerParameter(String name, AttributeValue value) {
        this.name = name;
        this.value = value;
    }

    public static CombinerParameter getInstance(Node root) throws ParsingException {
        String name = root.getAttributes().getNamedItem("ParameterName").getNodeValue();
        AttributeFactory attrFactory = Balana.getInstance().getAttributeFactory();
        AttributeValue value = null;
        try {
            value = attrFactory.createValue(root.getFirstChild());
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException(uie.getMessage(), uie);
        }
        return new CombinerParameter(name, value);
    }

    public String getName() {
        return this.name;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(StringBuilder builder) {
        builder.append("<CombinerParameter ParameterName=\"").append(this.getName()).append("\">\n");
        this.getValue().encode(builder);
        builder.append("</CombinerParameter>\n");
    }
}

