/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.util.Iterator;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.PolicySet;
import org.wso2.balana.combine.CombinerElement;
import org.wso2.balana.combine.CombinerParameter;

public class PolicyCombinerElement
extends CombinerElement {
    public PolicyCombinerElement(AbstractPolicy policy) {
        super(policy);
    }

    public PolicyCombinerElement(AbstractPolicy policy, List parameters) {
        super(policy, parameters);
    }

    public AbstractPolicy getPolicy() {
        return (AbstractPolicy)this.getElement();
    }

    @Override
    public void encode(StringBuilder builder) {
        if (!this.getParameters().isEmpty()) {
            AbstractPolicy policy = this.getPolicy();
            if (policy instanceof Policy) {
                this.encodeParamaters(builder, "Policy", policy.getId().toString());
            } else if (policy instanceof PolicySet) {
                this.encodeParamaters(builder, "PolicySet", policy.getId().toString());
            } else {
                PolicyReference ref = (PolicyReference)policy;
                if (ref.getReferenceType() == 0) {
                    this.encodeParamaters(builder, "Policy", ref.getReference().toString());
                } else {
                    this.encodeParamaters(builder, "PolicySet", ref.getReference().toString());
                }
            }
        }
        this.getPolicy().encode(builder);
    }

    private void encodeParamaters(StringBuilder builder, String prefix, String id) {
        Iterator it = this.getParameters().iterator();
        builder.append("<").append(prefix).append("CombinerParameters ").append(prefix).append("IdRef=\"").append(id).append("\">\n");
        while (it.hasNext()) {
            CombinerParameter param = (CombinerParameter)it.next();
            param.encode(builder);
        }
        builder.append("</").append(prefix).append("CombinerParameters>\n");
    }
}

