/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.ResultFactory;
import org.wso2.balana.xacml3.Advice;

public class PermitOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:permit-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public PermitOverridesPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected PermitOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public AbstractResult combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOneErrorD = false;
        boolean atLeastOneErrorP = false;
        boolean atLeastOneErrorDP = false;
        boolean atLeastOneDeny = false;
        AbstractResult firstIndeterminateResultD = null;
        AbstractResult firstIndeterminateResultP = null;
        AbstractResult firstIndeterminateResultDP = null;
        ArrayList<ObligationResult> denyObligations = new ArrayList<ObligationResult>();
        ArrayList<Advice> denyAdvices = new ArrayList<Advice>();
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2 || match.getResult() != 0) continue;
            AbstractResult result = policy.evaluate(context);
            int value = result.getDecision();
            if (value == 0) {
                return result;
            }
            if (value == 3) continue;
            if (value == 1) {
                atLeastOneDeny = true;
                denyAdvices.addAll(result.getAdvices());
                denyObligations.addAll(result.getObligations());
                continue;
            }
            if (value == 4) {
                atLeastOneErrorD = true;
                if (firstIndeterminateResultD != null) continue;
                firstIndeterminateResultD = result;
                continue;
            }
            if (value == 5) {
                atLeastOneErrorP = true;
                if (firstIndeterminateResultP != null) continue;
                firstIndeterminateResultP = result;
                continue;
            }
            if (value != 6) continue;
            atLeastOneErrorDP = true;
            if (firstIndeterminateResultDP != null) continue;
            firstIndeterminateResultDP = result;
        }
        if (atLeastOneErrorDP) {
            return firstIndeterminateResultDP;
        }
        if (atLeastOneErrorP && (atLeastOneErrorD || atLeastOneDeny)) {
            return ResultFactory.getFactory().getResult(6, firstIndeterminateResultP.getStatus(), context);
        }
        if (atLeastOneErrorP) {
            return ResultFactory.getFactory().getResult(5, firstIndeterminateResultP.getStatus(), context);
        }
        if (atLeastOneDeny) {
            return ResultFactory.getFactory().getResult(1, denyObligations, denyAdvices, context);
        }
        return ResultFactory.getFactory().getResult(3, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

