/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.cond.Apply;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.ExpressionHandler;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.ctx.EvaluationCtx;

public class Condition
implements Evaluatable {
    private static URI booleanIdentifier;
    private List<Expression> children;
    private Expression expression;
    private Function function;
    private boolean isVersionOne;

    public Condition(Function function, List expressions) throws IllegalArgumentException {
        this.isVersionOne = true;
        this.checkExpression(function);
        this.expression = new Apply(function, expressions);
        this.function = function;
        this.children = ((Apply)this.expression).getChildren();
    }

    public Condition(Expression expression) throws IllegalArgumentException {
        this.isVersionOne = false;
        this.checkExpression(expression);
        this.expression = expression;
        this.function = null;
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(this.expression);
        this.children = Collections.unmodifiableList(list);
    }

    private void checkExpression(Expression xpr) {
        if (!xpr.getType().equals(booleanIdentifier)) {
            throw new IllegalArgumentException("A Condition must return a boolean...cannot create with " + xpr.getType());
        }
        if (xpr.returnsBag()) {
            throw new IllegalArgumentException("A Condition must not return a Bag");
        }
    }

    public static Condition getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        if (metaData.getXACMLVersion() < 2) {
            Apply cond = Apply.getConditionInstance(root, metaData.getXPathIdentifier(), manager);
            return new Condition(cond.getFunction(), cond.getChildren());
        }
        Expression xpr = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            break;
        }
        return new Condition(xpr);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public URI getType() {
        return booleanIdentifier;
    }

    @Override
    public boolean returnsBag() {
        return false;
    }

    @Override
    public boolean evaluatesToBag() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return ((Evaluatable)this.expression).evaluate(context);
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        if (this.isVersionOne) {
            builder.append("<Condition FunctionId=\"").append(this.function.getIdentifier()).append("\">\n");
            for (Expression aChildren : this.children) {
                aChildren.encode(builder);
            }
        } else {
            builder.append("<Condition>\n");
            this.expression.encode(builder);
        }
        builder.append("</Condition>\n");
    }

    static {
        try {
            booleanIdentifier = new URI("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (Exception e) {
            booleanIdentifier = null;
        }
    }
}

