/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import org.wso2.balana.MatchResult;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.ctx.Status;

public class EvaluationResult {
    private boolean wasInd;
    private AttributeValue value;
    private Status status;
    private MatchResult matchResult;
    private static EvaluationResult falseBooleanResult;
    private static EvaluationResult trueBooleanResult;

    public EvaluationResult(AttributeValue value) {
        this.wasInd = false;
        this.value = value;
        this.status = null;
    }

    public EvaluationResult(Status status) {
        this.wasInd = true;
        this.value = null;
        this.status = status;
    }

    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    public void setMatchResult(MatchResult matchResult) {
        this.matchResult = matchResult;
    }

    public boolean indeterminate() {
        return this.wasInd;
    }

    public AttributeValue getAttributeValue() {
        return this.value;
    }

    public Status getStatus() {
        return this.status;
    }

    public static EvaluationResult getInstance(boolean value) {
        if (value) {
            return EvaluationResult.getTrueInstance();
        }
        return EvaluationResult.getFalseInstance();
    }

    public static EvaluationResult getFalseInstance() {
        if (falseBooleanResult == null) {
            falseBooleanResult = new EvaluationResult(BooleanAttribute.getFalseInstance());
        }
        return falseBooleanResult;
    }

    public static EvaluationResult getTrueInstance() {
        if (trueBooleanResult == null) {
            trueBooleanResult = new EvaluationResult(BooleanAttribute.getTrueInstance());
        }
        return trueBooleanResult;
    }
}

