/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.net.InetAddress;
import java.util.List;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.IPAddressAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;

public class IPInRangeFunction
extends FunctionBase {
    public static final String NAME = "urn:org.wso2.balana:function:ip-in-range";

    public IPInRangeFunction() {
        super(NAME, 0, "urn:oasis:names:tc:xacml:2.0:data-type:ipAddress", false, 3, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        long ipAddressMax;
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        long ipAddressToTest = IPInRangeFunction.ipToLong(((IPAddressAttribute)argValues[0]).getAddress());
        long ipAddressMin = IPInRangeFunction.ipToLong(((IPAddressAttribute)argValues[1]).getAddress());
        if (ipAddressMin > (ipAddressMax = IPInRangeFunction.ipToLong(((IPAddressAttribute)argValues[2]).getAddress()))) {
            long temp = ipAddressMax;
            ipAddressMax = ipAddressMin;
            ipAddressMin = temp;
        }
        return EvaluationResult.getInstance(ipAddressToTest >= ipAddressMin && ipAddressToTest <= ipAddressMax);
    }

    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }
}

