/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.DoubleAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;

public class RoundFunction
extends FunctionBase {
    public static final String NAME_ROUND = "urn:oasis:names:tc:xacml:1.0:function:round";

    public RoundFunction(String functionName) {
        super(NAME_ROUND, 0, "http://www.w3.org/2001/XMLSchema#double", false, 1, "http://www.w3.org/2001/XMLSchema#double", false);
        if (!functionName.equals(NAME_ROUND)) {
            throw new IllegalArgumentException("unknown round function: " + functionName);
        }
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_ROUND);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        double arg = ((DoubleAttribute)argValues[0]).getValue();
        BigDecimal roundValue = new BigDecimal(arg);
        return new EvaluationResult(new DoubleAttribute(roundValue.setScale(0, RoundingMode.HALF_EVEN).doubleValue()));
    }
}

